/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.ZipFileBindingBuildPathEntry;
import org.eclipse.edt.compiler.internal.core.lookup.IZipFileBindingBuildPathEntry;
import org.eclipse.edt.ide.core.IIDECompiler;
import org.eclipse.edt.ide.core.internal.lookup.EglarBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.MofarBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.WrapperedZipFileBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyEglarBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyMofarBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.utils.AbsolutePathUtility;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.IZipFileEntryManager;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.ZipFileObjectStore;

public class ZipFileBuildPathEntryManager {
    public static final String MOFAR_EXTENSION = "mofar";
    public static final String EGLAR_EXTENSION = "eglar";
    private static final ZipFileBuildPathEntryManager INSTANCE = new ZipFileBuildPathEntryManager(false);
    private static final ZipFileBuildPathEntryManager WCC_INSTANCE = new ZipFileBuildPathEntryManager(true);
    private boolean isWCC;
    private Map<Object, Map<IPath, IZipFileBindingBuildPathEntry>> zipfileProjectEntries;
    private Map<ICompiler, Map<IPath, ZipFileBindingBuildPathEntry>> systemEntriesByCompiler = new HashMap<ICompiler, Map<IPath, ZipFileBindingBuildPathEntry>>();

    private ZipFileBuildPathEntryManager(boolean isWCC) {
        this.isWCC = isWCC;
        this.init();
    }

    private void init() {
        this.zipfileProjectEntries = new HashMap<Object, Map<IPath, IZipFileBindingBuildPathEntry>>();
    }

    public static ZipFileBuildPathEntryManager getInstance() {
        return INSTANCE;
    }

    public static ZipFileBuildPathEntryManager getWCCInstance() {
        return WCC_INSTANCE;
    }

    protected Map<IPath, IZipFileBindingBuildPathEntry> getProjectEntry(Object project) {
        Map<IPath, IZipFileBindingBuildPathEntry> retVal = this.zipfileProjectEntries.get(project);
        if (retVal == null) {
            retVal = new HashMap<IPath, IZipFileBindingBuildPathEntry>();
            this.zipfileProjectEntries.put(project, retVal);
        }
        return retVal;
    }

    public IZipFileBindingBuildPathEntry getZipFileBuildPathEntry(Object project, IPath zipfilepath) {
        Map<IPath, IZipFileBindingBuildPathEntry> projectMap = this.getProjectEntry(project);
        IZipFileBindingBuildPathEntry result = projectMap.get(zipfilepath);
        if (result == null) {
            result = this.createSystemEntry(project, zipfilepath);
            if (result == null) {
                result = this.isWCC ? this.createEntry(WorkingCopyProjectEnvironmentManager.getInstance().getProjectEnvironment((IProject)project), zipfilepath) : this.createEntry(ProjectEnvironmentManager.getInstance().getProjectEnvironment((IProject)project), zipfilepath);
            }
            projectMap.put(zipfilepath, result);
        }
        return result;
    }

    private Map<IPath, ZipFileBindingBuildPathEntry> createSystemEntries(ICompiler compiler) {
        HashMap<IPath, ZipFileBindingBuildPathEntry> map = new HashMap<IPath, ZipFileBindingBuildPathEntry>();
        for (ZipFileBindingBuildPathEntry entry : compiler.getSystemBuildPathEntries()) {
            map.put((IPath)new Path(entry.getID()), entry);
        }
        return map;
    }

    private IZipFileBindingBuildPathEntry createSystemEntry(Object project, IPath zipfilepath) {
        ZipFileBindingBuildPathEntry entry;
        if (!(project instanceof IProject)) {
            return null;
        }
        IIDECompiler compiler = ProjectSettingsUtility.getCompiler((IProject)project);
        if (compiler == null) {
            return null;
        }
        Map<IPath, ZipFileBindingBuildPathEntry> map = this.systemEntriesByCompiler.get(compiler);
        if (map == null) {
            map = this.createSystemEntries(compiler);
            this.systemEntriesByCompiler.put(compiler, map);
        }
        if ((entry = map.get(zipfilepath)) == null) {
            return null;
        }
        return new WrapperedZipFileBuildPathEntry(entry, (IProject)project);
    }

    private IZipFileBindingBuildPathEntry createEntry(ProjectEnvironment env, IPath path) {
        String extension = path.getFileExtension();
        if (extension.equalsIgnoreCase(MOFAR_EXTENSION)) {
            MofarBuildPathEntry entry = new MofarBuildPathEntry(env, path, ".mofxml");
            ZipFileObjectStore store = new ZipFileObjectStore(new File(AbsolutePathUtility.getAbsolutePathString(path)), (IEnvironment)env.getIREnvironment(), "XML", ".mofxml", (IZipFileEntryManager)entry);
            entry.setStore((ObjectStore)store);
            return entry;
        }
        if (extension.equalsIgnoreCase(EGLAR_EXTENSION)) {
            EglarBuildPathEntry entry = new EglarBuildPathEntry(env, path, ".eglxml");
            ZipFileObjectStore store = new ZipFileObjectStore(new File(AbsolutePathUtility.getAbsolutePathString(path)), (IEnvironment)env.getIREnvironment(), "XML", ".eglxml", "egl", (IZipFileEntryManager)entry);
            entry.setStore((ObjectStore)store);
            return entry;
        }
        return null;
    }

    private IZipFileBindingBuildPathEntry createEntry(WorkingCopyProjectEnvironment env, IPath path) {
        String extension = path.getFileExtension();
        if (extension.equalsIgnoreCase(MOFAR_EXTENSION)) {
            WorkingCopyMofarBuildPathEntry entry = new WorkingCopyMofarBuildPathEntry((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)env, path, ".mofxml");
            ZipFileObjectStore store = new ZipFileObjectStore(new File(AbsolutePathUtility.getAbsolutePathString(path)), (IEnvironment)env.getIREnvironment(), "XML", ".mofxml", (IZipFileEntryManager)entry);
            entry.setStore((ObjectStore)store);
            return entry;
        }
        if (extension.equalsIgnoreCase(EGLAR_EXTENSION)) {
            WorkingCopyEglarBuildPathEntry entry = new WorkingCopyEglarBuildPathEntry((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)env, path, ".eglxml");
            ZipFileObjectStore store = new ZipFileObjectStore(new File(AbsolutePathUtility.getAbsolutePathString(path)), (IEnvironment)env.getIREnvironment(), "XML", ".eglxml", "egl", (IZipFileEntryManager)entry);
            entry.setStore((ObjectStore)store);
            return entry;
        }
        return null;
    }

    public void clear() {
        this.zipfileProjectEntries.clear();
    }

    public void clear(IProject project) {
        Map<IPath, IZipFileBindingBuildPathEntry> projectMap = this.zipfileProjectEntries.get(project);
        if (projectMap != null) {
            for (IZipFileBindingBuildPathEntry result : projectMap.values()) {
                if (result == null) continue;
                result.clear();
            }
        }
        this.zipfileProjectEntries.remove(project);
    }

    public int getCount() {
        return this.zipfileProjectEntries.size();
    }
}

