/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import java.util.List;
import java.util.Stack;
import org.eclipse.edt.ide.core.internal.errors.DummyParseNode;
import org.eclipse.edt.ide.core.internal.errors.ErrorGrammar;
import org.eclipse.edt.ide.core.internal.errors.NonTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.ParseStackEntry;
import org.eclipse.edt.ide.core.internal.errors.Reporter;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;

public class ParseStack
implements Cloneable {
    private ErrorGrammar grammar = ErrorGrammar.getInstance();
    private Stack stack = new Stack();

    public ParseStack() {
        this.stack.push(new ParseStackEntry(this.grammar.getStartState(), new DummyParseNode()));
    }

    private boolean isTerminalOrConnector(ParseNode node) {
        return node.isTerminal() || node.isWhiteSpace();
    }

    private NonTerminalNode findRMConnectorOrTerminalParent(NonTerminalNode subtreeRoot) {
        ParseNode[] children = subtreeRoot.children;
        if (children == null) {
            return null;
        }
        int position = children.length - 1;
        while (position >= 0) {
            ParseNode child = children[position];
            if (this.isTerminalOrConnector(child)) {
                return subtreeRoot;
            }
            NonTerminalNode result = this.findRMConnectorOrTerminalParent((NonTerminalNode)child);
            if (result != null) {
                return result;
            }
            --position;
        }
        return null;
    }

    private int findConnectorOrTerminalPos(NonTerminalNode parent) {
        ParseNode[] children = parent.children;
        int i = children.length - 1;
        while (i >= 0) {
            if (this.isTerminalOrConnector(children[i])) {
                return i;
            }
            --i;
        }
        throw new IllegalArgumentException();
    }

    private void addToConnector(NonTerminalNode connector, ParseNode whitespaceNode) {
        NonTerminalNode wsPair = new NonTerminalNode(4, new ParseNode[]{connector.children[1], whitespaceNode});
        connector.children[1] = wsPair;
    }

    public void connect(ParseNode whitespaceNode) {
        if (whitespaceNode == null) {
            return;
        }
        int distanceFromTop = 0;
        while (true) {
            ParseStackEntry stackEntry = (ParseStackEntry)this.stack.elementAt(this.stack.size() - 1 - distanceFromTop);
            ParseNode node = stackEntry.node;
            if (node.isTerminal()) {
                stackEntry.node = this.createConnector((TerminalNode)node, whitespaceNode);
                return;
            }
            if (node.isWhiteSpace()) {
                this.addToConnector((NonTerminalNode)node, whitespaceNode);
                return;
            }
            NonTerminalNode parent = this.findRMConnectorOrTerminalParent((NonTerminalNode)node);
            if (parent != null) {
                ParseNode terminalOrConnector = parent.children[this.findConnectorOrTerminalPos(parent)];
                if (terminalOrConnector.isTerminal()) {
                    parent.children[this.findConnectorOrTerminalPos((NonTerminalNode)parent)] = this.createConnector((TerminalNode)terminalOrConnector, whitespaceNode);
                    return;
                }
                this.addToConnector((NonTerminalNode)terminalOrConnector, whitespaceNode);
                return;
            }
            ++distanceFromTop;
        }
    }

    private NonTerminalNode createConnector(TerminalNode terminalNode, ParseNode whitespaceNode) {
        return new NonTerminalNode(2, new ParseNode[]{terminalNode, whitespaceNode});
    }

    public void shift(ParseNode node) {
        int shiftedState;
        if (node.isTerminal()) {
            TerminalNode terminalNode = (TerminalNode)node;
            shiftedState = this.grammar.getTerminalAction(this.getCurrentState(), terminalNode) - 1;
        } else {
            NonTerminalNode nonTerminalNode = (NonTerminalNode)node;
            shiftedState = this.grammar.getGotoState(this.getCurrentState(), nonTerminalNode);
        }
        if (shiftedState < 0) {
            throw new IllegalArgumentException();
        }
        Reporter.getInstance().shift(node, shiftedState);
        this.stack.push(new ParseStackEntry(shiftedState, node));
    }

    public void reduce(int ruleNumber) {
        Reporter.getInstance().reduce(ruleNumber);
        int handleSize = this.grammar.getHandleSize(ruleNumber);
        ParseNode[] children = handleSize == 0 ? null : new ParseNode[handleSize];
        int i = handleSize - 1;
        while (i >= 0) {
            ParseStackEntry stackEntry = (ParseStackEntry)this.stack.pop();
            children[i] = stackEntry.node;
            --i;
        }
        int nonTerminalType = this.grammar.getLHS(ruleNumber);
        NonTerminalNode parent = new NonTerminalNode(nonTerminalType, children);
        parent.ruleNumber = ruleNumber;
        this.grammar.getGotoState(this.getCurrentState(), parent);
        this.shift(parent);
    }

    public int getCurrentState() {
        ParseStackEntry stackEntry = (ParseStackEntry)this.stack.peek();
        return stackEntry.state;
    }

    public ParseNode getTopOfStackNode() {
        ParseStackEntry stackEntry = (ParseStackEntry)this.stack.peek();
        return stackEntry.node;
    }

    public ParseStack copy() {
        try {
            ParseStack result = (ParseStack)super.clone();
            result.stack = (Stack)this.stack.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        buffer.append(this.stack.elementAt(0).toString());
        int i = 1;
        while (i < this.stack.size()) {
            buffer.append(' ');
            buffer.append(this.stack.elementAt(i).toString());
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }

    public ParseNode[] deleteContext(int contextDeleted) {
        List stackEntries = this.stack.subList(this.stack.size() - contextDeleted, this.stack.size());
        ParseNode[] result = new ParseNode[contextDeleted];
        int i = 0;
        while (i < contextDeleted) {
            ParseStackEntry stackEntry = (ParseStackEntry)stackEntries.get(i);
            result[i] = stackEntry.node;
            ++i;
        }
        stackEntries.clear();
        return result;
    }

    public int availableContext() {
        return this.stack.size() - 1;
    }

    public boolean isTerminalShiftable(int terminalType) {
        int action = this.grammar.getTerminalAction(this.getCurrentState(), terminalType);
        if (action > 0) {
            return true;
        }
        if (action == 0) {
            return false;
        }
        ParseStack copiedStack = this.copy();
        copiedStack.performAllReductions(terminalType);
        return copiedStack.isTerminalShiftable(terminalType);
    }

    public void performAllReductions(int terminalType) {
        int action;
        while ((action = this.grammar.getTerminalAction(this.getCurrentState(), terminalType)) < 0) {
            int ruleNumber = -action - 1;
            this.reduce(ruleNumber);
        }
    }

    public void performDefaultReductions() {
        int defaultRule;
        while ((defaultRule = this.grammar.getLRZeroReduceRule(this.getCurrentState())) > 0) {
            this.reduce(defaultRule);
        }
    }

    public Stack getStack() {
        return this.stack;
    }
}

