/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import org.eclipse.edt.ide.core.internal.errors.AbstractRecoverer;
import org.eclipse.edt.ide.core.internal.errors.ErrorMarkerCollector;
import org.eclipse.edt.ide.core.internal.errors.ErrorNonTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.ErrorTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.NonTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.internal.errors.Reporter;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;
import org.eclipse.edt.ide.core.internal.errors.TokenStream;

public class MissingTerminalRecoverer
extends AbstractRecoverer {
    int bestDistance;
    TerminalNode bestCandidate;

    @Override
    public int recoverDistance(ParseStack stack, TokenStream tokenStream) {
        this.bestCandidate = null;
        this.bestDistance = -1;
        short[] terminalCandidates = this.grammar.getTerminalCandidates(stack.getCurrentState());
        int i = 0;
        while (i < terminalCandidates.length) {
            ErrorTerminalNode curCandidate = new ErrorTerminalNode(terminalCandidates[i]);
            int curDistance = this.recoveryDistance(curCandidate, stack, tokenStream);
            if (curDistance > this.bestDistance) {
                this.bestCandidate = curCandidate;
                this.bestDistance = curDistance;
            }
            ++i;
        }
        return this.bestDistance;
    }

    private int recoveryDistance(TerminalNode candidate, ParseStack stack, TokenStream tokenStream) {
        stack = stack.copy();
        tokenStream = tokenStream.copy();
        this.processTerminal(stack, candidate);
        int distance = this.tryParseAhead(stack, tokenStream);
        Reporter.getInstance().missingTerminalDistance(candidate.terminalType, distance);
        return distance;
    }

    @Override
    public void recover(ParseStack stack, TokenStream tokenStream) {
        ParseNode errorNode;
        Reporter.getInstance().recoverMissingTerminal(this.bestCandidate.terminalType);
        this.performAllReductions(stack, this.bestCandidate);
        ParseStack tempStack = stack.copy();
        this.processTerminal(tempStack, this.bestCandidate);
        ParseNode highestSymbol = this.getHighestSymbol(tempStack, tokenStream.lookAhead());
        if (highestSymbol.isTerminal()) {
            TerminalNode hsTerminal = (TerminalNode)highestSymbol;
            errorNode = new ErrorTerminalNode(hsTerminal.terminalType);
        } else {
            NonTerminalNode hsNonTerminal = (NonTerminalNode)highestSymbol;
            errorNode = new ErrorNonTerminalNode(hsNonTerminal.nonTerminalType);
        }
        stack.shift(errorNode);
        this.errorMessage(stack, tokenStream, tokenStream.lookAhead());
    }

    @Override
    public void errorMessage(ParseStack stack, TokenStream tokenStream, TerminalNode errorTerminal) {
        String message = "\tMissing " + this.getHighestSymbolName(stack.copy(), tokenStream.lookAhead());
        ErrorMarkerCollector.instance.add(errorTerminal.offset, errorTerminal.offset + errorTerminal.text.length(), errorTerminal.line, message);
    }
}

