/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public class ErrorMarkerCollector {
    public static final ErrorMarkerCollector instance = new ErrorMarkerCollector();
    private ArrayList markerList;

    private ErrorMarkerCollector() {
    }

    public int getNumErrors() {
        return this.markerList.size();
    }

    public void reset() {
        this.markerList = new ArrayList();
    }

    public void add(int startOffset, int endOffset, int line, String message) {
        this.markerList.add(new ErrorMarkerInfo(startOffset, endOffset, line, message));
    }

    public void createMarkers(IFile file) {
        try {
            if (this.markerList.size() > 0) {
                file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            }
            for (ErrorMarkerInfo info : this.markerList) {
                IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)info.message.trim());
                marker.setAttribute("charStart", info.startOffset);
                marker.setAttribute("charEnd", info.endOffset);
                String OFFSET = "offset 0000";
                marker.setAttribute("location", (Object)(String.valueOf(OFFSET.substring(0, 11 - Integer.toString(info.startOffset).length())) + info.startOffset));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static class ErrorMarkerInfo {
        int startOffset;
        int endOffset;
        int line;
        String message;

        public ErrorMarkerInfo(int startOffset, int endOffset, int line, String message) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.line = line;
            this.message = message;
        }
    }
}

