/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.dependency;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.ide.core.internal.dependency.SerializationManager;

public class IOPool {
    private HashMap modifiedEntries = new HashMap();
    private HashSet removedEntries = new HashSet();
    private HashMap unmodifiedEntries = new HashMap();

    public int size() {
        return this.modifiedEntries.size() + this.removedEntries.size() + this.unmodifiedEntries.size();
    }

    public void remove(IPath bufferPath) {
        this.removedEntries.add(bufferPath);
        if (this.modifiedEntries.containsKey(bufferPath)) {
            this.modifiedEntries.remove(bufferPath);
        } else if (this.unmodifiedEntries.containsKey(bufferPath)) {
            this.unmodifiedEntries.remove(bufferPath);
        }
    }

    public void put(IPath bufferPath, HashMap value) {
        this.modifiedEntries.put(bufferPath, value);
        if (this.removedEntries.contains(bufferPath)) {
            this.removedEntries.remove(bufferPath);
        } else if (this.unmodifiedEntries.containsKey(bufferPath)) {
            this.unmodifiedEntries.remove(bufferPath);
        }
    }

    public HashMap get(IPath bufferPath) {
        if (this.removedEntries.contains(bufferPath)) {
            return null;
        }
        HashMap value = (HashMap)this.modifiedEntries.get(bufferPath);
        if (value != null) {
            return value;
        }
        if (this.unmodifiedEntries.containsKey(bufferPath)) {
            return (HashMap)this.unmodifiedEntries.get(bufferPath);
        }
        try {
            value = this.readEntry(bufferPath);
            this.unmodifiedEntries.put(bufferPath, value);
            return value;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private HashMap readEntry(IPath bufferPath) throws IOException {
        return SerializationManager.getInstance().deserialize(bufferPath);
    }

    private void clearPool() {
        try {
            try {
                for (IPath bufferPath : this.removedEntries) {
                    bufferPath.toFile().delete();
                }
                for (IPath bufferPath : this.modifiedEntries.keySet()) {
                    HashMap value = (HashMap)this.modifiedEntries.get(bufferPath);
                    SerializationManager.getInstance().serialize(bufferPath, value);
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            this.clear();
        }
    }

    public void clear() {
        this.removedEntries.clear();
        this.modifiedEntries.clear();
        this.unmodifiedEntries.clear();
    }

    public void flush() {
        this.clearPool();
    }
}

