/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.dependency;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.ide.core.internal.dependency.AbstractDependencyInfo;
import org.eclipse.edt.ide.core.internal.dependency.Function;
import org.eclipse.edt.ide.core.internal.dependency.IDependencyInfo;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.utils.NameUtile;

public class DependencyInfo
extends AbstractDependencyInfo
implements IDependencyInfo,
IDependencyRequestor {
    private Set<String> simpleNames = new HashSet<String>();
    private Set<String> qualifiedNames = new HashSet<String>();

    public Set getQualifiedNames() {
        return Collections.unmodifiableSet(this.qualifiedNames);
    }

    public Set getSimpleNames() {
        return Collections.unmodifiableSet(this.simpleNames);
    }

    public void recordName(Name name) {
        if (name.isSimpleName()) {
            this.recordSimpleName(name.getIdentifier());
        } else if (name.isQualifiedName()) {
            this.recordQualifiedName(NameUtile.getAsName((String)((QualifiedName)name).getNameComponents()));
        }
    }

    public void recordSimpleName(String simpleName) {
        if (!this.containsSimpleName(simpleName)) {
            this.addSimpleName(simpleName);
        }
    }

    public void recordPackageBinding(IPackageBinding packageBinding) {
        this.recordQualifiedName(NameUtile.getAsName((String)packageBinding.getPackageName()));
    }

    public void recordType(Type type) {
        if (type == null) {
            return;
        }
        if (type instanceof AnnotationType) {
            return;
        }
        if (type instanceof ArrayType) {
            this.recordType(((ArrayType)type).getElementType());
            return;
        }
        if (type instanceof Function || type instanceof Constructor) {
            return;
        }
        if (type instanceof StructPart) {
            List extendedTypes = ((StructPart)type).getSuperTypes();
            for (StructPart struct : extendedTypes) {
                this.doRecordTypeBinding((Type)struct);
            }
        }
        this.doRecordTypeBinding(type);
    }

    private void doRecordTypeBinding(Type type) {
        this.recordQualifiedName(NameUtile.getAsName((String)type.getTypeSignature()));
    }

    @Override
    protected void recordQualifiedName(String qualifiedName) {
        if (qualifiedName.length() == 0) {
            return;
        }
        int lastDot = qualifiedName.lastIndexOf(46);
        while (lastDot != -1) {
            if (this.containsQualifiedName(qualifiedName)) {
                qualifiedName = null;
                lastDot = -1;
                continue;
            }
            this.addQualifiedName(qualifiedName);
            this.recordSimpleName(NameUtile.getAsName((String)qualifiedName.substring(lastDot + 1)));
            qualifiedName = qualifiedName.substring(0, lastDot);
            lastDot = qualifiedName.lastIndexOf(46);
        }
        if (qualifiedName != null) {
            this.recordSimpleName(qualifiedName);
        }
    }

    private void addSimpleName(String simpleName) {
        this.simpleNames.add(simpleName);
    }

    private void addQualifiedName(String qualifiedName) {
        this.qualifiedNames.add(qualifiedName);
    }

    private boolean containsSimpleName(String simpleName) {
        return this.simpleNames.contains(simpleName);
    }

    private boolean containsQualifiedName(String qualifiedName) {
        return this.qualifiedNames.contains(qualifiedName);
    }
}

