/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.compiler.internal.core.builder.CancelledException;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.ide.core.internal.builder.BuilderResources;

public class BuildNotifier
implements IBuildNotifier {
    protected IProgressMonitor monitor;
    protected float percentComplete;
    protected float progressPerEGLPart;
    protected int workDone;
    protected int totalWork;
    protected String previousSubtask;
    protected boolean aborted;

    public BuildNotifier(IProgressMonitor monitor) {
        this(monitor, 1000000);
    }

    public BuildNotifier(IProgressMonitor monitor, int totalWork) {
        this.monitor = monitor;
        this.workDone = 0;
        this.totalWork = totalWork;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public void compiled() {
        this.updateProgressDelta(this.progressPerEGLPart);
        this.checkCancel();
    }

    public void begin() {
        if (this.monitor != null) {
            this.monitor.beginTask("", this.totalWork);
        }
        this.previousSubtask = null;
    }

    public void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new CancelledException();
        }
    }

    public void done() {
        this.updateProgress(1.0f);
        if (!(this.monitor instanceof SubProgressMonitor)) {
            this.subTask(BuilderResources.buildDone);
        }
        if (this.monitor != null) {
            this.monitor.done();
        }
        this.previousSubtask = null;
    }

    public void setProgressPerEGLPart(float progress) {
        this.progressPerEGLPart = progress;
    }

    public void subTask(String message) {
        if (message.equals(this.previousSubtask)) {
            return;
        }
        if (this.monitor != null) {
            this.monitor.subTask(message);
        }
        this.previousSubtask = message;
    }

    public void updateProgress(float percentComplete) {
        if (percentComplete > this.percentComplete) {
            this.percentComplete = Math.min(percentComplete, 1.0f);
            int work = Math.round(this.percentComplete * (float)this.totalWork);
            if (work > this.workDone) {
                if (this.monitor != null) {
                    this.monitor.worked(work - this.workDone);
                }
                this.workDone = work;
            }
        }
    }

    public void updateProgressDelta(float percentWorked) {
        this.updateProgress(this.percentComplete + percentWorked);
    }

    public IBuildNotifier createSubNotifier(float percentFromRemaining) {
        int subWork = (int)((float)(this.totalWork - this.workDone) * percentFromRemaining);
        return new BuildNotifier((IProgressMonitor)new SubProgressMonitor(this.monitor, subWork), subWork);
    }
}

