/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.bindings;

public abstract class AbstractImportContainer {
    private String fullImport = "";
    private String file = null;
    private String folder = null;
    private static final char[] tokens = new char[]{'\\', '/'};

    public AbstractImportContainer(String importStatement) {
        this.fullImport = importStatement;
    }

    public String getFullImportPath() {
        return this.fullImport;
    }

    public String getFile() {
        if (this.file == null) {
            if (this.fullImport != null) {
                this.tokenize(this.fullImport);
            } else {
                this.file = "";
            }
        }
        return this.file;
    }

    public String getFolder() {
        if (this.folder == null) {
            if (this.fullImport != null) {
                this.tokenize(this.fullImport);
            } else {
                this.folder = "";
            }
        }
        return this.folder;
    }

    private void tokenize(String importStatement) {
        int delimiter = -1;
        int i = 0;
        while (i < tokens.length) {
            delimiter = importStatement.lastIndexOf(tokens[i]);
            if (delimiter != -1) break;
            ++i;
        }
        if (delimiter != -1) {
            this.folder = importStatement.substring(0, delimiter);
            this.file = importStatement.substring(delimiter + 1, this.fullImport.length());
        } else {
            this.folder = this.getDefaultFolderName();
            this.file = new String(this.fullImport);
        }
    }

    public abstract String getDefaultFolderName();
}

