/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java.variables;

import java.util.HashMap;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.IEGLJavaVariable;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.core.java.variables.ChildlessVariable;
import org.eclipse.edt.debug.core.java.variables.IVariableAdapter;
import org.eclipse.edt.debug.core.java.variables.ToStringVariable;
import org.eclipse.edt.debug.core.java.variables.VariableUtil;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.edt.debug.internal.core.java.variables.CalendarVariable;
import org.eclipse.edt.debug.internal.core.java.variables.ListVariable;
import org.eclipse.edt.debug.internal.core.java.variables.MapVariable;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class DefaultVariableAdapter
implements IVariableAdapter {
    private HashMap<String, Object> simpleTypes;

    @Override
    public IEGLJavaVariable adapt(IJavaVariable variable, IEGLJavaStackFrame frame, SMAPVariableInfo info, IEGLJavaValue parent) {
        String type;
        IValue value;
        block17: {
            value = variable.getValue();
            if (value instanceof IJavaPrimitiveValue) {
                return new EGLJavaVariable(frame.getDebugTarget(), variable, info, frame, parent){

                    @Override
                    protected boolean shouldCheckJavaElementAdapter() {
                        return false;
                    }
                };
            }
            if (value instanceof IJavaValue && !((IJavaValue)value).isNull()) {
                type = value.getReferenceTypeName();
                break block17;
            }
            try {
                type = variable.getReferenceTypeName();
            }
            catch (DebugException debugException) {
                return null;
            }
        }
        try {
            if (this.getSimpleTypeMap().containsKey(type)) {
                if ("java.lang.String".equals(type)) {
                    return new ChildlessVariable(frame.getDebugTarget(), variable, info, frame, parent);
                }
                if ("java.math.BigDecimal".equals(type) || "java.math.BigInteger".equals(type)) {
                    return new ToStringVariable(frame.getDebugTarget(), variable, info, frame, parent);
                }
                if (value instanceof IJavaObject) {
                    if (((IJavaObject)value).isNull()) {
                        return new EGLJavaVariable(frame.getDebugTarget(), variable, info, frame, parent){

                            @Override
                            protected boolean shouldCheckJavaElementAdapter() {
                                return false;
                            }
                        };
                    }
                    IJavaFieldVariable var = ((IJavaObject)value).getField("value", false);
                    if (var != null) {
                        return new EGLJavaVariable(frame.getDebugTarget(), (IJavaVariable)var, info, frame, parent){

                            @Override
                            protected boolean shouldCheckJavaElementAdapter() {
                                return false;
                            }
                        };
                    }
                }
            } else {
                if (VariableUtil.isInstanceOf(variable, "java.util.List")) {
                    return new ListVariable(frame.getDebugTarget(), variable, info, frame, parent);
                }
                if (VariableUtil.isInstanceOf(variable, "java.util.Map")) {
                    return new MapVariable(frame.getDebugTarget(), variable, info, frame, parent);
                }
                if (VariableUtil.isInstanceOf(variable, "java.util.Calendar")) {
                    return new CalendarVariable(frame.getDebugTarget(), variable, info, frame, parent);
                }
            }
        }
        catch (DebugException e) {
            EDTDebugCorePlugin.log(e);
        }
        return null;
    }

    private synchronized HashMap<String, Object> getSimpleTypeMap() {
        if (this.simpleTypes == null) {
            this.simpleTypes = new HashMap(11);
            this.simpleTypes.put("java.lang.Integer", null);
            this.simpleTypes.put("java.lang.Long", null);
            this.simpleTypes.put("java.lang.Short", null);
            this.simpleTypes.put("java.lang.Boolean", null);
            this.simpleTypes.put("java.lang.String", null);
            this.simpleTypes.put("java.lang.Float", null);
            this.simpleTypes.put("java.lang.Double", null);
            this.simpleTypes.put("java.lang.Byte", null);
            this.simpleTypes.put("java.lang.Character", null);
            this.simpleTypes.put("java.math.BigDecimal", null);
            this.simpleTypes.put("java.math.BigInteger", null);
        }
        return this.simpleTypes;
    }

    @Override
    public void dispose() {
        this.simpleTypes = null;
    }
}

