/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java.filters;

import org.eclipse.debug.core.DebugException;
import org.eclipse.edt.debug.core.java.filters.FilterStepType;
import org.eclipse.edt.debug.core.java.variables.VariableUtil;
import org.eclipse.edt.debug.internal.core.java.filters.DefaultTypeFilterCategory;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;

public class JREFilterCategory
extends DefaultTypeFilterCategory {
    @Override
    public FilterStepType getStepType(IJavaStackFrame frame) {
        if (frame != null) {
            try {
                IJavaReferenceType type = frame.getReferenceType();
                String typeName = frame.getReferenceType().getName();
                if (typeName.equals("java.lang.reflect.Method")) {
                    return FilterStepType.STEP_INTO;
                }
                if (typeName.equals("java.lang.Class") || typeName.equals("java.lang.reflect.Constructor") ? frame.getMethodName().startsWith("newInstance") : type instanceof IJavaClassType && typeName.startsWith("sun.reflect.") && (VariableUtil.isInstanceOf((IJavaClassType)type, "sun.reflect.MethodAccessor", false) || VariableUtil.isInstanceOf((IJavaClassType)type, "sun.reflect.ConstructorAccessor", false))) {
                    return FilterStepType.STEP_INTO;
                }
            }
            catch (DebugException debugException) {}
        }
        return super.getStepType(frame);
    }
}

