/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SMAPLineInfo {
    private final Map<Integer, List<Integer>> eglToJavaLines = new HashMap<Integer, List<Integer>>();
    private final Map<Integer, Integer> javaToEGLLines = new HashMap<Integer, Integer>();

    public List<Integer> getJavaLines(int eglLine) {
        return this.eglToJavaLines.get(eglLine);
    }

    public int getFirstJavaLine(int eglLine) {
        List<Integer> javaLines = this.eglToJavaLines.get(eglLine);
        if (javaLines == null || javaLines.size() == 0) {
            return -1;
        }
        return javaLines.get(0);
    }

    public int getEGLLine(int javaLine) {
        if (this.javaToEGLLines.containsKey(javaLine)) {
            return this.javaToEGLLines.get(javaLine);
        }
        return -1;
    }

    public void addMappings(int repeatCount, int eglStartLine, int javaStartLine, int javaLineIncrement) {
        int i = 0;
        while (i < repeatCount) {
            boolean fastAdd = false;
            List<Integer> javaLines = this.eglToJavaLines.get(eglStartLine + i);
            if (javaLines == null) {
                javaLines = new ArrayList<Integer>();
                this.eglToJavaLines.put(eglStartLine + i, javaLines);
                fastAdd = true;
            }
            int nextJavaLineStart = javaStartLine + i * javaLineIncrement;
            int j = 0;
            while (j < javaLineIncrement || j == 0 && javaLineIncrement == 0) {
                if (fastAdd || !javaLines.contains(nextJavaLineStart + j)) {
                    javaLines.add(nextJavaLineStart + j);
                }
                if (!this.javaToEGLLines.containsKey(nextJavaLineStart + j)) {
                    this.javaToEGLLines.put(nextJavaLineStart + j, eglStartLine + i);
                }
                ++j;
            }
            ++i;
        }
    }
}

