/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.schema.impl;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.impl.SQLObjectImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class DatabaseImpl
extends SQLObjectImpl
implements Database {
    protected static final String VENDOR_EDEFAULT = null;
    protected String vendor = VENDOR_EDEFAULT;
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected EList schemas;
    protected EList events;
    protected EList catalogs;
    protected EList authorizationIds;

    protected DatabaseImpl() {
    }

    protected EClass eStaticClass() {
        return SQLSchemaPackage.Literals.DATABASE;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String newVendor) {
        String oldVendor = this.vendor;
        this.vendor = newVendor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldVendor, (Object)this.vendor));
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldVersion, (Object)this.version));
        }
    }

    public EList getSchemas() {
        if (this.schemas == null) {
            this.schemas = new EObjectWithInverseResolvingEList(Schema.class, (InternalEObject)this, 10, 12);
        }
        return this.schemas;
    }

    public EList getEvents() {
        if (this.events == null) {
            this.events = new EObjectWithInverseResolvingEList(Event.class, (InternalEObject)this, 11, 12);
        }
        return this.events;
    }

    public EList getCatalogs() {
        if (this.catalogs == null) {
            this.catalogs = new EObjectWithInverseResolvingEList(Catalog.class, (InternalEObject)this, 12, 8);
        }
        return this.catalogs;
    }

    public EList getAuthorizationIds() {
        if (this.authorizationIds == null) {
            this.authorizationIds = new EObjectWithInverseResolvingEList(AuthorizationIdentifier.class, (InternalEObject)this, 13, 9);
        }
        return this.authorizationIds;
    }

    public List getUserDefinedTypes() {
        Vector<UserDefinedType> udtList = new Vector<UserDefinedType>();
        EList schemas = this.getSchemas();
        if (schemas != null) {
            for (Schema currentSchema : schemas) {
                EList udts = currentSchema.getUserDefinedTypes();
                if (udts == null) continue;
                for (UserDefinedType currentUDT : udts) {
                    udtList.add(currentUDT);
                }
            }
        }
        return udtList;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 10: {
                return ((InternalEList)this.getSchemas()).basicAdd((Object)otherEnd, msgs);
            }
            case 11: {
                return ((InternalEList)this.getEvents()).basicAdd((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getCatalogs()).basicAdd((Object)otherEnd, msgs);
            }
            case 13: {
                return ((InternalEList)this.getAuthorizationIds()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 10: {
                return ((InternalEList)this.getSchemas()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return ((InternalEList)this.getEvents()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getCatalogs()).basicRemove((Object)otherEnd, msgs);
            }
            case 13: {
                return ((InternalEList)this.getAuthorizationIds()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getVendor();
            }
            case 9: {
                return this.getVersion();
            }
            case 10: {
                return this.getSchemas();
            }
            case 11: {
                return this.getEvents();
            }
            case 12: {
                return this.getCatalogs();
            }
            case 13: {
                return this.getAuthorizationIds();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setVendor((String)newValue);
                return;
            }
            case 9: {
                this.setVersion((String)newValue);
                return;
            }
            case 10: {
                this.getSchemas().clear();
                this.getSchemas().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getEvents().clear();
                this.getEvents().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getCatalogs().clear();
                this.getCatalogs().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getAuthorizationIds().clear();
                this.getAuthorizationIds().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setVendor(VENDOR_EDEFAULT);
                return;
            }
            case 9: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 10: {
                this.getSchemas().clear();
                return;
            }
            case 11: {
                this.getEvents().clear();
                return;
            }
            case 12: {
                this.getCatalogs().clear();
                return;
            }
            case 13: {
                this.getAuthorizationIds().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return VENDOR_EDEFAULT == null ? this.vendor != null : !VENDOR_EDEFAULT.equals(this.vendor);
            }
            case 9: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 10: {
                return this.schemas != null && !this.schemas.isEmpty();
            }
            case 11: {
                return this.events != null && !this.events.isEmpty();
            }
            case 12: {
                return this.catalogs != null && !this.catalogs.isEmpty();
            }
            case 13: {
                return this.authorizationIds != null && !this.authorizationIds.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (vendor: ");
        result.append(this.vendor);
        result.append(", version: ");
        result.append(this.version);
        result.append(')');
        return result.toString();
    }
}

