/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.compiler.gen;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.ide.compiler.gen.GenerationReport;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.egl.Part;

public class EclipseGeneratorUtility {
    private EclipseGeneratorUtility() {
    }

    public static IFile writeAndProcessJavaFile(String outputFolder, Part part, Generator generator, IGenerator generatorProvider, IFile eglFile) throws Exception {
        boolean forceClasspathRefresh = false;
        IContainer outputContainer = EclipseUtilities.getOutputContainer((String)outputFolder, (IFile)eglFile, (String)"");
        if (!outputContainer.exists()) {
            forceClasspathRefresh = true;
        }
        IFile outputFile = EclipseUtilities.writeFileInEclipse((String)outputFolder, (IFile)eglFile, (String)generator.getResult().toString(), (String)generator.getRelativeFileName(part));
        GenerationReport.writeFile(part, eglFile, generator);
        IProject targetProject = outputFile.getProject();
        EclipseUtilities.addToJavaBuildPathIfNecessary((IProject)targetProject, (String)outputFolder, (boolean)forceClasspathRefresh);
        EclipseUtilities.addRuntimesToProject((IProject)targetProject, (IGenerator)generatorProvider, (EglContext)generator.getContext());
        EclipseUtilities.addSMAPBuilder((IProject)targetProject);
        ProjectSettingsUtility.addSourceProject((IProject)targetProject, (IProject)eglFile.getProject());
        generator.processFile(outputFile.getFullPath().toString());
        return outputFile;
    }

    public static IFile writeSMAPFile(byte[] data, String outputFolder, Part part, Generator generator, IFile eglFile) throws CoreException, IOException {
        IFile outJavaFile = EclipseUtilities.getOutputFile((String)outputFolder, (IFile)eglFile, (String)generator.getRelativeFileName(part));
        IFile outSmapFile = ResourcesPlugin.getWorkspace().getRoot().getFile(outJavaFile.getFullPath().removeFileExtension().addFileExtension(".eglsmap".substring(1)));
        ByteArrayInputStream dataStream = new ByteArrayInputStream(data);
        try {
            if (outSmapFile.exists()) {
                outSmapFile.setContents((InputStream)dataStream, true, false, null);
            } else {
                if (outSmapFile.getParent() instanceof IFolder) {
                    EclipseUtilities.createFolder((IFolder)((IFolder)outSmapFile.getParent()));
                }
                outSmapFile.create((InputStream)dataStream, 1, null);
            }
        }
        catch (CoreException ce) {
            try {
                dataStream.close();
            }
            catch (IOException iOException) {}
            throw ce;
        }
        dataStream.close();
        return outSmapFile;
    }
}

