/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import java.util.ArrayList;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.Mnemonics;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StringArrayDialog
extends Dialog
implements ModifyListener,
SelectionListener {
    protected Button _buttonAdd = null;
    protected Button _buttonMoveDown = null;
    protected Button _buttonMoveUp = null;
    protected Button _buttonRemove = null;
    protected List _listbox = null;
    protected ArrayList _listValues = null;
    protected String _strPropertyName = null;
    protected Text _text = null;

    public StringArrayDialog(Shell shell, ArrayList listValues, String strPropertyName) {
        super(shell);
        this._listValues = listValues != null ? (ArrayList)listValues.clone() : new ArrayList();
        this._strPropertyName = strPropertyName;
    }

    protected Control createDialogArea(Composite compositeParent) {
        if (this._strPropertyName != null) {
            this.getShell().setText(this._strPropertyName);
        }
        Composite composite = new Composite(compositeParent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label labelInstruction = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        labelInstruction.setLayoutData((Object)gridData);
        labelInstruction.setText(Messages.NL_Add_or_remove_strings_from_the_list);
        this._text = new Text(composite, 2048);
        gridData = new GridData(768);
        this._text.setLayoutData((Object)gridData);
        this._text.addModifyListener((ModifyListener)this);
        this._buttonAdd = new Button(composite, 8);
        gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        this._buttonAdd.setLayoutData((Object)gridData);
        this._buttonAdd.setText(Messages.NL_Add);
        this._buttonAdd.addSelectionListener((SelectionListener)this);
        this._listbox = new List(composite, 2816);
        gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.widthHint = 200;
        gridData.verticalSpan = 3;
        this._listbox.setLayoutData((Object)gridData);
        this._listbox.addSelectionListener((SelectionListener)this);
        this._buttonRemove = new Button(composite, 8);
        gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        this._buttonRemove.setLayoutData((Object)gridData);
        this._buttonRemove.setText(Messages.NL_Remove);
        this._buttonRemove.addSelectionListener((SelectionListener)this);
        this._buttonMoveUp = new Button(composite, 8);
        gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        this._buttonMoveUp.setLayoutData((Object)gridData);
        this._buttonMoveUp.setText(Messages.NL_Move_up);
        this._buttonMoveUp.setEnabled(false);
        this._buttonMoveUp.addSelectionListener((SelectionListener)this);
        this._buttonMoveDown = new Button(composite, 8);
        gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        this._buttonMoveDown.setLayoutData((Object)gridData);
        this._buttonMoveDown.setText(Messages.NL_Move_down);
        this._buttonMoveDown.setEnabled(false);
        this._buttonMoveDown.addSelectionListener((SelectionListener)this);
        new Mnemonics().setMnemonics(composite);
        this.initialize();
        this.updateControls();
        return composite;
    }

    public ArrayList getValues() {
        return this._listValues;
    }

    protected void initialize() {
        if (this._listValues.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this._listValues.size()) {
            this._listbox.add(this._listValues.get(i).toString());
            ++i;
        }
    }

    public void modifyText(ModifyEvent event) {
    }

    protected void okPressed() {
        this._listValues.clear();
        int i = 0;
        while (i < this._listbox.getItemCount()) {
            this._listValues.add(this._listbox.getItem(i));
            ++i;
        }
        super.okPressed();
    }

    protected void updateControls() {
        this._buttonRemove.setEnabled(this._listbox.getItemCount() > 0);
        this._buttonMoveUp.setEnabled(this._listbox.getSelectionIndex() > 0);
        this._buttonMoveDown.setEnabled(this._listbox.getSelectionIndex() < this._listbox.getItemCount() - 1);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._buttonRemove) {
            int iSelection = this._listbox.getSelectionIndex();
            this._listbox.remove(iSelection);
            if (iSelection < this._listbox.getItemCount()) {
                this._listbox.setSelection(iSelection);
            } else {
                this._listbox.setSelection(this._listbox.getItemCount() - 1);
            }
        } else if (event.widget == this._buttonAdd) {
            this._listbox.add(this._text.getText());
            this._listbox.setSelection(this._listbox.getItemCount() - 1);
            this._text.setText("");
            this._text.setFocus();
        } else if (event.widget == this._buttonMoveUp) {
            int iSelection = this._listbox.getSelectionIndex();
            String strSelection = this._listbox.getItem(iSelection);
            this._listbox.add(strSelection, iSelection - 1);
            this._listbox.remove(iSelection + 1);
            this._listbox.setSelection(iSelection - 1);
        } else if (event.widget == this._buttonMoveDown) {
            int iSelection = this._listbox.getSelectionIndex();
            String strSelection = this._listbox.getItem(iSelection);
            this._listbox.remove(iSelection);
            this._listbox.add(strSelection, iSelection + 1);
            this._listbox.setSelection(iSelection + 1);
        }
        this.updateControls();
    }
}

