/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import java.util.List;
import org.eclipse.edt.ide.rui.server.EvEditorProvider;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EvFunctionNameDialog
extends Dialog
implements ModifyListener,
SelectionListener {
    protected boolean _bLinkToEvent = true;
    protected boolean _bTranslationTestMode = false;
    protected Button _checkLinkToSelectedEvent = null;
    protected EvEditorProvider _editorProvider = null;
    protected int _iTranslationTestModeCount = 0;
    protected Label _labelErrorMessage = null;
    protected List _listFunctionNames = null;
    protected List _listWidgetNames = null;
    protected String _strName = null;
    protected String _strEventName = null;
    protected Text _textName = null;

    public EvFunctionNameDialog(Shell shell, EvEditorProvider editorProvider, String strEventName) {
        super(shell);
        this._editorProvider = editorProvider;
        this._strEventName = strEventName;
    }

    protected int computeMaximumErrorMessageLength(Display display) {
        GC gc = new GC((Drawable)display);
        Point ptString = gc.stringExtent(Messages.NL_A_function_with_the_same_name_already_exists);
        int iMax = ptString.x;
        ptString = gc.stringExtent(Messages.NL_The_name_already_exists);
        iMax = Math.max(iMax, ptString.x);
        ptString = gc.stringExtent(Messages.NL_The_name_is_not_allowed);
        iMax = Math.max(iMax, ptString.x);
        return iMax;
    }

    protected Control createContents(Composite compositeParent) {
        if (this._editorProvider != null) {
            this._listFunctionNames = this._editorProvider.getExistingFunctionNames();
            this._listWidgetNames = this._editorProvider.getWidgetNames();
            if (this._strEventName != null) {
                this._strName = this._editorProvider.getEventDefaultFunctionName(this._strEventName);
            }
        }
        Control control = super.createContents(compositeParent);
        if (!this._bTranslationTestMode) {
            this.validate();
        }
        return control;
    }

    protected Control createDialogArea(Composite compositeParent) {
        int iMaximumErrorMessageLength;
        this.getShell().setText(Messages.NL_New_Event_Handler);
        Composite compositeDialog = new Composite(compositeParent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        compositeDialog.setLayout((Layout)gridLayout);
        Label labelFunctionName = new Label(compositeDialog, 0);
        GridData gridData = new GridData();
        labelFunctionName.setLayoutData((Object)gridData);
        labelFunctionName.setText(Messages.NL_Function_nameXcolonX);
        this._textName = new Text(compositeDialog, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this._textName.setLayoutData((Object)gridData);
        if (this._strName != null) {
            this._textName.setText(this._strName);
            this._textName.selectAll();
        }
        this._textName.setTextLimit(128);
        this._textName.addModifyListener((ModifyListener)this);
        this._labelErrorMessage = new Label(compositeDialog, 0);
        gridData = new GridData(768);
        gridData.widthHint = iMaximumErrorMessageLength = this.computeMaximumErrorMessageLength(compositeParent.getDisplay());
        gridData.horizontalSpan = 2;
        this._labelErrorMessage.setLayoutData((Object)gridData);
        return compositeDialog;
    }

    public boolean getLinkToEvent() {
        return this._bLinkToEvent;
    }

    public String getName() {
        return this._strName;
    }

    public void modifyText(ModifyEvent e) {
        this.validate();
    }

    protected void okPressed() {
        if (!this._bTranslationTestMode || this._iTranslationTestModeCount > 2) {
            super.okPressed();
            return;
        }
        if (this._iTranslationTestModeCount == 0) {
            this._labelErrorMessage.setText(Messages.NL_A_function_with_the_same_name_already_exists);
        } else if (this._iTranslationTestModeCount == 1) {
            this._labelErrorMessage.setText(Messages.NL_The_name_already_exists);
        } else if (this._iTranslationTestModeCount == 2) {
            this._labelErrorMessage.setText(Messages.NL_The_name_is_not_allowed);
        }
        ++this._iTranslationTestModeCount;
    }

    public void setTranslationTestMode(boolean bTranslationTestMode) {
        this._bTranslationTestMode = bTranslationTestMode;
    }

    protected void validate() {
        this._strName = this._textName.getText();
        String strErrorMessage = "";
        if (this._strName.length() > 0) {
            int i = 0;
            while (i < this._listFunctionNames.size()) {
                if (((String)this._listFunctionNames.get(i)).equalsIgnoreCase(this._strName)) {
                    strErrorMessage = Messages.NL_A_function_with_the_same_name_already_exists;
                    break;
                }
                ++i;
            }
            if (strErrorMessage.length() == 0) {
                i = 0;
                while (i < this._listWidgetNames.size()) {
                    if (((String)this._listWidgetNames.get(i)).equalsIgnoreCase(this._strName)) {
                        strErrorMessage = Messages.NL_The_name_already_exists;
                        break;
                    }
                    ++i;
                }
            }
            if (strErrorMessage.length() == 0 && this._strName.length() > 0 && !this._editorProvider.isValidName(this._strName)) {
                strErrorMessage = Messages.NL_The_name_is_not_allowed;
            }
        }
        Button buttonOK = this.getButton(0);
        buttonOK.setEnabled(strErrorMessage.length() == 0 && this._strName.length() != 0);
        this._labelErrorMessage.setText(strErrorMessage);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent e) {
        this._bLinkToEvent = this._checkLinkToSelectedEvent.getSelection();
    }
}

