/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.properties;

import java.util.ArrayList;
import org.eclipse.edt.ide.rui.document.utils.IVEConstants;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyEditorAbstract;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertySheetPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.ColorUtil;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyValue;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PropertyEditorPosition
extends PropertyEditorAbstract
implements DisposeListener,
FocusListener,
SelectionListener,
PaintListener {
    protected Color _colorCells = ColorUtil.getColorFromRGBString(Display.getCurrent(), "128, 128, 255");
    protected Color _colorLines = Display.getCurrent().getSystemColor(2);
    protected PropertySheetPage _page = null;
    protected WidgetPropertyValue _propertyValueOriginalHeight = null;
    protected WidgetPropertyValue _propertyValueOriginalWidth = null;
    protected WidgetPropertyValue _propertyValueOriginalX = null;
    protected WidgetPropertyValue _propertyValueOriginalY = null;
    protected String _strName = null;
    protected Text _textHeight = null;
    protected Text _textWidth = null;
    protected Text _textX = null;
    protected Text _textY = null;

    public PropertyEditorPosition(PropertyPage page, WidgetPropertyDescriptor descriptor) {
        super(page, descriptor);
    }

    @Override
    public void createControl(Composite compositeParent) {
        Composite composite = new Composite(compositeParent, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new ControlLayout());
        this._textX = new Text(composite, 2048);
        this._textY = new Text(composite, 2048);
        this._textWidth = new Text(composite, 2048);
        this._textHeight = new Text(composite, 2048);
        this._textX.setToolTipText("x");
        this._textY.setToolTipText("y");
        this._textWidth.setToolTipText("width");
        this._textHeight.setToolTipText("height");
        this._textX.addFocusListener((FocusListener)this);
        this._textY.addFocusListener((FocusListener)this);
        this._textWidth.addFocusListener((FocusListener)this);
        this._textHeight.addFocusListener((FocusListener)this);
        this._textX.addSelectionListener((SelectionListener)this);
        this._textY.addSelectionListener((SelectionListener)this);
        this._textWidth.addSelectionListener((SelectionListener)this);
        this._textHeight.addSelectionListener((SelectionListener)this);
        composite.addDisposeListener((DisposeListener)this);
        composite.addPaintListener((PaintListener)this);
    }

    protected void doValueChange(Text text) {
        if (!text.getEnabled()) {
            return;
        }
        WidgetPropertyDescriptor descriptor = new WidgetPropertyDescriptor();
        if (text == this._textX) {
            descriptor._strType = "integer";
            descriptor._strLabel = "x";
            descriptor._strID = "x";
            WidgetPropertyValue propertyValueNew = new WidgetPropertyValue(this._textX.getText());
            this.propertyValueChanged(descriptor, this._propertyValueOriginalX, propertyValueNew);
        } else if (text == this._textY) {
            descriptor._strType = "integer";
            descriptor._strLabel = "y";
            descriptor._strID = "y";
            WidgetPropertyValue propertyValueNew = new WidgetPropertyValue(this._textY.getText());
            this.propertyValueChanged(descriptor, this._propertyValueOriginalY, propertyValueNew);
        } else if (text == this._textWidth) {
            descriptor._strType = "string";
            descriptor._strLabel = "width";
            descriptor._strID = "width";
            WidgetPropertyValue propertyValueNew = new WidgetPropertyValue(this._textWidth.getText());
            this.propertyValueChanged(descriptor, this._propertyValueOriginalWidth, propertyValueNew);
        } else if (text == this._textHeight) {
            descriptor._strType = "string";
            descriptor._strLabel = "height";
            descriptor._strID = "height";
            WidgetPropertyValue propertyValueNew = new WidgetPropertyValue(this._textHeight.getText());
            this.propertyValueChanged(descriptor, this._propertyValueOriginalHeight, propertyValueNew);
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.doValueChange((Text)e.widget);
    }

    @Override
    public void initialize() {
        this._propertyValueOriginalX = this.getPropertyValue("x", IVEConstants.INTEGER_TYPE);
        this._propertyValueOriginalY = this.getPropertyValue("y", IVEConstants.INTEGER_TYPE);
        this._propertyValueOriginalWidth = this.getPropertyValue("width", IVEConstants.STRING_TYPE);
        this._propertyValueOriginalHeight = this.getPropertyValue("height", IVEConstants.STRING_TYPE);
        ArrayList listX = null;
        ArrayList listY = null;
        ArrayList listWidth = null;
        ArrayList listHeight = null;
        if (this._propertyValueOriginalX != null) {
            listX = this._propertyValueOriginalX.getValues();
        }
        if (this._propertyValueOriginalY != null) {
            listY = this._propertyValueOriginalY.getValues();
        }
        if (this._propertyValueOriginalWidth != null) {
            listWidth = this._propertyValueOriginalWidth.getValues();
        }
        if (this._propertyValueOriginalHeight != null) {
            listHeight = this._propertyValueOriginalHeight.getValues();
        }
        if (listX == null || listX.size() == 0) {
            this._textX.setText("");
        } else {
            this._textX.setText((String)listX.get(0));
            this._textX.setEnabled(this._propertyValueOriginalX.isEditable());
        }
        if (listY == null || listY.size() == 0) {
            this._textY.setText("");
        } else {
            this._textY.setText((String)listY.get(0));
            this._textY.setEnabled(this._propertyValueOriginalY.isEditable());
        }
        if (listWidth == null || listWidth.size() == 0) {
            this._textWidth.setText("");
        } else {
            this._textWidth.setText((String)listWidth.get(0));
            this._textWidth.setEnabled(this._propertyValueOriginalWidth.isEditable());
        }
        if (listHeight == null || listHeight.size() == 0) {
            this._textHeight.setText("");
        } else {
            this._textHeight.setText((String)listHeight.get(0));
            this._textHeight.setEnabled(this._propertyValueOriginalHeight.isEditable());
        }
    }

    protected void paintArrowDown(GC gc, int iX, int iY) {
        gc.drawLine(iX - 2, iY - 4, iX, iY);
        gc.drawLine(iX - 1, iY - 4, iX, iY);
        gc.drawLine(iX + 1, iY - 4, iX, iY);
        gc.drawLine(iX + 2, iY - 4, iX, iY);
    }

    protected void paintArrowLeft(GC gc, int iX, int iY) {
        gc.drawLine(iX, iY, iX + 4, iY - 2);
        gc.drawLine(iX, iY, iX + 4, iY - 1);
        gc.drawLine(iX, iY, iX + 4, iY + 1);
        gc.drawLine(iX, iY, iX + 4, iY + 2);
    }

    protected void paintArrowRight(GC gc, int iX, int iY) {
        gc.drawLine(iX - 4, iY - 2, iX, iY);
        gc.drawLine(iX - 4, iY - 1, iX, iY);
        gc.drawLine(iX - 4, iY + 1, iX, iY);
        gc.drawLine(iX - 4, iY + 2, iX, iY);
    }

    protected void paintArrowUp(GC gc, int iX, int iY) {
        gc.drawLine(iX, iY, iX - 2, iY + 4);
        gc.drawLine(iX, iY, iX - 1, iY + 4);
        gc.drawLine(iX, iY, iX + 1, iY + 4);
        gc.drawLine(iX, iY, iX + 2, iY + 4);
    }

    public void paintControl(PaintEvent e) {
        e.gc.setBackground(this._colorCells);
        e.gc.setForeground(this._colorLines);
        Point ptSize = this._textX.getSize();
        int iX = ptSize.x + 20;
        int iY = ptSize.y + 20;
        int iW = ptSize.x + 32;
        int iH = ptSize.x + 32;
        e.gc.fillRectangle(iX, iY, iW, iH);
        e.gc.drawLine(iX, iY, iX + iW + 4 + ptSize.x, iY);
        e.gc.drawLine(iX, iY, iX, iY + iH + 4 + ptSize.y);
        e.gc.drawLine(iX, iY + iH, iX + iW + 4 + ptSize.x, iY + iH);
        e.gc.drawLine(iX + iW, iY, iX + iW, iY + iH + 4 + ptSize.y);
        iX = 4;
        iY = 24 + ptSize.y * 2;
        iW = ptSize.x + 16;
        iH = 0;
        e.gc.drawLine(iX, iY, iX + iW, iY + iH);
        this.paintArrowRight(e.gc, iX + iW, iY);
        iX = ptSize.x + ptSize.y + 24;
        iY = 4;
        iW = 0;
        iH = ptSize.y + 16;
        e.gc.drawLine(iX, iY, iX + iW, iY + iH);
        this.paintArrowDown(e.gc, iX, iY + iH);
        iX = ptSize.x + 20;
        iY = ptSize.y + 20 + ptSize.x + 32 + 4 + ptSize.y / 2;
        iW = ptSize.x + 32;
        iH = 0;
        e.gc.drawLine(iX, iY, iX + iW, iY + iH);
        this.paintArrowLeft(e.gc, iX, iY);
        this.paintArrowRight(e.gc, iX + iW, iY);
        iX = ptSize.x + 20 + ptSize.x + 32 + 4 + ptSize.x / 2;
        iY = ptSize.y + 20;
        iW = 0;
        iH = ptSize.x + 32;
        e.gc.drawLine(iX, iY, iX + iW, iY + iH);
        this.paintArrowUp(e.gc, iX, iY);
        this.paintArrowDown(e.gc, iX, iY + iH);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.doValueChange((Text)e.widget);
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this._colorCells != null && !this._colorCells.isDisposed()) {
            this._colorCells.dispose();
            this._colorCells = null;
        }
    }

    public void widgetSelected(SelectionEvent e) {
    }

    protected class ControlLayout
    extends Layout {
        protected ControlLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            String strText = PropertyEditorPosition.this._textX.getText();
            PropertyEditorPosition.this._textX.setText("MMMM");
            Point ptSize = PropertyEditorPosition.this._textX.computeSize(-1, -1);
            PropertyEditorPosition.this._textX.setText(strText);
            int iW = 4 + ptSize.x + 16 + (ptSize.x + 32) + 4 + ptSize.x + 4;
            int iH = 4 + ptSize.y + 16 + (ptSize.x + 32) + 4 + ptSize.y + 4;
            return new Point(iW, iH);
        }

        protected void layout(Composite composite, boolean flushCache) {
            String strText = PropertyEditorPosition.this._textX.getText();
            PropertyEditorPosition.this._textX.setText("MMMM");
            Point ptSize = PropertyEditorPosition.this._textX.computeSize(-1, -1);
            PropertyEditorPosition.this._textX.setText(strText);
            PropertyEditorPosition.this._textX.setBounds(4, 20 + ptSize.y, ptSize.x, ptSize.y);
            PropertyEditorPosition.this._textY.setBounds(ptSize.x + ptSize.y + 28, 4, ptSize.x, ptSize.y);
            PropertyEditorPosition.this._textWidth.setBounds(ptSize.x + 36, ptSize.y + 20 + ptSize.x + 32 + 4, ptSize.x, ptSize.y);
            PropertyEditorPosition.this._textHeight.setBounds(ptSize.x * 2 + 56, ptSize.y + 20 + (ptSize.x + 32 - ptSize.y) / 2, ptSize.x, ptSize.y);
        }
    }
}

