/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.properties;

import java.util.ArrayList;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.IEvPropertySheetPageAdapter;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyEditorAbstract;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.BidiUtils;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyChoice;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyValue;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class PropertyEditorChoice
extends PropertyEditorAbstract
implements SelectionListener {
    protected static final String NONE = "(" + Messages.NL_none + ")";
    protected boolean _bValueIsAChoice = false;
    protected Combo _combo = null;
    protected WidgetPropertyValue _propertyValueOriginal = null;

    public PropertyEditorChoice(PropertyPage page, WidgetPropertyDescriptor descriptor) {
        super(page, descriptor);
    }

    @Override
    public void createControl(Composite compositeParent) {
        this._combo = new Combo(compositeParent, 8);
        this._combo.setData((Object)this._descriptor);
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        this._combo.setLayoutData((Object)gridData);
    }

    @Override
    public void initialize() {
        WidgetPropertyChoice choice;
        ArrayList listValues;
        this._combo.removeSelectionListener((SelectionListener)this);
        ArrayList listChoices = this.getPropertyDescriptor().getChoices();
        String strValue = null;
        this._propertyValueOriginal = this.getPropertyValue(this.getPropertyDescriptor().getID(), this.getPropertyDescriptor().getType());
        if (this._propertyValueOriginal != null && (listValues = this._propertyValueOriginal.getValues()) != null && listValues.size() > 0) {
            strValue = (String)listValues.get(0);
        }
        this._bValueIsAChoice = false;
        if (strValue != null && this._propertyValueOriginal != null) {
            int i = 0;
            while (i < listChoices.size()) {
                choice = (WidgetPropertyChoice)listChoices.get(i);
                if (choice._strID.equals(strValue) || choice._strID.startsWith("${typeName:") && choice._strID.replaceAll("}", "").endsWith(strValue)) {
                    this._bValueIsAChoice = true;
                    strValue = choice._strID;
                    break;
                }
                ++i;
            }
        } else if (strValue == null) {
            this._bValueIsAChoice = true;
        }
        this._combo.removeAll();
        if (strValue != null && !this._bValueIsAChoice) {
            this._combo.add(strValue);
        }
        this._combo.add(NONE);
        int i = 0;
        while (i < listChoices.size()) {
            choice = (WidgetPropertyChoice)listChoices.get(i);
            this._combo.add(choice._strLabel);
            ++i;
        }
        if (!this._bValueIsAChoice && strValue != null) {
            this._combo.setText(strValue);
        } else if (strValue == null) {
            this._combo.setText(NONE);
        } else {
            i = 0;
            while (i < listChoices.size()) {
                choice = (WidgetPropertyChoice)listChoices.get(i);
                if (choice._strID.equals(strValue)) {
                    this._combo.setText(choice._strLabel);
                    break;
                }
                ++i;
            }
        }
        if (this._combo.getText().equals(NONE)) {
            if (BidiUtils.isBidi() && "widgetOrientation".equals(this._descriptor._strID)) {
                this._combo.setToolTipText(this.getBidiWidgetOrientation());
            } else if (BidiUtils.isBidi() && "alignment".equals(this._descriptor._strID) && "Box".equalsIgnoreCase(this._page._widgetPart.getTypeName())) {
                this._combo.setToolTipText(this.getBidiBoxAlignment());
            } else {
                String strDefault = this.getPropertyDescriptor().getDefault();
                if (strDefault == null) {
                    strDefault = "";
                }
                this._combo.setToolTipText(strDefault);
            }
        } else {
            this._combo.setToolTipText("");
        }
        boolean bEditable = true;
        if (BidiUtils.isBidi() && this.isBidiProperty()) {
            bEditable = this.setEditableForBidiProperty();
        } else if (this._propertyValueOriginal != null) {
            bEditable = this._propertyValueOriginal.isEditable();
        }
        this._combo.setEnabled(bEditable);
        if (bEditable) {
            this._combo.addSelectionListener((SelectionListener)this);
        }
    }

    private boolean setEditableForBidiProperty() {
        String widgetName = this._page._widgetPart.getTypeName().toLowerCase();
        if ("box".equals(widgetName) || "passwordtextfield".equals(widgetName) || "gridlayout".equals(widgetName) || "dojocolorpalette".equals(widgetName) || "dojocurrencytextbox".equals(widgetName) || "dojodatetextbox".equals(widgetName) || "dojoprogressbar".equals(widgetName)) {
            return "widgetOrientation".equals(this._descriptor._strID);
        }
        if (widgetName != null && widgetName.contains("button")) {
            return !"widgetOrientation".equals(this._descriptor._strID);
        }
        if ("biditextfield".equals(widgetName) || "biditextarea".equals(widgetName)) {
            if ("reverseTextDirection".equals(this._descriptor._strID)) {
                return this.isBidiTextLayoutVisual();
            }
            return true;
        }
        if ("textfield".equals(widgetName) || "textarea".equals(widgetName) || "image".equals(widgetName) || "dojocalendar".equals(widgetName) || "dojohorizontalslider".equals(widgetName) || "dojotextarea".equals(widgetName) || "dojotextfield".equals(widgetName) || "dojotimetextbox".equals(widgetName)) {
            return false;
        }
        return (widgetName == null || !widgetName.contains("checkbox")) && !widgetName.contains("combo") && !widgetName.contains("radiogroup") || !"reverseTextDirection".equals(this._descriptor._strID);
    }

    private boolean isBidiProperty() {
        return Messages.NL_Bidi.equals(this._descriptor._strCategory);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        if (this._combo.isDisposed()) {
            return;
        }
        int iSelection = this._combo.getSelectionIndex();
        if (iSelection == 0 && !this._bValueIsAChoice) {
            return;
        }
        if (!this._bValueIsAChoice) {
            --iSelection;
        }
        if (iSelection == 0) {
            WidgetPropertyValue propertyValueNew = new WidgetPropertyValue("");
            super.propertyValueChanged(this.getPropertyDescriptor(), this._propertyValueOriginal, propertyValueNew);
        } else {
            ArrayList listChoices = this._descriptor.getChoices();
            WidgetPropertyChoice choice = (WidgetPropertyChoice)listChoices.get(iSelection - 1);
            WidgetPropertyValue propertyValueNew = new WidgetPropertyValue(choice.getID());
            super.propertyValueChanged(this.getPropertyDescriptor(), this._propertyValueOriginal, propertyValueNew);
        }
    }

    String getBidiWidgetOrientation() {
        WidgetPart curWidget = this._page._widgetPart;
        WidgetPropertyValue widgetOrientation = this.getPropertyValue("widgetOrientation", "choice");
        String widgetOrientationStr = null;
        IEvPropertySheetPageAdapter editor = this._page._propertySheet.getEditorAdapter();
        while (!"ROOT".equals(curWidget.getTypeName()) && widgetOrientation == null) {
            widgetOrientation = editor.getPropertyValue(curWidget, "widgetOrientation", "choice");
            curWidget = curWidget.getParent();
        }
        if (widgetOrientation != null) {
            widgetOrientationStr = widgetOrientation.getValues().get(0).toString();
        }
        return widgetOrientationStr;
    }

    String getBidiBoxAlignment() {
        String alignmentText = "";
        String widgetOrientation = this.getBidiWidgetOrientation();
        String strDefault = this.getPropertyDescriptor().getDefault();
        if (widgetOrientation != null) {
            if (widgetOrientation.contains("RTL")) {
                alignmentText = String.valueOf(strDefault.substring(0, strDefault.lastIndexOf(95) + 1)) + "RIGHT";
            } else if (widgetOrientation.contains("LTR")) {
                alignmentText = String.valueOf(strDefault.substring(0, strDefault.lastIndexOf(95) + 1)) + "LEFT";
            }
        }
        return alignmentText;
    }

    boolean isBidiTextLayoutVisual() {
        int indx = this.getEditorIndx("textLayout");
        if (indx != -1) {
            PropertyEditorChoice editor = (PropertyEditorChoice)this._page._vectorPropertyEditors.get(indx);
            if (editor._propertyValueOriginal == null) {
                return false;
            }
            String value = editor._propertyValueOriginal.getValues().get(0).toString();
            if (value.contains(Messages.NL_BIDI_Visual)) {
                return true;
            }
        }
        return false;
    }

    int getEditorIndx(String id) {
        int i = 0;
        while (i < this._page._vectorPropertyEditors.size()) {
            PropertyEditorAbstract editor = (PropertyEditorAbstract)this._page._vectorPropertyEditors.get(i);
            if (editor._descriptor._strID.equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

