/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.preferences;

import java.text.DecimalFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvHelp;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.EvPreferences;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.IEvPreferencePage;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.BrowserManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.ColorSelectorButton;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class EvPreferencePageGeneral
extends Composite
implements SelectionListener,
IEvPreferencePage {
    protected ColorSelectorButton _buttonColorDropLocationPotential = null;
    protected ColorSelectorButton _buttonColorDropLocationSelected = null;
    protected ColorSelectorButton _buttonColorSelection = null;
    protected Button _checkPromptForNewWidgetName = null;
    protected Button _checkShowTransparencyControls = null;
    protected Button _checkSemiTransparencyWhileDragging = null;
    protected Button _checkPatternDropLocationSelected = null;
    protected Button _checkPatternSelection = null;
    protected DecimalFormat _decimalFormat = new DecimalFormat("####%");
    protected Label _labelTransparencyPercent = null;
    protected Button _radioEditorTabDesign = null;
    protected Button _radioEditorTabPreview = null;
    protected Button _radioEditorTabSource = null;
    protected Button _radioOptimizeResources = null;
    protected Button _radioOptimizeSpeed = null;
    protected Button _radioRenderEngineWebKit = null;
    protected Button _radioRenderEngineXULRunner = null;
    protected Button _radioRenderEngineIE = null;
    protected Button _radioRenderEngineUserConfigured = null;
    protected Button _radioTransparencyNone = null;
    protected Button _radioTransparencyFixed = null;
    protected Button _radioTransparencyVariable = null;
    protected Slider _sliderTransparencyAmount = null;

    public EvPreferencePageGeneral(Composite compositeParent, int iStyle) {
        super(compositeParent, iStyle);
        this.createControlsEditorOpeningTab();
        this.createControlsWidgetCreation();
        this.createControlsTransparency();
        this.createControlsColors();
        this.createControlsPerformance();
        this.createControlsRenderEngine();
        Dialog.applyDialogFont((Control)compositeParent);
        EvHelp.setHelp((Control)this, EvHelp.PREFERENCES_GENERAL);
    }

    protected void cleanup() {
    }

    protected void createControlsColors() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Group groupColors = new Group((Composite)this, 0);
        GridData gridData = new GridData(768);
        groupColors.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        groupColors.setLayout((Layout)gridLayout);
        groupColors.setText(Messages.NL_Colors);
        Label label = new Label((Composite)groupColors, 0);
        label.setText(Messages.NL_Selection_borderXcolonX);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this._buttonColorSelection = new ColorSelectorButton();
        Button button = this._buttonColorSelection.createWidget(groupColors);
        gridData = new GridData();
        button.setLayoutData((Object)gridData);
        this._buttonColorSelection.setColor(EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.ColorSelection"));
        this._checkPatternSelection = new Button((Composite)groupColors, 32);
        gridData = new GridData();
        gridData.horizontalIndent = 16;
        this._checkPatternSelection.setLayoutData((Object)gridData);
        this._checkPatternSelection.setText(Messages.NL_Superimpose_a_pattern);
        this._checkPatternSelection.addSelectionListener((SelectionListener)this);
        boolean bPattern = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.PatternSelection");
        this._checkPatternSelection.setSelection(bPattern);
        this._buttonColorSelection.setPattern(bPattern ? ColorSelectorButton.PATTERN_DENTAL : ColorSelectorButton.PATTERN_NONE);
        label = new Label((Composite)groupColors, 0);
        label.setText(Messages.NL_Potential_drop_locationXcolonX);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this._buttonColorDropLocationPotential = new ColorSelectorButton();
        button = this._buttonColorDropLocationPotential.createWidget(groupColors);
        gridData = new GridData();
        button.setLayoutData((Object)gridData);
        this._buttonColorDropLocationPotential.setColor(EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationPotential"));
        new Label((Composite)groupColors, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupColors, 0);
        label.setText(Messages.NL_Selected_drop_locationXcolonX);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this._buttonColorDropLocationSelected = new ColorSelectorButton();
        button = this._buttonColorDropLocationSelected.createWidget(groupColors);
        gridData = new GridData();
        button.setLayoutData((Object)gridData);
        this._buttonColorDropLocationSelected.setColor(EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationSelected"));
        this._checkPatternDropLocationSelected = new Button((Composite)groupColors, 32);
        gridData = new GridData();
        gridData.horizontalIndent = 16;
        this._checkPatternDropLocationSelected.setLayoutData((Object)gridData);
        this._checkPatternDropLocationSelected.setText(Messages.NL_Superimpose_a_pattern);
        this._checkPatternDropLocationSelected.addSelectionListener((SelectionListener)this);
        bPattern = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.PatternDropLocationSelected");
        this._checkPatternDropLocationSelected.setSelection(bPattern);
        this._buttonColorDropLocationSelected.setPattern(bPattern ? ColorSelectorButton.PATTERN_HATCH : ColorSelectorButton.PATTERN_NONE);
    }

    protected void createControlsEditorOpeningTab() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Group groupEditorTab = new Group((Composite)this, 0);
        GridData gridData = new GridData(768);
        groupEditorTab.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        groupEditorTab.setLayout((Layout)gridLayout);
        groupEditorTab.setText(Messages.NL_Editor_tab);
        Label label = new Label((Composite)groupEditorTab, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        label.setText(Messages.NL_Select_which_tab_is_shown_when_the_editor_is_opened);
        this._radioEditorTabDesign = new Button((Composite)groupEditorTab, 16);
        gridData = new GridData(768);
        gridData.horizontalIndent = 16;
        this._radioEditorTabDesign.setLayoutData((Object)gridData);
        this._radioEditorTabDesign.setText(Messages.NL_Design);
        this._radioEditorTabSource = new Button((Composite)groupEditorTab, 16);
        gridData = new GridData(768);
        gridData.horizontalIndent = 16;
        this._radioEditorTabSource.setLayoutData((Object)gridData);
        this._radioEditorTabSource.setText(Messages.NL_Source);
        this._radioEditorTabPreview = new Button((Composite)groupEditorTab, 16);
        gridData = new GridData(768);
        gridData.horizontalIndent = 16;
        this._radioEditorTabPreview.setLayoutData((Object)gridData);
        this._radioEditorTabPreview.setText(Messages.NL_Preview);
        int iTabIndex = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.EditorOpeningTab");
        switch (iTabIndex) {
            case 0: {
                this._radioEditorTabDesign.setSelection(true);
                break;
            }
            case 1: {
                this._radioEditorTabSource.setSelection(true);
                break;
            }
            case 2: {
                this._radioEditorTabPreview.setSelection(true);
                break;
            }
            default: {
                this._radioEditorTabDesign.setSelection(true);
            }
        }
    }

    protected void createControlsPerformance() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Group groupEditorTab = new Group((Composite)this, 0);
        GridData gridData = new GridData(768);
        groupEditorTab.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        groupEditorTab.setLayout((Layout)gridLayout);
        groupEditorTab.setText(Messages.NL_Performance);
        Label label = new Label((Composite)groupEditorTab, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        label.setText(Messages.NL_This_setting_is_applied_when_the_editor_is_opened);
        this._radioOptimizeSpeed = new Button((Composite)groupEditorTab, 16);
        gridData = new GridData(768);
        gridData.horizontalIndent = 16;
        this._radioOptimizeSpeed.setLayoutData((Object)gridData);
        this._radioOptimizeSpeed.setText(Messages.NL_Optimize_for_better_responsiveness);
        this._radioOptimizeResources = new Button((Composite)groupEditorTab, 16);
        gridData = new GridData(768);
        gridData.horizontalIndent = 16;
        this._radioOptimizeResources.setLayoutData((Object)gridData);
        this._radioOptimizeResources.setText(Messages.NL_Optimize_to_use_fewer_resources);
        int iTabIndex = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.Performance");
        switch (iTabIndex) {
            case 0: {
                this._radioOptimizeSpeed.setSelection(true);
                break;
            }
            case 1: {
                this._radioOptimizeResources.setSelection(true);
                break;
            }
            default: {
                this._radioOptimizeSpeed.setSelection(true);
            }
        }
    }

    protected void createControlsRenderEngine() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Group groupRenderEngineTab = new Group((Composite)this, 0);
        GridData gridData = new GridData(768);
        groupRenderEngineTab.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        groupRenderEngineTab.setLayout((Layout)gridLayout);
        groupRenderEngineTab.setText(Messages.NL_VisualEditor_RenderEngion);
        if (!Platform.getOSArch().equals("x86_64") || !Platform.getOS().equals("win32")) {
            if (!BrowserManager.getInstance().ECLIPSE_36) {
                this._radioRenderEngineWebKit = new Button((Composite)groupRenderEngineTab, 16);
                gridData = new GridData();
                gridData.horizontalIndent = 16;
                this._radioRenderEngineWebKit.setLayoutData((Object)gridData);
                this._radioRenderEngineWebKit.setText(Messages.NL_VisualEditor_RenderEngion_WEBKIT);
            }
            this._radioRenderEngineXULRunner = new Button((Composite)groupRenderEngineTab, 16);
            gridData = new GridData();
            gridData.horizontalIndent = 16;
            this._radioRenderEngineXULRunner.setLayoutData((Object)gridData);
            this._radioRenderEngineXULRunner.setText(Messages.NL_VisualEditor_RenderEngion_XULRUNNER);
        }
        if (Platform.getOS().equals("win32")) {
            this._radioRenderEngineIE = new Button((Composite)groupRenderEngineTab, 16);
            gridData = new GridData();
            gridData.horizontalIndent = 16;
            this._radioRenderEngineIE.setLayoutData((Object)gridData);
            this._radioRenderEngineIE.setText(Messages.NL_VisualEditor_RenderEngion_IE);
        }
        if ("linux".equals(Platform.getOS())) {
            this._radioRenderEngineUserConfigured = new Button((Composite)groupRenderEngineTab, 16);
            gridData = new GridData();
            gridData.horizontalIndent = 16;
            this._radioRenderEngineUserConfigured.setLayoutData((Object)gridData);
            this._radioRenderEngineUserConfigured.setText(Messages.NL_VisualEditor_RenderEngion_USER_CONFIGURED);
        }
        int iTabIndex = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.RenderEngine");
        switch (iTabIndex) {
            case 0: {
                if (this._radioRenderEngineUserConfigured == null) break;
                this._radioRenderEngineUserConfigured.setSelection(true);
                break;
            }
            case 1: {
                if (this._radioRenderEngineWebKit == null) break;
                this._radioRenderEngineWebKit.setSelection(true);
                break;
            }
            case 2: {
                if (this._radioRenderEngineXULRunner == null) break;
                this._radioRenderEngineXULRunner.setSelection(true);
                break;
            }
            case 3: {
                if (this._radioRenderEngineIE == null) break;
                this._radioRenderEngineIE.setSelection(true);
                break;
            }
            default: {
                if (this._radioRenderEngineUserConfigured == null) break;
                this._radioRenderEngineUserConfigured.setSelection(true);
            }
        }
    }

    protected void createControlsTransparency() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Group groupTransparency = new Group((Composite)this, 0);
        GridData gridData = new GridData(768);
        groupTransparency.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        groupTransparency.setLayout((Layout)gridLayout);
        groupTransparency.setText(Messages.NL_Tranparency);
        Label label = new Label((Composite)groupTransparency, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.NL_These_settings_are_applied_when_the_editor_is_opened);
        this._checkShowTransparencyControls = new Button((Composite)groupTransparency, 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 16;
        this._checkShowTransparencyControls.setLayoutData((Object)gridData);
        this._checkShowTransparencyControls.setText(Messages.NL_Show_transparency_controls);
        this._checkShowTransparencyControls.setSelection(EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.TransparencyControlsVisible"));
        this._checkShowTransparencyControls.addSelectionListener((SelectionListener)this);
        label = new Label((Composite)groupTransparency, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 16;
        label.setLayoutData((Object)gridData);
        this._radioTransparencyNone = new Button((Composite)groupTransparency, 16);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 16;
        this._radioTransparencyNone.setLayoutData((Object)gridData);
        this._radioTransparencyNone.setText(Messages.NL_Fully_transparent);
        this._radioTransparencyFixed = new Button((Composite)groupTransparency, 16);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 16;
        this._radioTransparencyFixed.setLayoutData((Object)gridData);
        this._radioTransparencyFixed.setText(Messages.NL_Dotted_transparency_pattern);
        this._radioTransparencyVariable = new Button((Composite)groupTransparency, 16);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 16;
        this._radioTransparencyVariable.setLayoutData((Object)gridData);
        this._radioTransparencyVariable.setText(Messages.NL_Variable_transparency);
        this._sliderTransparencyAmount = new Slider((Composite)groupTransparency, 0);
        gridData = new GridData(768);
        gridData.horizontalIndent = 32;
        this._sliderTransparencyAmount.setLayoutData((Object)gridData);
        this._labelTransparencyPercent = new Label((Composite)groupTransparency, 0);
        gridData = new GridData();
        this._labelTransparencyPercent.setLayoutData((Object)gridData);
        this._labelTransparencyPercent.setText("000%");
        if (!Platform.getOS().equals("win32")) {
            this._radioTransparencyVariable.setEnabled(false);
            this._sliderTransparencyAmount.setEnabled(false);
            this._labelTransparencyPercent.setEnabled(false);
        }
        int iTransparencyMode = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyMode");
        switch (iTransparencyMode) {
            case 0: {
                this._radioTransparencyNone.setSelection(true);
                break;
            }
            case 1: {
                this._radioTransparencyFixed.setSelection(true);
                break;
            }
            default: {
                this._radioTransparencyVariable.setSelection(true);
            }
        }
        int iTransparencyAmount = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyAmount");
        this._sliderTransparencyAmount.setValues(iTransparencyAmount, 0, 256, 1, 1, 10);
        this.updateTransparencyControls();
        label = new Label((Composite)groupTransparency, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this._checkSemiTransparencyWhileDragging = new Button((Composite)groupTransparency, 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this._checkSemiTransparencyWhileDragging.setLayoutData((Object)gridData);
        this._checkSemiTransparencyWhileDragging.setText(Messages.NL_Enable_semiXhyphenXtransparency_while_dragging);
        this._checkSemiTransparencyWhileDragging.setSelection(EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyWhileDragging"));
        this._checkSemiTransparencyWhileDragging.addSelectionListener((SelectionListener)this);
        this._radioTransparencyNone.addSelectionListener((SelectionListener)this);
        this._radioTransparencyFixed.addSelectionListener((SelectionListener)this);
        this._radioTransparencyVariable.addSelectionListener((SelectionListener)this);
        this._sliderTransparencyAmount.addSelectionListener((SelectionListener)this);
    }

    protected void createControlsWidgetCreation() {
        Group groupWidgetCreation = new Group((Composite)this, 0);
        GridData gridData = new GridData(768);
        groupWidgetCreation.setLayoutData((Object)gridData);
        groupWidgetCreation.setLayout((Layout)new GridLayout());
        groupWidgetCreation.setText(Messages.NL_Widget_creation);
        this._checkPromptForNewWidgetName = new Button((Composite)groupWidgetCreation, 32);
        gridData = new GridData(768);
        this._checkPromptForNewWidgetName.setLayoutData((Object)gridData);
        this._checkPromptForNewWidgetName.setText(Messages.NL_Prompt_for_a_variable_name);
        this._checkPromptForNewWidgetName.setSelection(EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.PromptForNewWidgetName"));
    }

    @Override
    public String getHelpID() {
        return EvHelp.PREFERENCES_GENERAL;
    }

    @Override
    public void performDefaults() {
        this._radioEditorTabDesign.setSelection(false);
        this._radioEditorTabSource.setSelection(false);
        this._radioEditorTabPreview.setSelection(false);
        switch (0) {
            case 0: {
                this._radioEditorTabDesign.setSelection(true);
                break;
            }
            case 1: {
                this._radioEditorTabSource.setSelection(true);
                break;
            }
            case 2: {
                this._radioEditorTabPreview.setSelection(true);
                break;
            }
            default: {
                this._radioEditorTabDesign.setSelection(true);
            }
        }
        this._checkShowTransparencyControls.setSelection(false);
        this._radioTransparencyNone.setSelection(false);
        this._radioTransparencyFixed.setSelection(false);
        this._radioTransparencyVariable.setSelection(false);
        switch (0) {
            case 0: {
                this._radioTransparencyNone.setSelection(true);
                break;
            }
            case 1: {
                this._radioTransparencyFixed.setSelection(true);
                break;
            }
            default: {
                this._radioTransparencyVariable.setSelection(true);
            }
        }
        this._sliderTransparencyAmount.setSelection(255);
        this._checkSemiTransparencyWhileDragging.setSelection(true);
        this.updateTransparencyControls();
        this._buttonColorSelection.setColor("0 0 140");
        this._buttonColorDropLocationPotential.setColor("253 253 237");
        this._buttonColorDropLocationSelected.setColor("234 248 213");
        boolean bPattern = false;
        this._buttonColorDropLocationSelected.setPattern(bPattern ? ColorSelectorButton.PATTERN_HATCH : ColorSelectorButton.PATTERN_NONE);
        this._checkPatternDropLocationSelected.setSelection(bPattern);
        bPattern = true;
        this._buttonColorSelection.setPattern(bPattern ? ColorSelectorButton.PATTERN_DENTAL : ColorSelectorButton.PATTERN_NONE);
        this._checkPatternSelection.setSelection(bPattern);
        this._radioOptimizeResources.setSelection(false);
        this._radioOptimizeSpeed.setSelection(true);
        int defaultBrowser = BrowserManager.getInstance().getDefaultRenderEngine();
        if (this._radioRenderEngineUserConfigured != null) {
            this._radioRenderEngineUserConfigured.setSelection(defaultBrowser == 0);
        }
        if (this._radioRenderEngineWebKit != null) {
            this._radioRenderEngineWebKit.setSelection(defaultBrowser == 1);
        }
        if (this._radioRenderEngineXULRunner != null) {
            this._radioRenderEngineXULRunner.setSelection(defaultBrowser == 2);
        }
        if (this._radioRenderEngineIE != null) {
            this._radioRenderEngineIE.setSelection(defaultBrowser == 3);
        }
        this._checkPromptForNewWidgetName.setSelection(true);
    }

    public boolean performOk() {
        int iValue = 0;
        if (this._radioEditorTabSource.getSelection()) {
            iValue = 1;
        } else if (this._radioEditorTabPreview.getSelection()) {
            iValue = 2;
        }
        EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.EditorOpeningTab", iValue);
        iValue = 0;
        if (this._radioTransparencyFixed.getSelection()) {
            iValue = 1;
        } else if (this._radioTransparencyVariable.getSelection()) {
            iValue = 2;
        }
        EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyMode", iValue);
        EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyAmount", this._sliderTransparencyAmount.getSelection());
        EvPreferences.setBoolean("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyWhileDragging", this._checkSemiTransparencyWhileDragging.getSelection());
        EvPreferences.setBoolean("org.eclipse.edt.ide.rui.visualeditor.TransparencyControlsVisible", this._checkShowTransparencyControls.getSelection());
        String strColor = this._buttonColorSelection.getColor();
        String strCurrent = EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.ColorSelection");
        if (!strColor.equals(strCurrent)) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.ColorSelection", strColor);
        }
        boolean bCurrent = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.PatternSelection");
        boolean bPattern = this._checkPatternSelection.getSelection();
        if (bPattern != bCurrent) {
            EvPreferences.setBoolean("org.eclipse.edt.ide.rui.visualeditor.PatternSelection", bPattern);
        }
        if (!(strColor = this._buttonColorDropLocationPotential.getColor()).equals(strCurrent = EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationPotential"))) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationPotential", strColor);
        }
        if (!(strColor = this._buttonColorDropLocationSelected.getColor()).equals(strCurrent = EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationSelected"))) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationSelected", strColor);
        }
        bCurrent = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.PatternDropLocationSelected");
        bPattern = this._checkPatternDropLocationSelected.getSelection();
        if (bPattern != bCurrent) {
            EvPreferences.setBoolean("org.eclipse.edt.ide.rui.visualeditor.PatternDropLocationSelected", bPattern);
        }
        iValue = 0;
        if (this._radioOptimizeSpeed.getSelection()) {
            iValue = 0;
        } else if (this._radioOptimizeResources.getSelection()) {
            iValue = 1;
        }
        EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.Performance", iValue);
        iValue = 0;
        if (this._radioRenderEngineUserConfigured != null && this._radioRenderEngineUserConfigured.getSelection()) {
            iValue = 0;
        } else if (this._radioRenderEngineWebKit != null && this._radioRenderEngineWebKit.getSelection()) {
            iValue = 1;
        } else if (this._radioRenderEngineXULRunner != null && this._radioRenderEngineXULRunner.getSelection()) {
            iValue = 2;
        } else if (this._radioRenderEngineIE != null && this._radioRenderEngineIE.getSelection()) {
            iValue = 3;
        }
        EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.RenderEngine", iValue);
        bCurrent = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.PromptForNewWidgetName");
        boolean bPrompt = this._checkPromptForNewWidgetName.getSelection();
        if (bPrompt != bCurrent) {
            EvPreferences.setBoolean("org.eclipse.edt.ide.rui.visualeditor.PromptForNewWidgetName", bPrompt);
        }
        this.cleanup();
        return true;
    }

    public void updateTransparencyControls() {
        int iPercent = this._sliderTransparencyAmount.getSelection() * 100 / 255;
        StringBuffer strb = new StringBuffer();
        double dPercentage = new Double(iPercent);
        if (dPercentage < 100.0) {
            strb.append("  ");
        }
        if (dPercentage < 0.1) {
            strb.append("  ");
        }
        this._labelTransparencyPercent.setText(String.valueOf(this._decimalFormat.format(dPercentage / 100.0)) + strb.toString());
        this._sliderTransparencyAmount.setEnabled(this._radioTransparencyVariable.getSelection());
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._checkPatternDropLocationSelected) {
            this._buttonColorDropLocationSelected.setPattern(this._checkPatternDropLocationSelected.getSelection() ? ColorSelectorButton.PATTERN_HATCH : ColorSelectorButton.PATTERN_NONE);
        } else if (event.widget == this._checkPatternSelection) {
            this._buttonColorSelection.setPattern(this._checkPatternSelection.getSelection() ? ColorSelectorButton.PATTERN_DENTAL : ColorSelectorButton.PATTERN_NONE);
        } else {
            this.updateTransparencyControls();
        }
    }
}

