/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.preferences;

import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvHelp;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.EvPreferences;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.IEvPreferencePage;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.ColorUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class EvPreferencePageBrowserSize
extends Composite
implements DisposeListener,
PaintListener,
SelectionListener,
IEvPreferencePage {
    protected static final int HORZ_MAXIMUM_WIDTH = 3000;
    protected static final int HORZ_MINIMUM_WIDTH = 200;
    protected static final int VERT_MAXIMUM_HEIGHT = 5000;
    protected static final int VERT_MINIMUM_HEIGHT = 200;
    protected Button _checkShowControls = null;
    protected Color _colorDefault = ColorUtil.getColorFromRGBString(Display.getCurrent(), "200 200 255");
    protected Composite _compositeVisualSize = null;
    protected Label _labelXDef = null;
    protected Label _labelXMax = null;
    protected Label _labelXMin = null;
    protected Label _labelYDef = null;
    protected Label _labelYMax = null;
    protected Label _labelYMin = null;
    protected Slider _sliderXDef = null;
    protected Slider _sliderXMax = null;
    protected Slider _sliderXMin = null;
    protected Slider _sliderYDef = null;
    protected Slider _sliderYMax = null;
    protected Slider _sliderYMin = null;

    public EvPreferencePageBrowserSize(Composite compositeParent, int iStyle) {
        super(compositeParent, iStyle);
        this.createControls();
        Dialog.applyDialogFont((Control)compositeParent);
        EvHelp.setHelp((Control)this, EvHelp.PREFERENCES_BROWSER_SIZE);
        this.addDisposeListener(this);
    }

    protected void createControls() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.NL_Configure_the_design_area_browser_size_controls);
        label = new Label((Composite)this, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this._checkShowControls = new Button((Composite)this, 32);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        this._checkShowControls.setLayoutData((Object)gridData);
        this._checkShowControls.setText(Messages.NL_Show_the_browser_size_controls_when_the_editor_is_opened);
        boolean bHide = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeControlsVisible");
        this._checkShowControls.setSelection(bHide);
        this._checkShowControls.addSelectionListener((SelectionListener)this);
        Composite composite = new Composite((Composite)this, 0);
        gridData = new GridData(272);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        label = new Label(composite, 0);
        gridData = new GridData(1808);
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 1024;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.NL_Vertical);
        label = new Label(composite, 258);
        gridData = new GridData(264);
        label.setLayoutData((Object)gridData);
        Composite compositeHorizontal = new Composite((Composite)this, 0);
        gridData = new GridData();
        gridData.verticalAlignment = 1024;
        compositeHorizontal.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        compositeHorizontal.setLayout((Layout)gridLayout);
        label = new Label(compositeHorizontal, 0);
        label.setText(Messages.NL_Horizontal);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 0x1000000;
        label.setLayoutData((Object)gridData);
        label = new Label(compositeHorizontal, 258);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label = new Label(compositeHorizontal, 0x1000000);
        label.setLayoutData((Object)new GridData(64));
        label.setText(Messages.NL_Minimum);
        label = new Label(compositeHorizontal, 0x1000000);
        label.setLayoutData((Object)new GridData(64));
        label.setText(Messages.NL_Default);
        label = new Label(compositeHorizontal, 0x1000000);
        label.setLayoutData((Object)new GridData(64));
        label.setText(Messages.NL_Maximum);
        this._labelXMin = new Label(compositeHorizontal, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        this._labelXMin.setLayoutData((Object)gridData);
        this._labelXMin.setText("0000");
        this._labelXDef = new Label(compositeHorizontal, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        this._labelXDef.setLayoutData((Object)gridData);
        this._labelXDef.setText("0000");
        this._labelXMax = new Label(compositeHorizontal, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        this._labelXMax.setLayoutData((Object)gridData);
        this._labelXMax.setText("0000");
        this._sliderXMin = new Slider(compositeHorizontal, 256);
        gridData = new GridData();
        gridData.widthHint = 100;
        this._sliderXMin.setLayoutData((Object)gridData);
        this._sliderXDef = new Slider(compositeHorizontal, 256);
        gridData = new GridData();
        gridData.widthHint = 100;
        this._sliderXDef.setLayoutData((Object)gridData);
        this._sliderXMax = new Slider(compositeHorizontal, 256);
        gridData = new GridData();
        gridData.widthHint = 100;
        this._sliderXMax.setLayoutData((Object)gridData);
        composite = new Composite((Composite)this, 0);
        gridData = new GridData();
        composite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        label = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.NL_Minimum);
        this._labelYMin = new Label(composite, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        this._labelYMin.setLayoutData((Object)gridData);
        this._labelYMin.setText("0000");
        this._sliderYMin = new Slider((Composite)this, 512);
        gridData = new GridData();
        gridData.heightHint = 100;
        this._sliderYMin.setLayoutData((Object)gridData);
        this._compositeVisualSize = new Composite((Composite)this, 264192);
        gridData = new GridData(272);
        gridData.verticalSpan = 3;
        this._compositeVisualSize.setLayoutData((Object)gridData);
        composite = new Composite((Composite)this, 0);
        gridData = new GridData();
        composite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        label = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.NL_Default);
        this._labelYDef = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        this._labelYDef.setLayoutData((Object)gridData);
        this._labelYDef.setText("0000");
        this._sliderYDef = new Slider((Composite)this, 512);
        gridData = new GridData();
        gridData.heightHint = 100;
        this._sliderYDef.setLayoutData((Object)gridData);
        composite = new Composite((Composite)this, 0);
        gridData = new GridData();
        composite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        label = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.NL_Maximum);
        this._labelYMax = new Label(composite, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        this._labelYMax.setLayoutData((Object)gridData);
        this._labelYMax.setText("0000");
        this._sliderYMax = new Slider((Composite)this, 512);
        gridData = new GridData();
        gridData.heightHint = 100;
        this._sliderYMax.setLayoutData((Object)gridData);
        int iXMin = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumWidth");
        int iXMax = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumWidth");
        int iXDef = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultWidth");
        int iYMin = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumHeight");
        int iYMax = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumHeight");
        int iYDef = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultHeight");
        this.updateSliders(iXMin, iXDef, iXMax, iYMin, iYDef, iYMax);
        this.updateLabels();
        this._sliderXMin.addSelectionListener((SelectionListener)this);
        this._sliderXDef.addSelectionListener((SelectionListener)this);
        this._sliderXMax.addSelectionListener((SelectionListener)this);
        this._sliderYMin.addSelectionListener((SelectionListener)this);
        this._sliderYDef.addSelectionListener((SelectionListener)this);
        this._sliderYMax.addSelectionListener((SelectionListener)this);
        this._compositeVisualSize.addPaintListener((PaintListener)this);
    }

    @Override
    public String getHelpID() {
        return EvHelp.PREFERENCES_BROWSER_SIZE;
    }

    public void paintControl(PaintEvent e) {
        Image image = new Image((Device)e.widget.getDisplay(), ((Composite)e.widget).getBounds());
        GC gc = new GC((Drawable)image);
        Rectangle rect = ((Composite)e.widget).getBounds();
        int iX = 8;
        int iY = 8;
        int iW = rect.width - 16;
        int iH = rect.height - 16;
        gc.setBackground(e.widget.getDisplay().getSystemColor(1));
        gc.fillRectangle(0, 0, rect.width, rect.height);
        int max = this._sliderXMax.getSelection();
        int defaultXCurrent = this._sliderXDef.getSelection();
        int defaultX = defaultXCurrent * iW / max;
        max = this._sliderYMax.getSelection();
        int defaultYCurrent = this._sliderYDef.getSelection();
        int defaultY = defaultYCurrent * iH / max;
        gc.setBackground(this._colorDefault);
        gc.fillRectangle(iX + 1, iY + 1, defaultX - 1, defaultY - 1);
        gc.setForeground(e.widget.getDisplay().getSystemColor(2));
        gc.drawLine(iX + defaultX, iY, iX + defaultX, iY + defaultY);
        gc.drawLine(iX, iY + defaultY, iX + defaultX, iY + defaultY);
        max = this._sliderXMax.getSelection();
        int minXCurrent = this._sliderXMin.getSelection();
        int minX = minXCurrent * iW / max;
        max = this._sliderYMax.getSelection();
        int minYCurrent = this._sliderYMin.getSelection();
        int minY = minYCurrent * iH / max;
        gc.setForeground(e.widget.getDisplay().getSystemColor(2));
        gc.setLineStyle(2);
        gc.drawLine(iX + minX, iY, iX + minX, iY + minY);
        gc.drawLine(iX, iY + minY, iX + minX, iY + minY);
        gc.setForeground(e.widget.getDisplay().getSystemColor(2));
        gc.setLineStyle(1);
        gc.drawLine(iX, iY, iX + iW, iY);
        gc.drawLine(iX + iW - 4, iY - 2, iX + iW, iY);
        gc.drawLine(iX + iW - 4, iY - 1, iX + iW, iY);
        gc.drawLine(iX + iW - 4, iY + 1, iX + iW, iY);
        gc.drawLine(iX + iW - 4, iY + 2, iX + iW, iY);
        gc.drawLine(iX, iY, iX, iY + iH);
        gc.drawLine(iX - 2, iY + iH - 4, iX, iY + iH);
        gc.drawLine(iX - 1, iY + iH - 4, iX, iY + iH);
        gc.drawLine(iX + 1, iY + iH - 4, iX, iY + iH);
        gc.drawLine(iX + 2, iY + iH - 4, iX, iY + iH);
        e.gc.drawImage(image, 0, 0);
        image.dispose();
        gc.dispose();
    }

    @Override
    public void performDefaults() {
        this._checkShowControls.setSelection(false);
        int iXMin = 200;
        int iXMax = 3000;
        int iXDef = 1000;
        int iYMin = 200;
        int iYMax = 5000;
        int iYDef = 1000;
        this.updateSliders(iXMin, iXDef, iXMax, iYMin, iYDef, iYMax);
        this.updateLabels();
        this._compositeVisualSize.redraw();
    }

    public boolean performOk() {
        EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumWidth", this._sliderXMax.getSelection());
        EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumWidth", this._sliderXMin.getSelection());
        EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultWidth", this._sliderXDef.getSelection());
        EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumHeight", this._sliderYMax.getSelection());
        EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumHeight", this._sliderYMin.getSelection());
        EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultHeight", this._sliderYDef.getSelection());
        return true;
    }

    protected void updateLabel(Slider slider, Label label) {
        String strValue = Integer.toString(slider.getSelection());
        while (strValue.length() < 4) {
            strValue = "0" + strValue;
        }
        label.setText(strValue);
    }

    protected void updateLabels() {
        this.updateLabel(this._sliderXMin, this._labelXMin);
        this.updateLabel(this._sliderXMax, this._labelXMax);
        this.updateLabel(this._sliderXDef, this._labelXDef);
        this.updateLabel(this._sliderYMin, this._labelYMin);
        this.updateLabel(this._sliderYMax, this._labelYMax);
        this.updateLabel(this._sliderYDef, this._labelYDef);
    }

    protected void updateSlider(Slider slider, int iMin, int iMax, int iDef) {
        slider.removeSelectionListener((SelectionListener)this);
        slider.setValues(iDef, iMin, iMax + 1, 1, 1, 10);
        slider.addSelectionListener((SelectionListener)this);
    }

    protected void updateSliderMaximum(Slider slider, int iMax) {
        slider.removeSelectionListener((SelectionListener)this);
        slider.setValues(slider.getSelection(), slider.getMinimum(), iMax + 1, 1, 1, 10);
        slider.addSelectionListener((SelectionListener)this);
    }

    protected void updateSliderMinimum(Slider slider, int iMin) {
        slider.removeSelectionListener((SelectionListener)this);
        slider.setValues(slider.getSelection(), iMin, slider.getMaximum(), 1, 1, 10);
        slider.addSelectionListener((SelectionListener)this);
    }

    protected void updateSliders(int iXMin, int iXDef, int iXMax, int iYMin, int iYDef, int iYMax) {
        this.updateSlider(this._sliderXMin, 200, iXMax - 200, iXMin);
        this.updateSlider(this._sliderXMax, iXMin + 200, 3000, iXMax);
        this.updateSlider(this._sliderXDef, this._sliderXMin.getSelection(), this._sliderXMax.getSelection(), iXDef);
        this.updateSlider(this._sliderYMin, 200, iYMax - 200, iYMin);
        this.updateSlider(this._sliderYMax, iYMin + 200, 5000, iYMax);
        this.updateSlider(this._sliderYDef, this._sliderYMin.getSelection(), this._sliderYMax.getSelection(), iYDef);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this._colorDefault != null && !this._colorDefault.isDisposed()) {
            this._colorDefault.dispose();
            this._colorDefault = null;
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._checkShowControls) {
            EvPreferences.setBoolean("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeControlsVisible", this._checkShowControls.getSelection());
        } else if (event.widget == this._sliderXMin) {
            int minSelection = this._sliderXMin.getSelection();
            this.updateSliderMinimum(this._sliderXDef, minSelection);
            this.updateSliderMinimum(this._sliderXMax, minSelection + 200);
        } else if (event.widget == this._sliderYMin) {
            int minSelection = this._sliderYMin.getSelection();
            this.updateSliderMinimum(this._sliderYDef, minSelection);
            this.updateSliderMinimum(this._sliderYMax, minSelection + 200);
        } else if (event.widget == this._sliderXMax) {
            int maxSelection = this._sliderXMax.getSelection();
            this.updateSliderMaximum(this._sliderXDef, maxSelection);
            this.updateSliderMaximum(this._sliderXMin, maxSelection - 200);
        } else if (event.widget == this._sliderYMax) {
            int maxSelection = this._sliderYMax.getSelection();
            this.updateSliderMaximum(this._sliderYDef, maxSelection);
            this.updateSliderMaximum(this._sliderYMin, maxSelection - 200);
        }
        this.updateLabels();
        this._compositeVisualSize.redraw();
    }
}

