/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.rui.utils.WorkingCopyGenerationResult;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvEditor;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvPreviewBrowserManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvPreviewToolbar;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.AnimatedBusyPainter;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class EvPreviewPage
extends EditorPart
implements ProgressListener,
SelectionListener {
    protected AnimatedBusyPainter _animatedBusyPainter = null;
    protected boolean _bUpdateRequired = true;
    protected boolean _bFullRefresh = true;
    protected Browser _browser = null;
    protected EvPreviewBrowserManager _browserManager = null;
    protected Composite _compositePreview = null;
    protected EvEditor _editor = null;
    protected WorkingCopyGenerationResult _generationResult = null;
    protected CTabFolder _tabFolder = null;
    protected EvPreviewToolbar _toolbar = null;

    public EvPreviewPage(EvEditor editor) {
        this._editor = editor;
    }

    public void changed(ProgressEvent event) {
    }

    public void terminate() {
        if (this._browserManager != null) {
            this._browserManager.terminate();
        }
    }

    public void completed(ProgressEvent event) {
        this._animatedBusyPainter.animationStop();
    }

    protected void createBrowser() {
        this._browser = this._editor.createBrowser(this._compositePreview);
        if (this._browser == null) {
            return;
        }
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this._browser.setLayoutData((Object)gridData);
        this._browser.removeProgressListener((ProgressListener)this);
        this._browser.addProgressListener((ProgressListener)this);
        if (this._browserManager == null) {
            this._browserManager = new EvPreviewBrowserManager(this._browser, this._editor.getURL(), this, this._editor.getEditorProvider());
        }
        this._compositePreview.layout();
    }

    public void createPartControl(Composite compositeParent) {
        this._compositePreview = new Composite(compositeParent, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.numColumns = 2;
        this._compositePreview.setLayout((Layout)gridLayout);
        this._animatedBusyPainter = new AnimatedBusyPainter(this._compositePreview);
        GridData gridData = new GridData();
        gridData.widthHint = 16;
        gridData.heightHint = 16;
        gridData.horizontalIndent = 4;
        this._animatedBusyPainter.setLayoutData(gridData);
        this._toolbar = new EvPreviewToolbar(this._compositePreview, 0, this);
        gridData = new GridData(768);
        this._toolbar.setLayoutData(gridData);
        Label label = new Label(this._compositePreview, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this._editor.getPageFolder().addSelectionListener((SelectionListener)this);
    }

    public EvPreviewBrowserManager getBrowserManager() {
        return this._browserManager;
    }

    public void doSave(IProgressMonitor arg0) {
    }

    public void doSaveAs() {
    }

    public Browser getBrowser() {
        return this._browser;
    }

    public EvEditor getEditor() {
        return this._editor;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
    }

    public void inputChanged(IEditorInput input) {
        if (this._browserManager != null) {
            this._browserManager = new EvPreviewBrowserManager(this._browser, this._editor.getURL(), this, this._editor.getEditorProvider());
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void resetBrowserToNull() {
        this._browser = null;
    }

    public void setFocus() {
    }

    protected void updateBrowser(WorkingCopyGenerationResult result) {
        this._generationResult = result;
        if (this.getEditor().getPageIndex() != 2) {
            this._bUpdateRequired = true;
            return;
        }
        if (this._browser == null) {
            this.createBrowser();
        }
        if (!this._editor.isRuiHandler()) {
            String strURL = Activator.getStateResourceURL("empty.html");
            if (strURL != null) {
                this._browser.setUrl(strURL);
            }
            return;
        }
        if (this._browserManager != null) {
            if (result == null || result.hasError()) {
                this._bFullRefresh = true;
            }
            if (this._bFullRefresh) {
                this._animatedBusyPainter.animationStart();
            }
            this._browserManager.refreshBrowser(this._bFullRefresh);
            this._bFullRefresh = false;
        }
        this._bUpdateRequired = false;
    }

    protected void updateBrowserIncremental(WorkingCopyGenerationResult result) {
        this._generationResult = result;
        if (!this._editor.isRuiHandler()) {
            return;
        }
        if (this.getEditor().getPageIndex() != 2) {
            this._bUpdateRequired = true;
            return;
        }
        if (this._browser == null) {
            this.createBrowser();
        }
        if (this._browserManager != null) {
            this._browserManager.refreshBrowserIncremental();
        }
        this._bUpdateRequired = false;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        CTabFolder tabFolder = (CTabFolder)event.widget;
        if (tabFolder.getSelectionIndex() != 2) {
            return;
        }
        if (this._browser == null || this._bUpdateRequired) {
            this.updateBrowser(this._generationResult);
        }
    }
}

