/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.editor;

import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOutlinePage;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.outline.OutlinePage;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.PageBook;

public class EvEditorOutlinePage
extends OutlinePage {
    public static final int DESIGN_PAGE = 0;
    public static final int SOURCE_PAGE = 1;
    public static final int PREVIEW_PAGE = 3;
    protected Control _controlDesign = null;
    protected Control _controlSource = null;
    protected Control _controlPrevew = null;
    protected EvDesignOutlinePage _outlineDesign = null;
    protected PageBook _pageBook = null;

    public EvEditorOutlinePage(IEGLDocument document, String strOutlineContextMenuID, EGLEditor eglEditor, EvDesignOutlinePage outlineDesign) {
        super(document, strOutlineContextMenuID, eglEditor);
        this._outlineDesign = outlineDesign;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this._outlineDesign == null) {
            return;
        }
        this._outlineDesign.addSelectionChangedListener(listener);
        super.addSelectionChangedListener(listener);
    }

    public void createControl(Composite compositeParent) {
        this._pageBook = (PageBook)compositeParent;
        if (this._outlineDesign != null) {
            this._outlineDesign.createControl(compositeParent);
        }
        super.createControl(compositeParent);
        if (this._outlineDesign == null) {
            return;
        }
        this._controlDesign = this._outlineDesign.getControl();
        this._controlSource = super.getControl();
        this._controlPrevew = new Composite(compositeParent, 0);
    }

    public void dispose() {
        if (this._controlDesign != null && !this._controlDesign.isDisposed()) {
            this._controlDesign = this._outlineDesign.getControl();
        }
        if (this._outlineDesign != null) {
            this._outlineDesign.dispose();
        }
        if (this._controlSource != null && !this._controlSource.isDisposed()) {
            this._controlSource.dispose();
        }
        if (this._controlPrevew != null && !this._controlPrevew.isDisposed()) {
            this._controlPrevew.dispose();
        }
        super.dispose();
    }

    public Control getControl() {
        return this._controlDesign;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this._outlineDesign.removeSelectionChangedListener(listener);
        super.removeSelectionChangedListener(listener);
    }

    public void showPage(int iPage) {
        IActionBars actionBars;
        if (this._pageBook != null) {
            switch (iPage) {
                case 0: {
                    this._pageBook.showPage(this._controlDesign);
                    break;
                }
                case 1: {
                    this._pageBook.showPage(this._controlSource);
                    break;
                }
                case 3: {
                    this._pageBook.showPage(this._controlPrevew);
                }
            }
        }
        if ((actionBars = this.getSite().getActionBars()) == null) {
            return;
        }
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        if (toolBarManager == null) {
            return;
        }
        IContributionItem[] items = toolBarManager.getItems();
        if (items == null) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            items[i].setVisible(iPage == 1);
            ++i;
        }
        toolBarManager.update(true);
    }

    public void update() {
        this._outlineDesign.update();
    }

    public void widgetSelectedFromDesignPage(WidgetPart widget) {
        if (widget != null) {
            StructuredSelection selection = new StructuredSelection((Object)widget);
            this._outlineDesign.setSelection((ISelection)selection);
        } else {
            this._outlineDesign.setSelection((ISelection)new StructuredSelection());
        }
    }
}

