/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ProjectCreationOperation
extends WorkspaceModifyOperation {
    private ProjectConfiguration configuration;

    public ProjectCreationOperation(ProjectConfiguration configuration) {
        this.configuration = configuration;
    }

    public ProjectCreationOperation(ProjectConfiguration configuration, ISchedulingRule rule) {
        super(rule);
        this.configuration = configuration;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject currentProject = null;
        Path currentLocation = null;
        currentProject = fWorkspaceRoot.getProject(this.configuration.getProjectName());
        currentLocation = this.configuration.isUseDefaults() ? new Path(this.configuration.getInitialProjectLocation()) : new Path(this.configuration.getCustomProjectLocation());
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.BuildPathsBlockOperationdesc_project, 10);
        try {
            if (!currentProject.exists()) {
                IProjectDescription desc = currentProject.getWorkspace().newProjectDescription(currentProject.getName());
                if (Platform.getLocation().equals((Object)currentLocation)) {
                    currentLocation = null;
                }
                desc.setLocation((IPath)currentLocation);
                currentProject.create(desc, monitor);
                EGLCore.create((IProject)currentProject);
                monitor = null;
            }
            if (!currentProject.isOpen()) {
                currentProject.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

