/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.Bindings;
import org.eclipse.edt.ide.ui.internal.deployment.Deployment;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentPackage;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.Service;
import org.eclipse.edt.ide.ui.internal.deployment.Services;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.wizards.EGLPartConfiguration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;

public class CopyEGLDDConfiguration
extends EGLPartConfiguration {
    private EGLDeploymentRoot fCurrRoot;
    private IProject fCurrProject;
    private Object[] fSelectedElement;
    private IFile fCurrEGLDDFile;

    public void init(EGLDeploymentRoot root, IFile currEGLDDFile, IProject proj) {
        this.fCurrRoot = root;
        this.fCurrProject = proj;
        this.fCurrEGLDDFile = currEGLDDFile;
        this.fSelectedElement = new Object[0];
    }

    public IProject getCurrentProject() {
        return this.fCurrProject;
    }

    public IFile getCurrentEGLDDFile() {
        return this.fCurrEGLDDFile;
    }

    public IFile getCopyFromEGLDDFile(String filePath) {
        IWorkspaceRoot workspaceRoot = this.fCurrProject.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile((IPath)new Path(filePath));
        return file;
    }

    public Object getSameNameNodeInCurrentEGLDD(Object element, String currLabel) {
        if (element instanceof Binding) {
            return EGLDDRootHelper.getBindingByName(this.fCurrRoot, currLabel);
        }
        if (element instanceof Service) {
            return EGLDDRootHelper.getServiceByImpl(this.fCurrRoot, currLabel);
        }
        return null;
    }

    public void updateSelectedElements(Object[] checkedElements) {
        this.fSelectedElement = checkedElements;
    }

    public void executeCopy() {
        Deployment deployment = this.fCurrRoot.getDeployment();
        DeploymentFactory factory = DeploymentFactory.eINSTANCE;
        int i = 0;
        while (i < this.fSelectedElement.length) {
            EList list;
            EObject eobj = (EObject)this.fSelectedElement[i];
            if (eobj instanceof Binding) {
                Bindings bindings = deployment.getBindings();
                if (bindings == null) {
                    bindings = factory.createBindings();
                    deployment.setBindings(bindings);
                }
                if (eobj instanceof Binding) {
                    list = bindings.getBinding();
                    this.removeSameNameNode(eobj, ((Binding)eobj).getName(), list);
                    list.add((Object)EcoreUtil.copy((EObject)eobj));
                }
            } else if (eobj instanceof Service) {
                Services wss = deployment.getServices();
                if (wss == null) {
                    wss = factory.createServices();
                    deployment.setServices(wss);
                }
                list = wss.getService();
                this.removeSameNameNode(eobj, ((Service)eobj).getImplementation(), list);
                list.add((Object)EcoreUtil.copy((EObject)eobj));
            }
            ++i;
        }
    }

    private void removeSameNameNode(Object obj, String nameLabel, EList list) {
        Object sameNameNode = this.getSameNameNodeInCurrentEGLDD(obj, nameLabel);
        if (sameNameNode != null) {
            list.remove(sameNameNode);
        }
    }

    public static class EGLDeploymentTreeContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            ArrayList<Object> children = new ArrayList<Object>();
            if (parentElement instanceof EGLDeploymentRoot) {
                Services wss;
                EGLDeploymentRoot root = (EGLDeploymentRoot)parentElement;
                Deployment deployment = root.getDeployment();
                Bindings bindings = deployment.getBindings();
                if (bindings != null) {
                    children.add(bindings);
                }
                if ((wss = deployment.getServices()) != null) {
                    children.add(wss);
                }
            } else if (parentElement instanceof Bindings) {
                Bindings bindings = (Bindings)parentElement;
                children.addAll((Collection<Object>)bindings.getBinding());
            } else if (parentElement instanceof Services) {
                children.addAll((Collection<Object>)((Services)parentElement).getService());
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != oldInput) {
                viewer.refresh();
            }
        }
    }

    public static class EGLDeploymentTreeLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            DeploymentPackage pkg = DeploymentPackage.eINSTANCE;
            if (element instanceof Bindings) {
                return pkg.getBindings().getName();
            }
            if (element instanceof Services) {
                return pkg.getServices().getName();
            }
            if (element instanceof Binding) {
                return ((Binding)element).getName();
            }
            if (element instanceof Service) {
                return ((Service)element).getImplementation();
            }
            return "";
        }
    }
}

