/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.util.TabFolderLayout;
import org.eclipse.edt.ide.ui.internal.wizards.EGLFileWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.InterfaceConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class WSDLWizardPage
extends EGLFileWizardPage
implements PropertyChangeListener {
    private int nColumns = 5;
    protected StringDialogField fInterfaceDialogField;
    protected CheckedListDialogField fFunctionListField;
    protected InterfaceFieldAdapter adapter = new InterfaceFieldAdapter();
    private CTabFolder fTabFolder;
    private Button bis4RuiCheckBox;
    protected Composite[] tabControls;
    private Hashtable fieldcontrol2InterfaceIndex = new Hashtable();
    private StatusInfo fInterfaceNameStatus = new StatusInfo();
    private StatusInfo fFuncSelSatus = new StatusInfo();

    public WSDLWizardPage(String pageName) {
        super(pageName);
    }

    @Override
    protected boolean shouldResetErrorStatus() {
        return false;
    }

    private EGLFileConfiguration getConfiguration() {
        return (EGLFileConfiguration)((EGLPartWizard)this.getWizard()).getConfiguration(this.getName());
    }

    @Override
    protected EGLFileConfiguration getFileConfiguration() {
        return this.getConfiguration();
    }

    @Override
    public void updateControlValues() {
        super.updateControlValues();
        this.updateTabFolder();
    }

    private void updateTabFolder() {
        if (this.fTabFolder != null) {
            CTabItem[] items = this.fTabFolder.getItems();
            int i = items.length - 1;
            while (i >= 0) {
                items[i].dispose();
                --i;
            }
            this.createTabItems(this.fTabFolder);
            this.fTabFolder.setSelection(0);
        }
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.WSDL2EGL_INTERFACE);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, this.nColumns);
        this.createPackageControls(composite);
        this.createEGLFileControls(composite);
        this.createSeparator(composite, this.nColumns);
        this.createTabControls(composite);
        this.createCheckBoxIsRuiControl(composite);
        this.createCheckBoxOverwriteFileControl(composite);
        this.setControl((Control)composite);
        this.getConfiguration().addPropertyChangeListener(this);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    @Override
    protected void handleContainerDialogFieldChanged() {
        super.handleContainerDialogFieldChanged();
        this.updateOtherConfiguration();
    }

    protected void updateOtherConfiguration() {
    }

    protected void createTabControls(Composite parent) {
        GridData gd = new GridData(1808);
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = this.nColumns - 1;
        this.fTabFolder = new CTabFolder(parent, 2176);
        this.fTabFolder.setLayout((Layout)new TabFolderLayout());
        this.fTabFolder.setLayoutData((Object)gd);
        this.fTabFolder.setSimple(false);
        this.createTabItems(this.fTabFolder);
        this.fTabFolder.setSelection(0);
    }

    protected void createTabItems(CTabFolder tabfolder) {
    }

    protected void createTabItem(CTabFolder tabfolder, int i, String interfaceName, String tabItemName, ILabelProvider funcListLabelProvider) {
        CTabItem tabitem = new CTabItem(tabfolder, 0);
        tabitem.setText(tabItemName);
        tabitem.setImage(PluginImages.DESC_OBJS_INTERFACE.createImage());
        if (this.tabControls[i] == null) {
            this.tabControls[i] = new Composite((Composite)tabfolder, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.numColumns = this.nColumns;
            this.tabControls[i].setLayout((Layout)layout);
            this.createInterfaceEGLNameControls(this.tabControls[i], interfaceName, i);
            this.createFunctionListControls(this.tabControls[i], funcListLabelProvider, i);
        }
        tabitem.setControl((Control)this.tabControls[i]);
    }

    protected void createInterfaceEGLNameControls(Composite parent, String strText, int indexInWSDLConfig) {
        this.createInterfaceEGLNameControls(parent, NewWizardMessages.NewEGLWSDLInterfaceWizardPagePartlabel, strText, indexInWSDLConfig);
    }

    protected void createInterfaceEGLNameControls(Composite parent, String strLabelText, String strText, int indexInWSDLConfig) {
        this.fInterfaceDialogField = new StringDialogField();
        this.fieldcontrol2InterfaceIndex.put(this.fInterfaceDialogField, new Integer(indexInWSDLConfig));
        this.fInterfaceDialogField.setDialogFieldListener(this.adapter);
        this.fInterfaceDialogField.setLabelText(strLabelText);
        this.fInterfaceDialogField.setText(strText);
        this.fInterfaceDialogField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fInterfaceDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fInterfaceDialogField.getTextControl(null));
    }

    protected void createCheckBoxIsRuiControl(Composite parent) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = this.nColumns - 1;
        this.bis4RuiCheckBox = new Button(parent, 32);
        this.bis4RuiCheckBox.setLayoutData((Object)gd);
        this.bis4RuiCheckBox.setText(NewWizardMessages.NewEGLWSDLInterfaceWizardPageIs4RUILabel);
        this.bis4RuiCheckBox.addSelectionListener(new SelectionListener(){

            private void setIs4RuiSelection(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    Button cfr_ignored_0 = (Button)e.getSource();
                    WSDLWizardPage.this.validatePage();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.setIs4RuiSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.setIs4RuiSelection(e);
            }
        });
    }

    protected void handleInterfaceNameDialogFieldChanged(int indexInWSDLConfig, StringDialogField field) {
        this.validatePage();
    }

    @Override
    protected boolean validatePage() {
        this.fInterfaceNameStatus.setOK();
        this.fFuncSelSatus.setOK();
        if (super.validatePage()) {
            this.getFileConfiguration();
            this.updateStatus(new IStatus[]{this.fInterfaceNameStatus, this.fFuncSelSatus});
        }
        return true;
    }

    protected Composite createFunctionListControls(Composite parent, ILabelProvider labelProvider, int indexInWSDLConfig) {
        String[] buttonLabels = new String[]{NewWizardMessages.BuildPathsBlockClasspathCheckallButton, NewWizardMessages.BuildPathsBlockClasspathUncheckallButton};
        this.fFunctionListField = new CheckedListDialogField(null, buttonLabels, labelProvider);
        this.fieldcontrol2InterfaceIndex.put(this.fFunctionListField, new Integer(indexInWSDLConfig));
        this.fFunctionListField.setLabelText(NewWizardMessages.NewEGLWSDLInterfaceWizardPageFunctionsLabel);
        this.fFunctionListField.setCheckAllButtonIndex(0);
        this.fFunctionListField.setUncheckAllButtonIndex(1);
        this.fFunctionListField.doFillIntoGrid(parent, this.nColumns);
        GridData gd = (GridData)this.fFunctionListField.getListControl(null).getLayoutData();
        gd.heightHint = this.convertHeightInCharsToPixels(6);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
        this.populateFuncList(indexInWSDLConfig, this.fFunctionListField);
        this.fFunctionListField.setDialogFieldListener(this.adapter);
        return parent;
    }

    private InterfaceConfiguration getInterfaceConfiguration(int indexInWSDLConfig) {
        return null;
    }

    protected void populateFuncList(int indexInWSDLConfig, CheckedListDialogField funcListField) {
    }

    protected void handleFunctionListFieldChanged(int indexInWSDLConfig, CheckedListDialogField funcListField) {
        this.validatePage();
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getPropertyName().equals("EGLFileConfiguration.Overwrite")) {
            this.validatePage();
        }
    }

    protected class FunctionsListLabelProvider
    extends LabelProvider {
        protected FunctionsListLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return element == null ? "" : element.toString();
        }
    }

    private class InterfaceFieldAdapter
    implements IDialogFieldListener {
        private InterfaceFieldAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            Integer InterfaceIndexInWSDL = (Integer)WSDLWizardPage.this.fieldcontrol2InterfaceIndex.get(field);
            if (field instanceof StringDialogField) {
                WSDLWizardPage.this.handleInterfaceNameDialogFieldChanged(InterfaceIndexInWSDL, (StringDialogField)field);
            } else if (field instanceof CheckedListDialogField) {
                WSDLWizardPage.this.handleFunctionListFieldChanged(InterfaceIndexInWSDL, (CheckedListDialogField)field);
            }
        }
    }
}

