/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.search;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.search.IEGLSearchResultCollector;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.dialogs.OptionalMessageDialog;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchMessages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.widgets.Shell;

public class EGLSearchResultCollector
implements IEGLSearchResultCollector {
    private static final String MATCH = EGLSearchMessages.SearchResultCollectorMatch;
    private static final String MATCHES = EGLSearchMessages.SearchResultCollectorMatches;
    private static final String DONE = EGLSearchMessages.SearchResultCollectorDone;
    private static final Boolean POTENTIAL_MATCH_VALUE = new Boolean(true);
    private static final String POTENTIAL_MATCH_DIALOG_ID = "Search.PotentialMatchDialog";
    private IProgressMonitor fMonitor;
    private ISearchResultView fView;
    private int fMatchCount = 0;
    private int fPotentialMatchCount = 0;
    private long fLastUpdateTime;
    private Integer[] fMessageFormatArgs = new Integer[1];

    public EGLSearchResultCollector() {
        EDTUIPlugin.getDefault().getImageRegistry();
    }

    public void aboutToStart() {
    }

    public void accept(IResource resource, int start, int end, IEGLElement enclosingElement, int accuracy) throws CoreException {
        if (accuracy == 1 && SearchUI.arePotentialMatchesIgnored()) {
            return;
        }
    }

    public void done() {
        if (!this.getProgressMonitor().isCanceled()) {
            String matchesString = this.getFormattedMatchesString(this.fMatchCount);
            this.getProgressMonitor().setTaskName(MessageFormat.format(DONE, matchesString));
        }
        if (this.fView != null) {
            if (this.fPotentialMatchCount > 0) {
                this.explainPotentialMatch(this.fPotentialMatchCount);
            }
            this.fView.searchFinished();
        }
        this.fView = null;
        this.fMonitor = null;
    }

    private void explainPotentialMatch(int potentialMatchCount) {
        final Shell shell = this.fView.getSite().getShell();
        final String title = potentialMatchCount == 1 ? new String(EGLSearchMessages.SearchPotentialMatchDialogTitleFoundPotentialMatch) : new String(EGLSearchMessages.bind((String)EGLSearchMessages.SearchPotentialMatchDialogTitleFoundPotentialMatch, (Object)("" + potentialMatchCount)));
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                OptionalMessageDialog.open(EGLSearchResultCollector.POTENTIAL_MATCH_DIALOG_ID, shell, title, null, EGLSearchMessages.SearchPotentialMatchDialogMessage, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            }
        });
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    void setProgressMonitor(IProgressMonitor pm) {
        this.fMonitor = pm;
    }

    private String getFormattedMatchesString(int count) {
        if (this.fMatchCount == 1) {
            return MATCH;
        }
        this.fMessageFormatArgs[0] = new Integer(count);
        return MessageFormat.format(MATCHES, this.fMessageFormatArgs);
    }

    public void accept(IEGLElement element, int start, int end, IResource resource, int accuracy) throws CoreException {
    }
}

