/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.results.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractResultsListViewerAction
extends SelectionListenerAction {
    private int type = 0;
    private ViewPart viewPart = null;
    private Clipboard clipboard = null;
    public static final int SELECT_ALL = 1;
    public static final int DESELECT_ALL = 2;
    public static final int COPY = 3;

    protected AbstractResultsListViewerAction(String text) {
        super(text);
    }

    public AbstractResultsListViewerAction(String text, ViewPart viewPart, int type) {
        this(text);
        this.type = type;
        this.viewPart = viewPart;
        this.clipboard = new Clipboard(Display.getCurrent());
    }

    public Object getInput() {
        return this.getCurrentViewer().getInput();
    }

    public void run() {
        if (this.getCurrentViewer() == null) {
            return;
        }
        switch (this.type) {
            case 1: {
                this.getCurrentViewer().setSelection((ISelection)new StructuredSelection((List)this.getInput()), true);
                break;
            }
            case 2: {
                this.getCurrentViewer().setSelection((ISelection)new StructuredSelection(new ArrayList()), true);
                break;
            }
            case 3: {
                this.copyToClipboard();
                break;
            }
        }
    }

    public void copyToClipboard() {
        String[] selection = this.getCurrentViewer().getList().getSelection();
        if (selection.length == 0) {
            return;
        }
        Object[] data = new Object[]{this.stringFromArray(selection)};
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        this.clipboard.setContents(data, transferTypes);
    }

    public String stringFromArray(String[] strings) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            buffer.append(strings[i]);
            if (i < strings.length - 1) {
                buffer.append("\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return !selection.isEmpty();
    }

    public abstract ListViewer getCurrentViewer();

    public ViewPart getViewPart() {
        return this.viewPart;
    }
}

