/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.internal.model.util.EGLModelUtil;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IOpenable;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;

public class ReorgUtils {
    private ReorgUtils() {
    }

    public static IResource[] getResources(List elements) {
        ArrayList resources = new ArrayList(elements.size());
        for (Object element : elements) {
            if (!(element instanceof IResource)) continue;
            resources.add(element);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static IResource[] getResources(IEGLElement[] elements) {
        IResource[] result = new IResource[elements.length];
        int i = 0;
        while (i < elements.length) {
            result[i] = ReorgUtils.getResource(elements[i]);
            ++i;
        }
        return result;
    }

    public static IResource[] getNotNulls(IResource[] resources) {
        ArrayList<IResource> result = new ArrayList<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && !result.contains(resource)) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static IResource[] setMinus(IResource[] setToRemoveFrom, IResource[] elementsToRemove) {
        HashSet<IResource> setMinus = new HashSet<IResource>(setToRemoveFrom.length - setToRemoveFrom.length);
        setMinus.addAll(Arrays.asList(setToRemoveFrom));
        setMinus.removeAll(Arrays.asList(elementsToRemove));
        return setMinus.toArray(new IResource[setMinus.size()]);
    }

    public static IEGLElement[] setMinus(IEGLElement[] setToRemoveFrom, IEGLElement[] elementsToRemove) {
        HashSet<IEGLElement> setMinus = new HashSet<IEGLElement>(setToRemoveFrom.length - setToRemoveFrom.length);
        setMinus.addAll(Arrays.asList(setToRemoveFrom));
        setMinus.removeAll(Arrays.asList(elementsToRemove));
        return setMinus.toArray(new IEGLElement[setMinus.size()]);
    }

    public static boolean isArchiveMember(IEGLElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            IEGLElement element = elements[i];
            IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
            if (root != null && root.isArchive()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsNotOfType(IResource[] resources, int typeMask) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && !ReorgUtils.isOfType(resource, typeMask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsNotOfType(IEGLElement[] eglElements, int type) {
        int i = 0;
        while (i < eglElements.length) {
            IEGLElement element = eglElements[i];
            if (element != null && !ReorgUtils.isOfType(element, type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IEGLElement[] eglElements, int type) {
        int i = 0;
        while (i < eglElements.length) {
            IEGLElement element = eglElements[i];
            if (element != null && ReorgUtils.isOfType(element, type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IEGLElement[] eglElements, int[] types) {
        int i = 0;
        while (i < types.length) {
            if (ReorgUtils.hasElementsOfType(eglElements, types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IResource[] resources, int typeMask) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && ReorgUtils.isOfType(resource, typeMask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isOfType(IEGLElement element, int type) {
        return element.getElementType() == type;
    }

    private static boolean isOfType(IResource resource, int type) {
        return resource != null && ReorgUtils.isFlagSet(resource.getType(), type);
    }

    private static boolean isFlagSet(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static IFolder[] getFolders(IResource[] resources) {
        Set result = ReorgUtils.getResourcesOfType(resources, 2);
        return result.toArray(new IFolder[result.size()]);
    }

    public static IFile[] getFiles(IResource[] resources) {
        Set result = ReorgUtils.getResourcesOfType(resources, 1);
        return result.toArray(new IFile[result.size()]);
    }

    public static IFile[] getFiles(IEGLFile[] cus) {
        ArrayList<IResource> files = new ArrayList<IResource>(cus.length);
        int i = 0;
        while (i < cus.length) {
            IResource resource = ReorgUtils.getResource(cus[i]);
            if (resource != null && resource.getType() == 1) {
                files.add(resource);
            }
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public static Set getResourcesOfType(IResource[] resources, int typeMask) {
        HashSet<IResource> result = new HashSet<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            if (ReorgUtils.isOfType(resources[i], typeMask)) {
                result.add(resources[i]);
            }
            ++i;
        }
        return result;
    }

    public static boolean isInsideEGLFile(IEGLElement element) {
        return !(element instanceof IEGLFile) && ReorgUtils.hasAncestorOfType(element, 6);
    }

    public static boolean isInsideIRFile(IEGLElement element) {
        return false;
    }

    public static boolean hasAncestorOfType(IEGLElement element, int type) {
        return element.getAncestor(type) != null;
    }

    public static IEGLFile getEGLFile(IEGLElement eglElement) {
        if (eglElement instanceof IEGLFile) {
            return (IEGLFile)eglElement;
        }
        return (IEGLFile)eglElement.getAncestor(6);
    }

    public static IEGLFile[] getEGLFiles(IEGLElement[] eglElements) {
        IEGLFile[] result = new IEGLFile[eglElements.length];
        int i = 0;
        while (i < eglElements.length) {
            result[i] = ReorgUtils.getEGLFile(eglElements[i]);
            ++i;
        }
        return result;
    }

    public static boolean isDeletedFromEditor(IEGLElement elem) throws EGLModelException {
        if (!ReorgUtils.isInsideEGLFile(elem)) {
            return false;
        }
        IEGLFile cu = ReorgUtils.getEGLFile(elem);
        if (cu == null) {
            return false;
        }
        IEGLFile wc = cu;
        if (cu.equals(wc)) {
            return false;
        }
        IEGLElement wcElement = EGLModelUtil.findInEGLFile((IEGLFile)wc, (IEGLElement)elem);
        return wcElement == null || !wcElement.exists();
    }

    public static boolean canBeDestinationForLinkedResources(IResource resource) {
        return resource.isAccessible() && resource instanceof IProject;
    }

    public static boolean canBeDestinationForLinkedResources(IEGLElement eglElement) {
        if (eglElement instanceof IPackageFragmentRoot) {
            return ReorgUtils.isPackageFragmentRootCorrespondingToProject((IPackageFragmentRoot)eglElement);
        }
        return eglElement instanceof IEGLProject;
    }

    private static boolean isPackageFragmentRootCorrespondingToProject(IPackageFragmentRoot root) {
        return root.getResource() instanceof IProject;
    }

    public static IPackageFragmentRoot getCorrespondingPackageFragmentRoot(IEGLProject p) throws EGLModelException {
        IPackageFragmentRoot[] roots = p.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (ReorgUtils.isPackageFragmentRootCorrespondingToProject(roots[i])) {
                return roots[i];
            }
            ++i;
        }
        return null;
    }

    public static IEGLElement[] union(IEGLElement[] set1, IEGLElement[] set2) {
        ArrayList union = new ArrayList(set1.length + set2.length);
        ReorgUtils.addAll(set1, union);
        ReorgUtils.addAll(set2, union);
        return union.toArray(new IEGLElement[union.size()]);
    }

    public static IResource[] union(IResource[] set1, IResource[] set2) {
        ArrayList union = new ArrayList(set1.length + set2.length);
        ReorgUtils.addAll(ReorgUtils.getNotNulls(set1), union);
        ReorgUtils.addAll(ReorgUtils.getNotNulls(set2), union);
        return union.toArray(new IResource[union.size()]);
    }

    private static void addAll(Object[] array, List list) {
        int i = 0;
        while (i < array.length) {
            if (!list.contains(array[i])) {
                list.add(array[i]);
            }
            ++i;
        }
    }

    public static Set union(Set set1, Set set2) {
        HashSet union = new HashSet(set1.size() + set2.size());
        union.addAll(set1);
        union.addAll(set2);
        return union;
    }

    public static boolean containsLinkedResources(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] != null && resources[i].isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsLinkedResources(IEGLElement[] eglElements) {
        int i = 0;
        while (i < eglElements.length) {
            IResource res = ReorgUtils.getResource(eglElements[i]);
            if (res != null && res.isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IResource getResource(Object o) {
        if (o instanceof IResource) {
            return (IResource)o;
        }
        if (o instanceof IEGLElement) {
            return ReorgUtils.getResource((IEGLElement)o);
        }
        return null;
    }

    private static IResource getResource(IEGLElement element) {
        if (element.getElementType() == 6) {
            return ReorgUtils.getResource((IEGLFile)element);
        }
        if (element instanceof IOpenable) {
            return element.getResource();
        }
        return null;
    }

    public static IResource getResource(IEGLFile cu) {
        return cu.getResource();
    }

    public static boolean isDefaultPackage(Object element) {
        return element instanceof IPackageFragment && ((IPackageFragment)element).isDefaultPackage();
    }

    public static String getLineDelimiterUsed(IEGLProject project) {
        return ReorgUtils.getProjectLineDelimiter(project);
    }

    private static String getProjectLineDelimiter(IEGLProject eglProject) {
        String lineDelimiter;
        IProject project = null;
        if (eglProject != null) {
            project = eglProject.getProject();
        }
        if ((lineDelimiter = ReorgUtils.getLineDelimiterPreference(project)) != null) {
            return lineDelimiter;
        }
        return System.getProperty("line.separator", "\n");
    }

    public static String getLineDelimiterPreference(IProject project) {
        IScopeContext[] scopeContext;
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project)};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        String platformDefault = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefault, scopeContext);
    }

    public static String getLineDelimiterUsed(IEGLElement elem) {
        return ReorgUtils.getProjectLineDelimiter(elem.getEGLProject());
    }

    public static IPart getMainPart(IEGLFile cu) throws EGLModelException {
        IPart[] types = cu.getParts();
        int i = 0;
        while (i < types.length) {
            if (ReorgUtils.isMainType(types[i], cu.getElementName())) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    private static boolean isMainType(IPart part, String eglFileName) {
        return part instanceof SourcePart && ((SourcePart)part).isGeneratable() && part.getElementName().equals(eglFileName);
    }

    public static boolean isReadOnly(IResource resource) {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes == null) {
            return false;
        }
        return resourceAttributes.isReadOnly();
    }

    public static boolean isParentInWorkspaceOrOnDisk(IPackageFragment pack, IPackageFragmentRoot root) {
        if (pack == null) {
            return false;
        }
        IEGLElement packParent = pack.getParent();
        if (packParent == null) {
            return false;
        }
        if (packParent.equals(root)) {
            return true;
        }
        IResource packageResource = ReorgUtils.getResource((IEGLElement)pack);
        IResource packageRootResource = ReorgUtils.getResource((IEGLElement)root);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(packageResource, packageRootResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IPackageFragmentRoot root, IEGLProject eglProject) {
        if (root == null) {
            return false;
        }
        IEGLElement rootParent = root.getParent();
        if (rootParent == null) {
            return false;
        }
        if (rootParent.equals(root)) {
            return true;
        }
        IResource packageResource = ReorgUtils.getResource((IEGLElement)root);
        IResource packageRootResource = ReorgUtils.getResource((IEGLElement)eglProject);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(packageResource, packageRootResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IEGLFile cu, IPackageFragment dest) {
        if (cu == null) {
            return false;
        }
        IEGLElement cuParent = cu.getParent();
        if (cuParent == null) {
            return false;
        }
        if (cuParent.equals(dest)) {
            return true;
        }
        IResource cuResource = ResourceUtil.getResource((Object)cu);
        IResource packageResource = ResourceUtil.getResource((Object)dest);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(cuResource, packageResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IResource res, IResource maybeParent) {
        if (res == null) {
            return false;
        }
        return ReorgUtils.areEqualInWorkspaceOrOnDisk((IResource)res.getParent(), maybeParent);
    }

    public static boolean areEqualInWorkspaceOrOnDisk(IResource r1, IResource r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.equals((Object)r2)) {
            return true;
        }
        URI r1Location = r1.getLocationURI();
        URI r2Location = r2.getLocationURI();
        if (r1Location == null || r2Location == null) {
            return false;
        }
        return r1Location.equals(r2Location);
    }
}

