/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.edt.ide.ui.internal.util.PixelConverter;
import org.eclipse.edt.ide.ui.internal.wizards.EGLFileWizard;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPackageWizard;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWizard;

public class CreateTargetQueries
implements ICreateTargetQueries {
    private final Wizard fWizard;
    private final Shell fShell;

    public CreateTargetQueries(Wizard wizard) {
        this.fWizard = wizard;
        this.fShell = null;
    }

    public CreateTargetQueries(Shell shell) {
        this.fShell = shell;
        this.fWizard = null;
    }

    private Shell getShell() {
        Assert.isTrue((this.fWizard == null || this.fShell == null ? 1 : 0) != 0);
        if (this.fWizard != null) {
            return this.fWizard.getContainer().getShell();
        }
        if (this.fShell != null) {
            return this.fShell;
        }
        return EDTUIPlugin.getActiveWorkbenchShell();
    }

    @Override
    public ICreateTargetQuery createNewPackageQuery() {
        return new ICreateTargetQuery(){

            @Override
            public Object getCreatedTarget(Object selection) {
                EGLPackageWizard packageCreationWizard = new EGLPackageWizard();
                CreateTargetQueries.this.openNewElementWizard((IWorkbenchWizard)packageCreationWizard, CreateTargetQueries.this.getShell(), selection);
                return packageCreationWizard.getNewPackageFragment();
            }

            @Override
            public String getNewButtonLabel() {
                return UINlsStrings.ReorgMoveWizard_newPackage;
            }
        };
    }

    @Override
    public ICreateTargetQuery createNewEGLFileQuery() {
        return new ICreateTargetQuery(){

            @Override
            public Object getCreatedTarget(Object selection) {
                EGLFileWizard fileCreationWizard = new EGLFileWizard(false);
                CreateTargetQueries.this.openNewElementWizard((IWorkbenchWizard)fileCreationWizard, CreateTargetQueries.this.getShell(), selection);
                IFile fileHandle = ((EGLFileConfiguration)fileCreationWizard.getConfiguration()).getFileHandle();
                return fileHandle == null ? null : EGLCore.create((IFile)fileHandle);
            }

            @Override
            public String getNewButtonLabel() {
                return UINlsStrings.ReorgMoveWizard_newEGLFile;
            }
        };
    }

    private IWizardPage[] openNewElementWizard(IWorkbenchWizard wizard, Shell shell, Object selection) {
        wizard.init(EDTUIPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection(selection));
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter((Control)shell);
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        dialog.open();
        IWizardPage[] pages = wizard.getPages();
        return pages;
    }
}

