/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.rename;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchResultCollector;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.Checks;
import org.eclipse.edt.ide.ui.internal.refactoring.RefactoringScopeFactory;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.RenameResourceChange;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.TextChangeCompatibility;
import org.eclipse.edt.ide.ui.internal.refactoring.rename.RenameProcessor;
import org.eclipse.edt.ide.ui.internal.refactoring.tagging.IReferenceUpdating;
import org.eclipse.edt.ide.ui.internal.refactoring.util.TextChangeManager;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenamePartProcessor
extends RenameProcessor
implements IReferenceUpdating {
    private static final GroupCategorySet CATEGORY_PART_RENAME = new GroupCategorySet(new GroupCategory("com.ibm.etools.egl.internal.ui..refactoring.rename.renamePart.part", UINlsStrings.RenamePartProcessor_changeCategory_type, UINlsStrings.RenamePartProcessor_changeCategory_type_description));
    private IPart part;
    private boolean fUpdateReferences;
    private List fReferences;
    private boolean willUpdateEGLFileName;
    private TextChangeManager fChangeManager;

    public RenamePartProcessor(IPart part) {
        this.part = part;
        this.willUpdateEGLFileName = part instanceof SourcePart && ((SourcePart)part).isGeneratable();
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        int referenceSearchTicks = this.fUpdateReferences ? 15 : 0;
        int createChangeTicks = 5;
        try {
            pm.beginTask("", 12 + referenceSearchTicks + createChangeTicks);
            pm.setTaskName(UINlsStrings.RefactoringProcessor_precondition_checking);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fChangeManager = new TextChangeManager(true);
            result.merge(this.checkTypesInPackage());
            pm.worked(1);
            result.merge(this.checkRenameMainFunction());
            pm.worked(1);
            if (this.willUpdateEGLFileName) {
                result.merge(Checks.checkFileNewName(this.part.getEGLFile(), this.getNewElementName()));
                pm.worked(1);
            }
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.fUpdateReferences) {
                pm.setTaskName(UINlsStrings.RefactoringProcessor_searching_references);
                result.merge(this.initializeReferences((IProgressMonitor)new SubProgressMonitor(pm, referenceSearchTicks)));
            } else {
                this.fReferences = Collections.EMPTY_LIST;
            }
            this.createChanges((IProgressMonitor)new SubProgressMonitor(pm, createChangeTicks));
        }
        finally {
            pm.done();
        }
        return result;
    }

    public RefactoringStatus initializeReferences(final IProgressMonitor monitor) throws EGLModelException {
        RefactoringStatus result = new RefactoringStatus();
        this.fReferences = new ArrayList();
        IPackageFragment packageFragment = (IPackageFragment)this.part.getAncestor(4);
        String searchString = packageFragment.isDefaultPackage() ? this.part.getElementName() : new String(CharOperation.concat((char[])packageFragment.getElementName().toCharArray(), (char[])this.part.getElementName().toCharArray(), (char)'.'));
        new SearchEngine().search(ResourcesPlugin.getWorkspace(), SearchEngine.createSearchPattern((String)searchString, (int)this.getSearchFor(this.part), (int)1, (boolean)false), RefactoringScopeFactory.create((IEGLElement)this.part), true, true, new IEGLSearchResultCollector(){

            public void aboutToStart() {
            }

            public void accept(IResource resource, int start, int end, IEGLElement enclosingElement, int accuracy) throws CoreException {
                if (accuracy == 0) {
                    RenamePartProcessor.this.fReferences.add(new Object[]{resource, new Integer(start), new Integer(end), enclosingElement, new Integer(accuracy)});
                }
            }

            public void done() {
            }

            public IProgressMonitor getProgressMonitor() {
                return monitor;
            }

            public void accept(IEGLElement element, int start, int end, IResource resource, int accuracy) throws CoreException {
            }
        });
        return result;
    }

    private int getSearchFor(IPart part) {
        int result = 0;
        if (part instanceof SourcePart) {
            SourcePart sPart = (SourcePart)part;
            if (sPart.isDelegate()) {
                result = 15;
            } else if (sPart.isExternalType()) {
                result = 16;
            } else if (sPart.isHandler()) {
                result = 12;
            } else if (sPart.isInterface()) {
                result = 14;
            } else if (sPart.isLibrary()) {
                result = 9;
            } else if (sPart.isProgram()) {
                result = 1;
            } else if (sPart.isRecord()) {
                result = 4;
            } else if (sPart.isService()) {
                result = 13;
            } else if (sPart.isEnumeration()) {
                result = 17;
            } else if (sPart.isClass()) {
                result = 20;
            } else if (sPart.isFunction()) {
                result = 10;
            }
        }
        return result;
    }

    private void createChanges(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 3);
            pm.setTaskName(UINlsStrings.RefactoringProcessor_creating_changes);
            if (this.fUpdateReferences) {
                this.addReferenceUpdates(this.fChangeManager, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            }
            pm.worked(1);
            this.addPartDeclarationUpdate(this.fChangeManager);
            pm.worked(1);
        }
        finally {
            pm.done();
        }
    }

    private void addRenameEGLFileUpdate(CompositeChange compositeChange) {
        if (this.willUpdateEGLFileName) {
            IEGLFile file = this.part.getEGLFile();
            String filename = file.getElementName();
            String ext = null;
            int lastIndexOfDot = filename.lastIndexOf(46);
            if (lastIndexOfDot != -1) {
                ext = filename.substring(lastIndexOfDot + 1);
                filename = filename.substring(0, lastIndexOfDot);
            }
            if (filename.equals(this.part.getElementName())) {
                StringBuffer newFilename = new StringBuffer(this.getNewElementName());
                if (ext != null) {
                    newFilename.append('.');
                    newFilename.append(ext);
                }
                compositeChange.add((Change)new RenameResourceChange(null, file.getResource(), newFilename.toString(), null));
            }
        }
    }

    private void addPartDeclarationUpdate(TextChangeManager manager) throws EGLModelException {
        String name = UINlsStrings.RenamePartRefactoring_update;
        int partNameLength = this.part.getElementName().length();
        IFile cfr_ignored_0 = (IFile)this.part.getResource();
        TextChangeCompatibility.addTextEdit(manager.get(this.part.getEGLFile()), name, (TextEdit)new ReplaceEdit(this.part.getNameRange().getOffset(), partNameLength, this.getNewElementName()));
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) {
        pm.beginTask("", this.fReferences.size());
        String name = UINlsStrings.RenamePartRefactoring_update_reference;
        for (Object[] nextRef : this.fReferences) {
            if (nextRef[0] instanceof IFile) {
                int start = (Integer)nextRef[1];
                int end = (Integer)nextRef[2];
                IEGLElement enclosingElement = (IEGLElement)nextRef[3];
                String newElementName = this.getNewElementName();
                start = start + end - start - this.part.getElementName().length();
                TextChangeCompatibility.addTextEdit(manager.get(this.getEGLFile(enclosingElement)), name, (TextEdit)new ReplaceEdit(start, this.part.getElementName().length(), newElementName), CATEGORY_PART_RENAME);
            }
            pm.worked(1);
        }
    }

    private IEGLFile getEGLFile(IEGLElement element) {
        while (!(element instanceof IEGLFile)) {
            element = element.getParent();
        }
        return (IEGLFile)element;
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return new String[]{"com.ibm.etools.egl.model.eglnature"};
    }

    @Override
    protected IFile[] getChangedFiles() throws CoreException {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(this.toFiles(this.fChangeManager.getAllCompilationUnits())));
        if (this.willUpdateEGLFileName) {
            result.add((IFile)this.part.getEGLFile().getResource());
        }
        return result.toArray(new IFile[result.size()]);
    }

    private Object[] toFiles(IEGLFile[] allCompilationUnits) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        int i = 0;
        while (i < allCompilationUnits.length) {
            result.add((IFile)allCompilationUnits[i].getResource());
            ++i;
        }
        return result.toArray(new IFile[result.size()]);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            CompositeChange result = new CompositeChange(UINlsStrings.RenamePartProcessor_change_name);
            monitor.beginTask(UINlsStrings.RenamePartRefactoring_creating_change, 4);
            result.addAll((Change[])this.fChangeManager.getAllChanges());
            if (this.willUpdateEGLFileName) {
                this.addRenameEGLFileUpdate(result);
            }
            monitor.worked(1);
            CompositeChange compositeChange = result;
            return compositeChange;
        }
        finally {
            this.fChangeManager = null;
        }
    }

    public Object[] getElements() {
        return null;
    }

    public String getIdentifier() {
        return this.getClass().getName();
    }

    public String getProcessorName() {
        return UINlsStrings.RenamePartRefactoring_name;
    }

    public boolean isApplicable() throws CoreException {
        return false;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.part, (RenameArguments)new RenameArguments(this.getNewElementName(), this.getUpdateReferences()), (String[])this.getAffectedProjectNatures(), (SharableParticipants)shared);
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        final RefactoringStatus[] result = new RefactoringStatus[]{new RefactoringStatus()};
        EGLNameValidator.validate((String)newName, (int)1, (IProblemRequestor)new DefaultProblemRequestor(){

            public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts, ResourceBundle bundle) {
                if (result[0].isOK()) {
                    result[0] = RefactoringStatus.createFatalErrorStatus((String)2.getMessageFromBundle((int)problemKind, (String[])inserts, (ResourceBundle)bundle));
                }
            }
        }, (ICompilerOptions)DefaultCompilerOptions.getInstance());
        return result[0];
    }

    @Override
    public String getCurrentElementName() {
        return this.part.getElementName();
    }

    @Override
    public boolean canEnableUpdateReferences() {
        return true;
    }

    @Override
    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    @Override
    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    private RefactoringStatus checkTypesInPackage() throws CoreException {
        IPart existingPart = RenamePartProcessor.findPartInPackage(this.part.getPackageFragment(), this.getNewElementName());
        if (existingPart == null || !existingPart.exists()) {
            return null;
        }
        String msg = MessageFormat.format((String)UINlsStrings.RenamePartRefactoring_exists, (Object[])new String[]{this.getNewElementName(), this.part.getPackageFragment().getElementName()});
        return RefactoringStatus.createErrorStatus((String)msg);
    }

    private RefactoringStatus checkRenameMainFunction() throws CoreException {
        IEGLElement parent = this.part.getParent();
        if (10 == this.part.getElementType() && "main".equalsIgnoreCase(this.part.getElementName()) && parent instanceof SourcePart && ((SourcePart)parent).isProgram()) {
            String msg = MessageFormat.format((String)UINlsStrings.RenamePartRefactoring_rename_main_function, (Object[])new String[]{parent.getElementName()});
            return RefactoringStatus.createErrorStatus((String)msg);
        }
        return null;
    }

    public static IPart findPartInPackage(IPackageFragment pack, String name) throws EGLModelException {
        Assert.isTrue((boolean)pack.exists());
        Assert.isTrue((!pack.isReadOnly() ? 1 : 0) != 0);
        if (name.indexOf(".") != -1) {
            name = name.substring(0, name.indexOf("."));
        }
        IEGLFile[] cus = pack.getEGLFiles();
        int i = 0;
        while (i < cus.length) {
            if (cus[i].getPart(name).exists()) {
                return cus[i].getPart(name);
            }
            ++i;
        }
        return null;
    }
}

