/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.changes;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.EGLFileReorgChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class MoveEGLFileChange
extends EGLFileReorgChange {
    private boolean fUndoable;
    private long fStampToRestore;

    public MoveEGLFileChange(IEGLFile cu, IPackageFragment newPackage) {
        super(cu, newPackage);
        this.fStampToRestore = -1L;
    }

    private MoveEGLFileChange(IPackageFragment oldPackage, String cuName, IPackageFragment newPackage, long stampToRestore) {
        super(oldPackage.getHandleIdentifier(), newPackage.getHandleIdentifier(), oldPackage.getEGLFile(cuName).getHandleIdentifier());
        this.fStampToRestore = stampToRestore;
    }

    public String getName() {
        return MessageFormat.format((String)UINlsStrings.MoveEGLFileChange_name, (Object[])new String[]{this.getCu().getElementName(), MoveEGLFileChange.getPackageName(this.getDestinationPackage())});
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    @Override
    Change doPerformReorg(IProgressMonitor pm) throws CoreException {
        IEGLFile moved;
        IResource movedResource;
        String newName = this.getNewName();
        String name = newName == null ? this.getCu().getElementName() : newName;
        long currentStamp = -1L;
        IResource resource = this.getCu().getResource();
        if (resource != null) {
            currentStamp = resource.getModificationStamp();
            if (!resource.isSynchronized(2)) {
                resource.refreshLocal(2, pm);
            }
        }
        this.fUndoable = !this.getDestinationPackage().getEGLFile(name).exists();
        IResource file = this.getCu().getResource();
        if (!this.fUndoable) {
            this.getDestinationPackage().getEGLFile(name).getResource().delete(true, null);
        }
        file.move(this.getDestinationPackage().getEGLFile(name).getResource().getFullPath(), true, null);
        if (this.fStampToRestore != -1L && (movedResource = (moved = this.getDestinationPackage().getEGLFile(name)).getResource()) != null) {
            movedResource.revertModificationStamp(this.fStampToRestore);
        }
        if (this.fUndoable) {
            return new MoveEGLFileChange(this.getDestinationPackage(), this.getCu().getElementName(), this.getOldPackage(), currentStamp);
        }
        return null;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }
}

