/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.internal.refactoring.RefactoringExecutionHelper;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.EGLCopyProcessor;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.NewNameQueries;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReorgQueries;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.CopyRefactoring;
import org.eclipse.swt.widgets.Shell;

public class ReorgCopyStarter {
    private final EGLCopyProcessor fCopyProcessor;

    private ReorgCopyStarter(EGLCopyProcessor copyProcessor) {
        Assert.isNotNull((Object)copyProcessor);
        this.fCopyProcessor = copyProcessor;
    }

    public static ReorgCopyStarter create(IEGLElement[] eglElements, IResource[] resources, IEGLElement destination) throws EGLModelException {
        Assert.isNotNull((Object)eglElements);
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)destination);
        EGLCopyProcessor copyProcessor = EGLCopyProcessor.create(resources, eglElements);
        if (copyProcessor == null) {
            return null;
        }
        if (!copyProcessor.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgCopyStarter(copyProcessor);
    }

    public static ReorgCopyStarter create(IEGLElement[] eglElements, IResource[] resources, IResource destination) throws EGLModelException {
        Assert.isNotNull((Object)eglElements);
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)destination);
        EGLCopyProcessor copyProcessor = EGLCopyProcessor.create(resources, eglElements);
        if (copyProcessor == null) {
            return null;
        }
        if (!copyProcessor.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgCopyStarter(copyProcessor);
    }

    public void run(Shell parent) throws InterruptedException, InvocationTargetException {
        ProgressMonitorDialog context = new ProgressMonitorDialog(parent);
        this.fCopyProcessor.setNewNameQueries(new NewNameQueries(parent));
        this.fCopyProcessor.setReorgQueries(new ReorgQueries(parent));
        new RefactoringExecutionHelper((Refactoring)new CopyRefactoring((CopyProcessor)this.fCopyProcessor), RefactoringCore.getConditionCheckingFailedSeverity(), false, parent, (IRunnableContext)context).perform(false);
    }
}

