/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring;

import java.util.Arrays;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.Logger;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.editor.EditorUtility;
import org.eclipse.edt.ide.ui.internal.refactoring.ListDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.GlobalBuildAction;

public class RefactoringSaveHelper {
    private boolean fFilesSaved;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveEditors(Shell shell) {
        IEditorPart[] dirtyEditors = EditorUtility.getDirtyEditors();
        if (dirtyEditors.length == 0) {
            return true;
        }
        if (!this.saveAllDirtyEditors(shell, dirtyEditors)) {
            return false;
        }
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = workspace.getDescription();
            boolean autoBuild = description.isAutoBuilding();
            description.setAutoBuilding(false);
            workspace.setDescription(description);
            try {
                if (!EDTUIPlugin.getActiveWorkbenchWindow().getWorkbench().saveAllEditors(false)) {
                    return false;
                }
                this.fFilesSaved = true;
            }
            finally {
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
            }
        }
        catch (CoreException e) {
            Logger.log(RefactoringSaveHelper.class, (String)UINlsStrings.RefactoringStarter_unexpected_exception, (Throwable)e);
            return false;
        }
    }

    public void triggerBuild() {
        if (this.fFilesSaved && ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            new GlobalBuildAction(EDTUIPlugin.getActiveWorkbenchWindow(), 10).run();
        }
    }

    private boolean saveAllDirtyEditors(Shell shell, IEditorPart[] dirtyEditors) {
        ListDialog dialog = new ListDialog(shell);
        dialog.setTitle(UINlsStrings.RefactoringStarter_save_all_resources);
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider(this.createDialogLabelProvider());
        dialog.setMessage(UINlsStrings.RefactoringStarter_must_save);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setInput(Arrays.asList(dirtyEditors));
        return dialog.open() == 0;
    }

    public boolean hasFilesSaved() {
        return this.fFilesSaved;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }
}

