/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.conversion.json;

import eglx.lang.AnyException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.edt.ide.ui.internal.record.conversion.IMessageHandler;
import org.eclipse.edt.ide.ui.internal.record.conversion.PartsUtil;
import org.eclipse.edt.ide.ui.templates.parts.Annotation;
import org.eclipse.edt.ide.ui.templates.parts.ArrayType;
import org.eclipse.edt.ide.ui.templates.parts.DecimalType;
import org.eclipse.edt.ide.ui.templates.parts.Field;
import org.eclipse.edt.ide.ui.templates.parts.Part;
import org.eclipse.edt.ide.ui.templates.parts.Record;
import org.eclipse.edt.ide.ui.templates.parts.RecordType;
import org.eclipse.edt.ide.ui.templates.parts.SimpleType;
import org.eclipse.edt.ide.ui.templates.parts.Type;
import org.eclipse.edt.javart.json.ArrayNode;
import org.eclipse.edt.javart.json.BooleanNode;
import org.eclipse.edt.javart.json.DecimalNode;
import org.eclipse.edt.javart.json.FloatingPointNode;
import org.eclipse.edt.javart.json.IntegerNode;
import org.eclipse.edt.javart.json.JsonVisitor;
import org.eclipse.edt.javart.json.NameValuePairNode;
import org.eclipse.edt.javart.json.NullNode;
import org.eclipse.edt.javart.json.ObjectNode;
import org.eclipse.edt.javart.json.StringNode;
import org.eclipse.edt.javart.json.ValueNode;

public class PartsFromJsonUtil
extends PartsUtil {
    public PartsFromJsonUtil(IMessageHandler msgHandler) {
        super(msgHandler);
    }

    @Override
    public Part[] process(Object node, Record wrapRec) {
        LinkedHashMap<String, Record> map = new LinkedHashMap<String, Record>();
        map.put(wrapRec.getName().toUpperCase().toLowerCase(), wrapRec);
        return this.process((ValueNode)node, wrapRec, map);
    }

    public Part[] process(ValueNode node, Record wrapRec, LinkedHashMap<String, Record> recs) {
        if (node instanceof ObjectNode) {
            return this.process((ObjectNode)node, wrapRec, recs);
        }
        if (node instanceof ArrayNode) {
            return this.process((ArrayNode)node, wrapRec, recs);
        }
        return recs.values().toArray(new Part[recs.values().size()]);
    }

    public Part[] process(ArrayNode node, Record wrapRec, LinkedHashMap<String, Record> recs) {
        HashMap<String, String> fieldNames = new HashMap<String, String>();
        fieldNames.put("array", "array");
        String originalName = "array";
        String fieldName = this.getFieldName(originalName, wrapRec.getName(), fieldNames);
        String jsonName = originalName.equals(fieldName) ? null : originalName;
        Field field = new Field();
        field.setName(fieldName);
        field.setType(this.getType((ValueNode)node, recs, fieldName));
        if (jsonName != null) {
            Annotation annotation = new Annotation();
            annotation.setName("JSONName");
            annotation.setValue("\"" + jsonName + "\"");
            field.addAnnotation(annotation);
        }
        wrapRec.addField(field);
        return recs.values().toArray(new Part[recs.values().size()]);
    }

    public Part[] process(ObjectNode node, Record wrapRec, LinkedHashMap<String, Record> recs) {
        String originalName;
        NameValuePairNode nvNode;
        HashMap<String, String> fieldNames = new HashMap<String, String>();
        int i = 0;
        while (i < node.getPairs().size()) {
            nvNode = (NameValuePairNode)node.getPairs().get(i);
            originalName = nvNode.getName().getJavaValue();
            fieldNames.put(originalName.toLowerCase(), originalName);
            ++i;
        }
        i = 0;
        while (i < node.getPairs().size()) {
            String fieldName;
            nvNode = (NameValuePairNode)node.getPairs().get(i);
            originalName = nvNode.getName().getJavaValue();
            String jsonName = originalName.equals(fieldName = this.getFieldName(originalName, wrapRec.getName(), fieldNames)) ? null : originalName;
            Field field = new Field();
            field.setName(fieldName);
            field.setType(this.getType(nvNode.getValue(), recs, fieldName));
            if (jsonName != null) {
                Annotation annotation = new Annotation();
                annotation.setName("JSONName");
                annotation.setValue("\"" + jsonName + "\"");
                field.addAnnotation(annotation);
            }
            wrapRec.addField(field);
            ++i;
        }
        return recs.values().toArray(new Part[recs.values().size()]);
    }

    private Type getType(ValueNode valNode, final LinkedHashMap<String, Record> recs, final String fieldName) {
        final Type[] type = new Type[1];
        JsonVisitor visitor = new JsonVisitor(){

            public void endVisit(ArrayNode arg0) {
                ArrayType t = new ArrayType();
                t.setElementType(type[0]);
                type[0] = t;
            }

            public void endVisit(NameValuePairNode arg0) {
            }

            public void endVisit(BooleanNode arg0) {
            }

            public void endVisit(DecimalNode arg0) {
            }

            public void endVisit(FloatingPointNode arg0) {
            }

            public void endVisit(IntegerNode arg0) {
            }

            public void endVisit(NullNode arg0) {
            }

            public void endVisit(ObjectNode arg0) {
            }

            public void endVisit(StringNode arg0) {
            }

            public boolean visit(ArrayNode arg0) throws AnyException {
                return true;
            }

            public boolean visit(NameValuePairNode arg0) throws AnyException {
                return false;
            }

            public boolean visit(BooleanNode arg0) throws AnyException {
                SimpleType t = new SimpleType();
                t.setName("boolean");
                type[0] = t;
                return false;
            }

            public boolean visit(DecimalNode arg0) throws AnyException {
                String val = arg0.getStringValue();
                int len = val.length();
                int dec = 0;
                int i = val.indexOf(".");
                if (i >= 0) {
                    dec = --len - i;
                }
                DecimalType t = new DecimalType();
                t.setDecimals(dec);
                t.setLength(len);
                type[0] = t;
                return false;
            }

            public boolean visit(FloatingPointNode arg0) throws AnyException {
                SimpleType t = new SimpleType();
                t.setName("float");
                type[0] = t;
                return false;
            }

            public boolean visit(IntegerNode arg0) throws AnyException {
                SimpleType t = new SimpleType();
                t.setName("int");
                type[0] = t;
                return false;
            }

            public boolean visit(NullNode arg0) throws AnyException {
                SimpleType t = new SimpleType();
                t.setName("string");
                type[0] = t;
                return false;
            }

            public boolean visit(ObjectNode arg0) throws AnyException {
                String typeName = PartsFromJsonUtil.this.getTypeName(fieldName);
                RecordType t = new RecordType();
                t.setName(typeName);
                type[0] = t;
                String fn = typeName.toUpperCase().toLowerCase();
                Record oldrec = (Record)recs.get(fn);
                Record rec = new Record();
                rec.setName(typeName);
                recs.put(fn, rec);
                new PartsFromJsonUtil(PartsFromJsonUtil.this._msgHandler).process(arg0, rec, (LinkedHashMap<String, Record>)recs);
                if (oldrec != null) {
                    PartsFromJsonUtil.this.mergeRecords(oldrec, rec);
                }
                return false;
            }

            public boolean visit(StringNode arg0) throws AnyException {
                SimpleType t = new SimpleType();
                t.setName("string");
                type[0] = t;
                return false;
            }
        };
        valNode.accept(visitor);
        return type[0];
    }
}

