/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.quickfix;

import org.eclipse.edt.ide.core.model.IEGLModelMarker;
import org.eclipse.edt.ide.core.model.IProblem;
import org.eclipse.edt.ide.ui.editor.IProblemLocation;
import org.eclipse.edt.ide.ui.internal.editor.IAnnotation;

public class ProblemLocation
implements IProblemLocation {
    private final int fId;
    private final String[] fArguments;
    private final int fOffset;
    private final int fLength;
    private final boolean fIsError;
    private final String fMarkerType;

    public ProblemLocation(int offset, int length, IAnnotation annotation) {
        this.fId = annotation.getProblemKind();
        String[] arguments = null;
        this.fArguments = arguments != null ? arguments : new String[]{};
        this.fOffset = offset;
        this.fLength = length;
        this.fIsError = "org.eclipse.ui.workbench.texteditor.error".equals(annotation.getType());
        String markerType = annotation.getType();
        this.fMarkerType = markerType != null ? markerType : IEGLModelMarker.TRANSIENT_PROBLEM;
    }

    public ProblemLocation(int offset, int length, int id, String[] arguments, boolean isError, String markerType) {
        this.fId = id;
        this.fArguments = arguments;
        this.fOffset = offset;
        this.fLength = length;
        this.fIsError = isError;
        this.fMarkerType = markerType;
    }

    public ProblemLocation(IProblem problem) {
        this.fId = problem.getID();
        this.fArguments = problem.getArguments();
        this.fOffset = problem.getSourceStart();
        this.fLength = problem.getSourceEnd() - this.fOffset + 1;
        this.fIsError = problem.isError();
        this.fMarkerType = "";
    }

    @Override
    public int getProblemId() {
        return this.fId;
    }

    @Override
    public String[] getProblemArguments() {
        return this.fArguments;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public boolean isError() {
        return this.fIsError;
    }

    @Override
    public String getMarkerType() {
        return this.fMarkerType;
    }
}

