/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.preferences;

import org.eclipse.edt.ide.sql.SQLNlsStrings;
import org.eclipse.edt.ide.sql.SQLPlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class SQLRetrievePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private Button[] caseControlButtons;
    private Button[] underscoreControlButtons;
    private Button[] charTypeControlButtons;
    private Button[] nationalCharControlButtons;
    private Button retrievePrimaryKeys;
    private Button sqlPromptButton;
    private Button[] typeForDateTypesButtons;
    private Button addSqlDataCode;
    public static final String[] NAME_CASE_OPTION_BUTTON_STRINGS = new String[]{SQLNlsStrings.NameCaseOptionDoNotChangeLabel, SQLNlsStrings.NameCaseOptionLowercaseLabel, SQLNlsStrings.NameCaseOptionLowercaseAndCapitalizeLetterAfterUnderscoreLabel};
    public static final String[] NAME_UNDERSCORE_OPTION_BUTTON_STRINGS = new String[]{SQLNlsStrings.NameUnderscoreOptionDoNotChangeLabel, SQLNlsStrings.NameUnderscoreOptionRemoveUndersoresLabel};
    public static final String[] CHARACTER_OPTION_BUTTON_STRINGS = new String[]{SQLNlsStrings.CharacterOptionStringLabel};
    public static final String[] NATIONAL_CHAR_OPTION_BUTTON_STRINGS = new String[]{SQLNlsStrings.NationalCharOptionStringLabel};
    public static final String[] TYPE_FOR_DATE_TYPES_OPTION_BUTTON_STRINGS = new String[]{SQLNlsStrings.DateTypesOptionDefaultLabel, SQLNlsStrings.DateTypesOptionStringLabel};

    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IUIHelpConstants.SQL_RETRIEVE_PREFERENCES_CONTEXT);
        Composite composite = this.createComposite(parent, 1);
        this.createDataItemNameControlOptionsGroup(composite);
        this.createTypeForDateTypesControlOptionsGroup(composite);
        this.retrievePrimaryKeys = new Button(composite, 32);
        this.retrievePrimaryKeys.setText(SQLNlsStrings.RetrievePrimaryKeyLabel);
        this.sqlPromptButton = new Button(composite, 32);
        this.sqlPromptButton.setText(SQLNlsStrings.SQLUserIDAndPasswordLabel);
        this.initializeValues();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void createDataItemCharTypeControlOptionsGroup(Composite parent) {
        Group eglCharControlGroup = this.createGroup(parent, 1);
        eglCharControlGroup.setText(SQLNlsStrings.CharacterControlLabel);
        Composite eglCharControlComposite = this.createComposite((Composite)eglCharControlGroup, 1);
        this.charTypeControlButtons = new Button[CHARACTER_OPTION_BUTTON_STRINGS.length];
        int i = 0;
        while (i < CHARACTER_OPTION_BUTTON_STRINGS.length) {
            this.charTypeControlButtons[i] = new Button(eglCharControlComposite, 16);
            this.charTypeControlButtons[i].setText(CHARACTER_OPTION_BUTTON_STRINGS[i]);
            ++i;
        }
    }

    protected void createDataItemNationalCharControlOptionsGroup(Composite parent) {
        Group nationalCharControlGroup = this.createGroup(parent, 1);
        nationalCharControlGroup.setText(SQLNlsStrings.NationalCharControlLabel);
        Composite nationalCharControlComposite = this.createComposite((Composite)nationalCharControlGroup, 1);
        this.nationalCharControlButtons = new Button[NATIONAL_CHAR_OPTION_BUTTON_STRINGS.length];
        int i = 0;
        while (i < NATIONAL_CHAR_OPTION_BUTTON_STRINGS.length) {
            this.nationalCharControlButtons[i] = new Button(nationalCharControlComposite, 16);
            this.nationalCharControlButtons[i].setText(NATIONAL_CHAR_OPTION_BUTTON_STRINGS[i]);
            ++i;
        }
    }

    protected void createDataItemNameControlOptionsGroup(Composite parent) {
        Group caseControlGroup = this.createGroup(parent, 1);
        caseControlGroup.setText(SQLNlsStrings.NameCaseControlLabel);
        Composite caseControlComposite = this.createComposite((Composite)caseControlGroup, 1);
        this.caseControlButtons = new Button[NAME_CASE_OPTION_BUTTON_STRINGS.length];
        int i = 0;
        while (i < NAME_CASE_OPTION_BUTTON_STRINGS.length) {
            this.caseControlButtons[i] = new Button(caseControlComposite, 16);
            this.caseControlButtons[i].setText(NAME_CASE_OPTION_BUTTON_STRINGS[i]);
            ++i;
        }
        Group underscoreControlGroup = this.createGroup(parent, 1);
        underscoreControlGroup.setText(SQLNlsStrings.NameUnderscoreControlLabel);
        Composite underscoreControlComposite = this.createComposite((Composite)underscoreControlGroup, 1);
        this.underscoreControlButtons = new Button[NAME_UNDERSCORE_OPTION_BUTTON_STRINGS.length];
        int i2 = 0;
        while (i2 < NAME_UNDERSCORE_OPTION_BUTTON_STRINGS.length) {
            this.underscoreControlButtons[i2] = new Button(underscoreControlComposite, 16);
            this.underscoreControlButtons[i2].setText(NAME_UNDERSCORE_OPTION_BUTTON_STRINGS[i2]);
            ++i2;
        }
    }

    protected void createTypeForDateTypesControlOptionsGroup(Composite parent) {
        Group group = this.createGroup(parent, 1);
        group.setText(SQLNlsStrings.DateTypesControlLabel);
        Composite composite = this.createComposite((Composite)group, 1);
        this.typeForDateTypesButtons = new Button[TYPE_FOR_DATE_TYPES_OPTION_BUTTON_STRINGS.length];
        int i = 0;
        while (i < TYPE_FOR_DATE_TYPES_OPTION_BUTTON_STRINGS.length) {
            this.typeForDateTypesButtons[i] = new Button(composite, 16);
            this.typeForDateTypesButtons[i].setText(TYPE_FOR_DATE_TYPES_OPTION_BUTTON_STRINGS[i]);
            ++i;
        }
        Label spacer = new Label(composite, 16384);
        spacer.setText(" ");
        this.addSqlDataCode = new Button(composite, 32);
        this.addSqlDataCode.setText(SQLNlsStrings.AddSqlDataCodeLabel);
        this.typeForDateTypesButtons[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == SQLRetrievePreferencePage.this.typeForDateTypesButtons[0]) {
                    SQLRetrievePreferencePage.this.addSqlDataCode.setEnabled(!SQLRetrievePreferencePage.this.typeForDateTypesButtons[0].getSelection());
                }
            }
        });
    }

    protected Group createGroup(Composite parent, int numColumns) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.horizontalIndent = 0;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    protected boolean determinePageCompletion() {
        this.setErrorMessage(null);
        this.setValid(true);
        return this.isValid();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return SQLPlugin.getPlugin().getPreferenceStore();
    }

    public void handleEvent(Event e) {
        this.determinePageCompletion();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        String option = store.getDefaultString("org.eclipse.edt.ide.sql.charOption");
        option = store.getDefaultString("org.eclipse.edt.ide.sql.nationalCharOption");
        option = store.getDefaultString("org.eclipse.edt.ide.sql.caseOption");
        int i = 0;
        while (i < SQLPlugin.NAME_CASE_OPTION_NON_MNEMONIC_STRINGS.length) {
            if (SQLPlugin.NAME_CASE_OPTION_NON_MNEMONIC_STRINGS[i].equalsIgnoreCase(option)) {
                this.caseControlButtons[i].setSelection(true);
            } else {
                this.caseControlButtons[i].setSelection(false);
            }
            ++i;
        }
        option = store.getDefaultString("org.eclipse.edt.ide.sql.underscoreOption");
        i = 0;
        while (i < SQLPlugin.NAME_UNDERSCORE_OPTION_NON_MNEMONIC_STRINGS.length) {
            if (SQLPlugin.NAME_UNDERSCORE_OPTION_NON_MNEMONIC_STRINGS[i].equalsIgnoreCase(option)) {
                this.underscoreControlButtons[i].setSelection(true);
            } else {
                this.underscoreControlButtons[i].setSelection(false);
            }
            ++i;
        }
        this.retrievePrimaryKeys.setSelection(store.getDefaultBoolean("org.eclipse.edt.ide.sql.retrievePrimaryKeyOption"));
        this.sqlPromptButton.setSelection(store.getDefaultBoolean("org.eclipse.edt.ide.sql.promptOption"));
        this.addSqlDataCode.setSelection(store.getDefaultBoolean("org.eclipse.edt.ide.sql.addSqlDataCodeOption"));
        this.addSqlDataCode.setEnabled(false);
        option = store.getBoolean("org.eclipse.edt.ide.sql.charForDateOption") ? "char" : store.getDefaultString("org.eclipse.edt.ide.sql.textTypeForDateOption");
        i = 0;
        while (i < SQLPlugin.TEXT_TYPE_FOR_DATE_OPTION_NON_MNEMONIC_STRINGS.length) {
            if (SQLPlugin.TEXT_TYPE_FOR_DATE_OPTION_NON_MNEMONIC_STRINGS[i].equalsIgnoreCase(option)) {
                this.typeForDateTypesButtons[i].setSelection(true);
            } else {
                this.typeForDateTypesButtons[i].setSelection(false);
            }
            ++i;
        }
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean selectionSet = false;
        String option = store.getString("org.eclipse.edt.ide.sql.charOption");
        option = store.getString("org.eclipse.edt.ide.sql.nationalCharOption");
        option = store.getString("org.eclipse.edt.ide.sql.caseOption");
        int i = 0;
        while (i < SQLPlugin.NAME_CASE_OPTION_NON_MNEMONIC_STRINGS.length) {
            if (SQLPlugin.NAME_CASE_OPTION_NON_MNEMONIC_STRINGS[i].equalsIgnoreCase(option)) {
                this.caseControlButtons[i].setSelection(true);
            } else {
                this.caseControlButtons[i].setSelection(false);
            }
            ++i;
        }
        option = store.getString("org.eclipse.edt.ide.sql.underscoreOption");
        i = 0;
        while (i < SQLPlugin.NAME_UNDERSCORE_OPTION_NON_MNEMONIC_STRINGS.length) {
            if (SQLPlugin.NAME_UNDERSCORE_OPTION_NON_MNEMONIC_STRINGS[i].equalsIgnoreCase(option)) {
                this.underscoreControlButtons[i].setSelection(true);
                selectionSet = true;
            } else {
                this.underscoreControlButtons[i].setSelection(false);
            }
            ++i;
        }
        if (!selectionSet) {
            this.underscoreControlButtons[0].setSelection(true);
        }
        this.retrievePrimaryKeys.setSelection(store.getBoolean("org.eclipse.edt.ide.sql.retrievePrimaryKeyOption"));
        this.sqlPromptButton.setSelection(store.getBoolean("org.eclipse.edt.ide.sql.promptOption"));
        this.addSqlDataCode.setSelection(store.getBoolean("org.eclipse.edt.ide.sql.addSqlDataCodeOption"));
        option = store.getBoolean("org.eclipse.edt.ide.sql.charForDateOption") ? "char" : (store.contains("org.eclipse.edt.ide.sql.charForDateOption") ? "" : store.getString("org.eclipse.edt.ide.sql.textTypeForDateOption"));
        i = 0;
        while (i < SQLPlugin.TEXT_TYPE_FOR_DATE_OPTION_NON_MNEMONIC_STRINGS.length) {
            if (SQLPlugin.TEXT_TYPE_FOR_DATE_OPTION_NON_MNEMONIC_STRINGS[i].equalsIgnoreCase(option)) {
                this.typeForDateTypesButtons[i].setSelection(true);
            } else {
                this.typeForDateTypesButtons[i].setSelection(false);
            }
            ++i;
        }
        this.addSqlDataCode.setEnabled(!this.typeForDateTypesButtons[0].getSelection());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        if (!this.determinePageCompletion()) {
            return false;
        }
        this.storeValues();
        return true;
    }

    private void storeValues() {
        int i;
        IPreferenceStore store = this.getPreferenceStore();
        if (this.charTypeControlButtons != null) {
            i = 0;
            while (i < this.charTypeControlButtons.length) {
                if (this.charTypeControlButtons[i].getSelection()) {
                    store.setValue("org.eclipse.edt.ide.sql.charOption", SQLPlugin.EGL_CHAR_OPTION_NON_MNEMONIC_STRINGS[i]);
                    break;
                }
                ++i;
            }
        } else {
            store.setValue("org.eclipse.edt.ide.sql.charOption", SQLPlugin.EGL_CHAR_OPTION_NON_MNEMONIC_STRINGS[0]);
        }
        if (this.nationalCharControlButtons != null) {
            i = 0;
            while (i < this.nationalCharControlButtons.length) {
                if (this.nationalCharControlButtons[i].getSelection()) {
                    store.setValue("org.eclipse.edt.ide.sql.nationalCharOption", SQLPlugin.EGL_NATIONAL_CHAR_OPTION_NON_MNEMONIC_STRINGS[i]);
                    break;
                }
                ++i;
            }
        } else {
            store.setValue("org.eclipse.edt.ide.sql.nationalCharOption", SQLPlugin.EGL_NATIONAL_CHAR_OPTION_NON_MNEMONIC_STRINGS[0]);
        }
        i = 0;
        while (i < this.caseControlButtons.length) {
            if (this.caseControlButtons[i].getSelection()) {
                store.setValue("org.eclipse.edt.ide.sql.caseOption", SQLPlugin.NAME_CASE_OPTION_NON_MNEMONIC_STRINGS[i]);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.underscoreControlButtons.length) {
            if (this.underscoreControlButtons[i].getSelection()) {
                store.setValue("org.eclipse.edt.ide.sql.underscoreOption", SQLPlugin.NAME_UNDERSCORE_OPTION_NON_MNEMONIC_STRINGS[i]);
                break;
            }
            ++i;
        }
        store.setValue("org.eclipse.edt.ide.sql.retrievePrimaryKeyOption", this.retrievePrimaryKeys.getSelection());
        store.setValue("org.eclipse.edt.ide.sql.promptOption", this.sqlPromptButton.getSelection());
        store.setValue("org.eclipse.edt.ide.sql.addSqlDataCodeOption", this.addSqlDataCode.getSelection());
        i = 0;
        while (i < this.typeForDateTypesButtons.length) {
            if (this.typeForDateTypesButtons[i].getSelection()) {
                store.setValue("org.eclipse.edt.ide.sql.textTypeForDateOption", SQLPlugin.TEXT_TYPE_FOR_DATE_OPTION_NON_MNEMONIC_STRINGS[i]);
                break;
            }
            ++i;
        }
        store.setValue("org.eclipse.edt.ide.sql.charForDateOption", false);
    }
}

