/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.preferences;

import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.EDTUIPreferenceConstants;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.preferences.AbstractPreferencePage;
import org.eclipse.edt.ide.ui.internal.preferences.Messages;
import org.eclipse.edt.ide.ui.internal.preferences.PreferencesMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ContentAssistPreferencePage
extends AbstractPreferencePage
implements IWorkbenchPreferencePage {
    protected Button autoActivationButton = null;
    protected Text delayTimeTextBox;
    protected ModifyListener modifyListener;

    public ContentAssistPreferencePage() {
        this.setPreferenceStore(EDTUIPlugin.getDefault().getPreferenceStore());
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ContentAssistPreferencePage.this.controlModified(e.widget);
            }
        };
    }

    @Override
    public void init(IWorkbench workbench) {
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        Group contentAssistGroup = ContentAssistPreferencePage.createGroup(composite, 1);
        contentAssistGroup.setText(UINlsStrings.ContentAssistLabel);
        Composite contentAssistComposite = this.createComposite((Composite)contentAssistGroup, 1);
        this.autoActivationButton = ContentAssistPreferencePage.createCheckBox(contentAssistComposite, UINlsStrings.AutoActivationLabel);
        this.autoActivationButton.setSelection(EDTUIPreferenceConstants.getPreferenceStore().getBoolean("content_assist_autoactivation"));
        Composite internalComposite = this.createComposite((Composite)contentAssistGroup, 2);
        Label delayTimeLabel = new Label(internalComposite, 0);
        delayTimeLabel.setText(PreferencesMessages.EGLEditorPreferencePage_autoActivationDelay);
        this.delayTimeTextBox = new Text(internalComposite, 2052);
        GridData data = new GridData();
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        data.widthHint = 20;
        this.delayTimeTextBox.setLayoutData((Object)data);
        this.delayTimeTextBox.setText(String.valueOf(EDTUIPreferenceConstants.getPreferenceStore().getInt("content_assist_autoactivation_delay")));
        this.delayTimeTextBox.setTextLimit(3);
        this.delayTimeTextBox.addModifyListener(this.modifyListener);
        this.setSize(composite);
        return parent;
    }

    @Override
    protected void performDefaults() {
        this.autoActivationButton.setSelection(this.getPreferenceStore().getDefaultBoolean("content_assist_autoactivation"));
        this.delayTimeTextBox.setText(String.valueOf(this.getPreferenceStore().getDefaultInt("content_assist_autoactivation_delay")));
        super.performDefaults();
    }

    @Override
    protected void initializeValues() {
        this.autoActivationButton.setSelection(this.getPreferenceStore().getBoolean("content_assist_autoactivation"));
        this.delayTimeTextBox.setText(String.valueOf(this.getPreferenceStore().getInt("content_assist_autoactivation_delay")));
    }

    @Override
    protected void storeValues() {
        this.getPreferenceStore().setValue("content_assist_autoactivation", this.autoActivationButton.getSelection());
        this.getPreferenceStore().setValue("content_assist_autoactivation_delay", this.delayTimeTextBox.getText());
    }

    @Override
    public boolean performOk() {
        boolean result = super.performOk();
        EDTUIPlugin.getDefault().saveUIPluginPreferences();
        return result;
    }

    private void controlModified(Widget widget) {
        if (widget == this.delayTimeTextBox) {
            this.validateInputDelay();
        }
    }

    private void validateInputDelay() {
        String text = this.delayTimeTextBox.getText();
        boolean status = this.validatePositiveNumber(text);
        if (status) {
            this.setValid(true);
            this.setErrorMessage(null);
        } else {
            this.setValid(false);
        }
    }

    private boolean validatePositiveNumber(String number) {
        if (number.length() == 0) {
            this.setErrorMessage(PreferencesMessages.SpellingPreferencePage_empty_threshold);
            return false;
        }
        try {
            int value = Integer.parseInt(number);
            if (value <= 0) {
                this.setErrorMessage(Messages.format(PreferencesMessages.SpellingPreferencePage_invalid_threshold, number));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.format(PreferencesMessages.SpellingPreferencePage_invalid_threshold, number));
            return false;
        }
        return true;
    }
}

