/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.externaltype.conversion.javatype;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.Set;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.gen.generator.eglsource.EglSourceContext;
import org.eclipse.edt.ide.ui.internal.externaltype.conversion.javatype.JavaTypeConstants;
import org.eclipse.edt.ide.ui.internal.externaltype.util.ReflectionUtil;
import org.eclipse.edt.ide.ui.internal.externaltype.wizards.javatype.JavaType;
import org.eclipse.edt.mof.codegen.api.AbstractTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;

public class JavaTypeClassTemplate
extends AbstractTemplate {
    public void genClass(Class<?> clazz, EglSourceContext ctx, TabbedWriter out) {
        if (!ReflectionUtil.isBuiltinEglType(clazz)) {
            JavaType toBeGenerated = (JavaType)ctx.get((Object)"toBeGeneratedType");
            Class<?> declaringClass = clazz;
            while (declaringClass.isArray()) {
                declaringClass = declaringClass.getComponentType();
            }
            String packageName = declaringClass.getPackage().getName();
            String eglName = declaringClass.getSimpleName();
            if (declaringClass.getEnclosingClass() != null) {
                eglName = String.valueOf(declaringClass.getEnclosingClass().getSimpleName()) + "_" + eglName;
            }
            boolean isEGLKeyWord = EGLNameValidator.isKeyword((String)eglName);
            boolean isStartWithEze = eglName.toLowerCase().startsWith("eze");
            if (isEGLKeyWord || isStartWithEze) {
                eglName = "_" + eglName;
            }
            if (Modifier.isPublic(clazz.getModifiers())) {
                out.print("externalType " + eglName);
            } else {
                out.print("private externalType " + eglName);
            }
            Set allClassMeta = (Set)ctx.get((Object)"allClassMeta");
            String superTypes = this.getDirectSuperTypes(clazz, toBeGenerated.getSource(), allClassMeta);
            if (superTypes != null && !superTypes.isEmpty()) {
                out.print(" extends " + superTypes);
            }
            boolean notNeedPackage = false;
            if (packageName != null && packageName.equals((String)ctx.get((Object)"eglPackage"))) {
                notNeedPackage = true;
            }
            out.println(" type JavaObject ");
            if (isEGLKeyWord || isStartWithEze) {
                out.print("{externalName = \"");
                if (declaringClass.getEnclosingClass() == null) {
                    out.print(declaringClass.getSimpleName());
                } else {
                    out.print(String.valueOf(declaringClass.getEnclosingClass().getSimpleName()) + ".");
                    out.print(declaringClass.getSimpleName());
                }
                out.print('\"');
                if (notNeedPackage) {
                    out.println("}");
                } else {
                    out.println(", PackageName = \"" + packageName + "\"}");
                }
            } else if (declaringClass.getEnclosingClass() != null) {
                out.print("{externalName = \"");
                out.print(String.valueOf(declaringClass.getEnclosingClass().getSimpleName()) + ".");
                out.print(declaringClass.getSimpleName());
                out.print('\"');
                if (notNeedPackage) {
                    out.println("}");
                } else {
                    out.println(", PackageName = \"" + packageName + "\"}");
                }
            } else if (!notNeedPackage) {
                out.println("{ PackageName = \"" + packageName + "\"}");
            }
            for (Field javaField : toBeGenerated.getFields()) {
                ctx.invoke("genField", (Object)javaField, new Object[]{ctx, out});
            }
            boolean isAbstractClas = Modifier.isAbstract(clazz.getModifiers());
            if (clazz.isInterface() || isAbstractClas || this.hasNoPublicConstructors(clazz)) {
                out.println("  private constructor();");
            } else {
                for (Constructor constructor : toBeGenerated.getConstructors()) {
                    ctx.invoke("genConstructor", (Object)constructor, new Object[]{ctx, out});
                }
            }
            for (Method method : toBeGenerated.getMethods()) {
                ctx.invoke("genMethod", (Object)method, new Object[]{ctx, out});
            }
            out.println("end");
        }
        out.println("");
    }

    public void genObject(Class<?> clazz, EglSourceContext ctx) {
        this.genClass(clazz, ctx, ctx.getTabbedWriter());
    }

    private String getDirectSuperTypes(Class<?> clazz, int source, Set<Class<?>> allClassMeta) {
        Class<?>[] interfaces;
        StringBuilder buffer = new StringBuilder(25);
        Class<?>[] classArray = interfaces = clazz.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            if (source == 0 || allClassMeta.contains(interfaceClass)) {
                buffer.append(',');
                boolean isEGLPart = JavaTypeConstants.EglPartNames.contains(interfaceClass.getSimpleName().toLowerCase(Locale.ENGLISH));
                if (isEGLPart) {
                    buffer.append("_");
                }
                buffer.append(interfaceClass.getSimpleName());
            }
            ++n2;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class) && (source == 0 || allClassMeta.contains(superclass))) {
            String simpleName = superclass.getSimpleName();
            boolean isEGLPart = JavaTypeConstants.EglPartNames.contains(simpleName.toLowerCase(Locale.ENGLISH));
            if (isEGLPart) {
                simpleName = "_" + simpleName;
            }
            buffer.insert(0, simpleName);
        }
        if (buffer.length() > 0 && ",".equals(buffer.substring(0, 1))) {
            buffer.deleteCharAt(0);
        }
        return buffer.toString();
    }

    private boolean hasNoPublicConstructors(Class<?> clazz) {
        boolean noPublicConstructors = true;
        Constructor<?>[] javaCons = clazz.getDeclaredConstructors();
        int i = 0;
        while (i < javaCons.length) {
            if (Modifier.isPublic(javaCons[i].getModifiers())) {
                noPublicConstructors = false;
                break;
            }
            ++i;
        }
        return noPublicConstructors;
    }
}

