/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.eglarpackager;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.ZipException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackageData;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackagerMessages;
import org.eclipse.edt.ide.ui.internal.eglarpackager.IEglarBinaryProjectBuilder;
import org.eclipse.edt.ide.ui.internal.eglarpackager.IEglarExportRunnable;
import org.eclipse.edt.ide.ui.internal.property.pages.BasicElementLabels;
import org.eclipse.edt.ide.ui.internal.property.pages.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class EglarFileExportOperation
extends WorkspaceModifyOperation
implements IEglarExportRunnable {
    public static final int INTERNAL_ERROR = 10001;
    public static final String EGLAR_FILE_EXTENSION = ".eglar";
    private IEglarBinaryProjectBuilder fEglarBuilder;
    private EglarPackageData fEglarPackage;
    private EglarPackageData[] fEglarPackages;
    private Shell fParentShell;
    private MessageMultiStatus fStatus;
    private boolean fFilesSaved;
    protected int totalWork;
    private int irFileCounts = 0;
    protected int[] irFileCountsPerElements = new int[0];
    protected boolean singleEGLARExport = true;
    private int work = 0;

    public EglarFileExportOperation(EglarPackageData eglarPackage, Shell parent) {
        this(new EglarPackageData[]{eglarPackage}, parent);
    }

    public EglarFileExportOperation(EglarPackageData[] eglarPackages, Shell parent) {
        this(parent);
        this.fEglarPackages = eglarPackages;
    }

    private EglarFileExportOperation(Shell parent) {
        this.fParentShell = parent;
        this.fStatus = new MessageMultiStatus(EDTUIPlugin.getPluginId(), 0, "", null);
    }

    public IEglarBinaryProjectBuilder getfEglarBuilder() {
        return this.fEglarBuilder;
    }

    public void setfEglarBuilder(IEglarBinaryProjectBuilder fEglarBuilder) {
        this.fEglarBuilder = fEglarBuilder;
    }

    public EglarPackageData getfEglarPackage() {
        return this.fEglarPackage;
    }

    public void setfEglarPackage(EglarPackageData fEglarPackage) {
        this.fEglarPackage = fEglarPackage;
    }

    public EglarPackageData[] getfEglarPackages() {
        return this.fEglarPackages;
    }

    public void setfEglarPackages(EglarPackageData[] fEglarPackages) {
        this.fEglarPackages = fEglarPackages;
    }

    public Shell getfParentShell() {
        return this.fParentShell;
    }

    public void setfParentShell(Shell fParentShell) {
        this.fParentShell = fParentShell;
    }

    public MessageMultiStatus getfStatus() {
        return this.fStatus;
    }

    public void setfStatus(MessageMultiStatus fStatus) {
        this.fStatus = fStatus;
    }

    protected void addToStatus(CoreException ex) {
        IStatus status = ex.getStatus();
        String message = ex.getLocalizedMessage();
        if (message == null || message.length() < 1) {
            message = EglarPackagerMessages.EglarFileExportOperation_coreErrorDuringExport;
            status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), message, (Throwable)ex);
        }
        this.fStatus.add(status);
    }

    protected void addInfo(String message, Throwable error) {
        this.fStatus.add((IStatus)new Status(1, EDTUIPlugin.getPluginId(), 10001, message, error));
    }

    protected void addWarning(String message, Throwable error) {
        this.fStatus.add((IStatus)new Status(2, EDTUIPlugin.getPluginId(), 10001, message, error));
    }

    protected void addError(String message, Throwable error) {
        this.fStatus.add((IStatus)new Status(4, EDTUIPlugin.getPluginId(), 10001, message, error));
    }

    protected int countSelectedElements() {
        int count = 0;
        int n = this.fEglarPackage.getElements().length;
        this.irFileCountsPerElements = new int[n];
        int i = 0;
        while (i < n) {
            Object element = this.fEglarPackage.getElements()[i];
            IResource resource = null;
            if (element instanceof IEGLElement) {
                IEGLElement ee = (IEGLElement)element;
                resource = ee.getResource();
            } else if (element instanceof IResource) {
                resource = (IResource)element;
            }
            if (resource != null) {
                if (resource.getType() == 1) {
                    ++count;
                    if (this.isIRFile(resource) || this.isRequiredResourceFile(resource)) {
                        ++this.irFileCounts;
                        int n2 = i;
                        this.irFileCountsPerElements[n2] = this.irFileCountsPerElements[n2] + 1;
                    }
                } else {
                    count += this.getTotalChildCount((IContainer)resource, i);
                }
            }
            ++i;
        }
        return count;
    }

    private int getTotalChildCount(IContainer container, int elementIndex) {
        IResource[] members;
        try {
            members = container.members();
        }
        catch (CoreException coreException) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < members.length) {
            if (members[i].getType() == 1) {
                ++count;
                if (this.isIRFile(members[i]) || this.isRequiredResourceFile(members[i])) {
                    ++this.irFileCounts;
                    int n = elementIndex;
                    this.irFileCountsPerElements[n] = this.irFileCountsPerElements[n] + 1;
                }
            } else {
                count += this.getTotalChildCount((IContainer)members[i], elementIndex);
            }
            ++i;
        }
        return count;
    }

    protected void exportSelectedElements(IProgressMonitor progressMonitor) throws InterruptedException, CoreException {
        this.fEglarBuilder = this.fEglarPackage.getEglarBuilder();
        this.fEglarBuilder.open(this.fEglarPackage, this.fParentShell, this.fStatus);
        int n = this.fEglarPackage.getElements().length;
        int i = 0;
        while (i < n) {
            Object element = this.fEglarPackage.getElements()[i];
            try {
                this.exportEGLProject2EGLAR((IEGLProject)element, progressMonitor);
                if (this.fEglarPackage.areEGLSrcFilesExported()) {
                    this.exportEGLProject2SourceZip((IEGLProject)element, progressMonitor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected void exportEGLProject2EGLAR(IEGLProject eglProject, final IProgressMonitor progressMonitor) throws CoreException {
        IFolder outputFolder;
        IPath outputLocation = eglProject.getOutputLocation();
        if (outputLocation != null && "bin".equalsIgnoreCase(outputLocation.lastSegment())) {
            outputLocation = eglProject.getPath().append("EGLBin");
        }
        if ((outputFolder = this.createFolderHandle(outputLocation)) != null) {
            outputFolder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IPath path = resource.getFullPath();
                    if (EglarFileExportOperation.this.isIRFile(resource) || EglarFileExportOperation.this.isRequiredResourceFile(resource)) {
                        EglarFileExportOperation eglarFileExportOperation = EglarFileExportOperation.this;
                        int n = eglarFileExportOperation.work;
                        eglarFileExportOperation.work = n + 1;
                        progressMonitor.worked(n);
                        IPath classFilePath = path.removeFirstSegments(2);
                        IFile file = (IFile)resource;
                        progressMonitor.subTask(Messages.format(EglarPackagerMessages.EglarFileExportOperation_exporting, BasicElementLabels.getPathLabel(classFilePath, false)));
                        try {
                            EglarFileExportOperation.this.fEglarBuilder.writeFile(file, classFilePath);
                        }
                        catch (CoreException ex) {
                            EglarFileExportOperation.this.handleCoreExceptionOnExport(ex);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    private void exportEGLProject2SourceZip(IEGLProject eglProject, final IProgressMonitor progressMonitor) throws CoreException {
        IPath[] srcPaths;
        IPath[] iPathArray = srcPaths = this.getEGLSourceFolder(eglProject);
        int n = srcPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath srcPath = iPathArray[n2];
            IFolder srcFolder = this.createFolderHandle(srcPath);
            if (srcFolder != null) {
                srcFolder.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        IPath path = resource.getFullPath();
                        if (EglarFileExportOperation.this.isEGLFile(resource)) {
                            EglarFileExportOperation eglarFileExportOperation = EglarFileExportOperation.this;
                            int n = eglarFileExportOperation.work;
                            eglarFileExportOperation.work = n + 1;
                            progressMonitor.worked(n);
                            IPath eglFilePath = path.removeFirstSegments(2);
                            IFile file = (IFile)resource;
                            progressMonitor.subTask(Messages.format(EglarPackagerMessages.EglarFileExportOperation_exporting, BasicElementLabels.getPathLabel(eglFilePath, false)));
                            try {
                                EglarFileExportOperation.this.fEglarBuilder.writeEGLSourceFile(file, eglFilePath);
                            }
                            catch (CoreException ex) {
                                EglarFileExportOperation.this.handleCoreExceptionOnExport(ex);
                            }
                            return false;
                        }
                        return true;
                    }
                });
            }
            ++n2;
        }
    }

    protected IPath[] getEGLSourceFolder(IEGLProject ieglProject) {
        ArrayList<IPath> srcPathsArrayList = new ArrayList<IPath>();
        try {
            IEGLPathEntry[] entries;
            IEGLPathEntry[] iEGLPathEntryArray = entries = ieglProject.getRawEGLPath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IEGLPathEntry entry = iEGLPathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    srcPathsArrayList.add(entry.getPath());
                }
                ++n2;
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
            return new IPath[0];
        }
        IPath[] srcPathsArray = new IPath[srcPathsArrayList.size()];
        srcPathsArrayList.toArray(srcPathsArray);
        return srcPathsArray;
    }

    protected boolean isEGLFile(IResource file) {
        return file != null && file.getType() == 1 && file.getFileExtension() != null && file.getFileExtension().toLowerCase().equals("egl");
    }

    protected boolean isIRFile(IResource file) {
        return file != null && file.getType() == 1 && file.getFileExtension() != null && file.getFileExtension().toLowerCase().equalsIgnoreCase("ir");
    }

    protected boolean isRequiredResourceFile(IResource file) {
        return file != null && file.getType() == 1 && file.getFileExtension() != null && file.getFileExtension().toLowerCase().equalsIgnoreCase("wsdl");
    }

    private IFolder createFolderHandle(IPath folderPath) {
        if (folderPath.isValidPath(folderPath.toString()) && folderPath.segmentCount() >= 2) {
            return ResourcesPlugin.getWorkspace().getRoot().getFolder(folderPath);
        }
        return null;
    }

    private void handleCoreExceptionOnExport(CoreException ex) {
        Throwable realEx = ex.getStatus().getException();
        if (realEx instanceof ZipException && realEx.getMessage() != null && realEx.getMessage().startsWith("duplicate entry:")) {
            this.addWarning(ex.getMessage(), realEx);
        } else {
            this.addToStatus(ex);
        }
    }

    @Override
    public IStatus getStatus() {
        String message = null;
        switch (this.fStatus.getSeverity()) {
            case 0: {
                message = "";
                break;
            }
            case 1: {
                message = EglarPackagerMessages.EglarFileExportOperation_exportFinishedWithInfo;
                break;
            }
            case 2: {
                message = EglarPackagerMessages.EglarFileExportOperation_exportFinishedWithWarnings;
                break;
            }
            case 4: {
                if (this.fEglarPackages.length > 1) {
                    message = EglarPackagerMessages.EglarFileExportOperation_creationOfSomeEglarsFailed;
                    break;
                }
                message = EglarPackagerMessages.EglarFileExportOperation_EglarCreationFailed;
                break;
            }
            default: {
                message = "";
            }
        }
        this.fStatus.setMessage(message);
        return this.fStatus;
    }

    protected void execute(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        int count = this.fEglarPackages.length;
        progressMonitor.beginTask("", count);
        try {
            int i = 0;
            while (i < count) {
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, 1, 4);
                this.fEglarPackage = this.fEglarPackages[i];
                if (this.fEglarPackage != null) {
                    this.singleRun((IProgressMonitor)subProgressMonitor);
                }
                ++i;
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void singleRun(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                if (!this.preconditionsOK()) {
                    throw new InvocationTargetException(null, this.getExportOperationCreationFailedSeeDetailsMessage());
                }
                if (this.fEglarPackage.areGeneratedFilesExported() && (!this.isAutoBuilding() && this.fEglarPackage.isBuildingIfNeeded() || this.isAutoBuilding() && this.fFilesSaved)) {
                    int subMonitorTicks = this.totalWork / 10;
                    this.totalWork += subMonitorTicks;
                    progressMonitor.beginTask("", this.totalWork);
                    SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, subMonitorTicks, 4);
                    this.buildProjects((IProgressMonitor)subProgressMonitor);
                } else {
                    progressMonitor.beginTask("", this.totalWork);
                }
                this.exportSelectedElements(progressMonitor);
            }
            catch (CoreException ex) {
                this.addToStatus(ex);
                try {
                    if (this.fEglarBuilder != null) {
                        this.fEglarBuilder.close();
                    }
                }
                catch (CoreException ex2) {
                    this.addToStatus(ex2);
                }
                progressMonitor.done();
            }
        }
        finally {
            try {
                if (this.fEglarBuilder != null) {
                    this.fEglarBuilder.close();
                }
            }
            catch (CoreException ex) {
                this.addToStatus(ex);
            }
            progressMonitor.done();
        }
    }

    protected String getExportOperationCreationFailedSeeDetailsMessage() {
        return EglarPackagerMessages.EglarFileExportOperation_eglarCreationFailedSeeDetails;
    }

    protected boolean preconditionsOK() {
        if (this.fEglarPackage.getElements() == null || this.fEglarPackage.getElements().length == 0) {
            this.addError(EglarPackagerMessages.EglarFileExportOperation_noResourcesSelected, null);
            return false;
        }
        if (this.fEglarPackage.getAbsoluteEglarLocation() == null) {
            this.addError(EglarPackagerMessages.EglarFileExportOperation_invalidEglarLocation, null);
            return false;
        }
        File targetFile = this.fEglarPackage.getAbsoluteEglarLocation().toFile();
        if (targetFile.exists() && !targetFile.canWrite()) {
            this.addError(EglarPackagerMessages.EglarFileExportOperation_EglarFileExistsAndNotWritable, null);
            return false;
        }
        this.totalWork = this.countSelectedElements();
        return true;
    }

    private boolean isAutoBuilding() {
        return false;
    }

    private void buildProjects(IProgressMonitor progressMonitor) {
        HashSet<IProject> builtProjects = new HashSet<IProject>(10);
        Object[] elements = this.fEglarPackage.getElements();
        int i = 0;
        while (i < elements.length) {
            block10: {
                IProject project = null;
                Object element = elements[i];
                if (element instanceof IResource) {
                    project = ((IResource)element).getProject();
                } else if (element instanceof IEGLElement) {
                    project = ((IEGLElement)element).getEGLProject().getProject();
                }
                if (project != null && !builtProjects.contains(project)) {
                    try {
                        try {
                            project.build(10, progressMonitor);
                        }
                        catch (CoreException ex) {
                            String message = Messages.format(EglarPackagerMessages.EglarFileExportOperation_errorDuringProjectBuild, BasicElementLabels.getResourceName((IResource)project));
                            this.addError(message, ex);
                            builtProjects.add(project);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        builtProjects.add(project);
                        throw throwable;
                    }
                    builtProjects.add(project);
                }
            }
            ++i;
        }
    }

    protected boolean isBinaryFolder(IEGLProject eglProject, IPath folderPath) {
        try {
            IPath output = eglProject.getOutputLocation();
            if (output != null && "bin".equalsIgnoreCase(output.lastSegment())) {
                output = eglProject.getPath().append("EGLBin");
            }
            return output.isPrefixOf(folderPath);
        }
        catch (EGLModelException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static class MessageMultiStatus
    extends MultiStatus {
        MessageMultiStatus(String pluginId, int code, String message, Throwable exception) {
            super(pluginId, code, message, exception);
        }

        protected void setMessage(String message) {
            super.setMessage(message);
        }
    }
}

