/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import org.eclipse.edt.ide.ui.internal.editor.PartitionScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;

public class EGLMultiLineRule
extends MultiLineRule {
    public EGLMultiLineRule(String startSequence, String endSequence, IToken token) {
        super(startSequence, endSequence, token, '\u0000');
    }

    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        int c;
        if (resume ? this.endSequenceDetected(scanner) : Character.toLowerCase((char)(c = scanner.read())) == this.fStartSequence[0] && this.sequenceDetected(scanner, this.fStartSequence, false, false) && this.endSequenceDetected(scanner)) {
            return this.fToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                scanner.read();
                continue;
            }
            if (this.fEndSequence.length > 0 && Character.toLowerCase((char)c) == this.fEndSequence[0]) {
                if (!this.sequenceDetected(scanner, this.fEndSequence, true, true)) continue;
                return true;
            }
            if (!this.fBreaksOnEOL) continue;
            int i = 0;
            while (i < delimiters.length) {
                if (c == delimiters[i][0] && this.sequenceDetected(scanner, delimiters[i], true, true)) {
                    return true;
                }
                ++i;
            }
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        scanner.unread();
        return false;
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed, boolean suffixCharAllowed) {
        int i = 1;
        while (i < sequence.length) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (Character.toLowerCase((char)c) != sequence[i]) {
                scanner.unread();
                int j = i - 1;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                return false;
            }
            ++i;
        }
        if (sequence == this.fStartSequence) {
            IDocument doc = ((PartitionScanner)scanner).getDocument();
            int charOffset = ((PartitionScanner)scanner).getOffset();
            try {
                char prefix;
                int offsetOfCharBeforeSQL = charOffset - this.fStartSequence.length - 1;
                if (offsetOfCharBeforeSQL >= 0 && !Character.isWhitespace(prefix = doc.getChar(offsetOfCharBeforeSQL))) {
                    return false;
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (this.fColumn == -1) {
            return this.doEvaluate(scanner, resume);
        }
        int c = scanner.read();
        scanner.unread();
        if (Character.toLowerCase((char)c) == this.fStartSequence[0]) {
            return this.fColumn == scanner.getColumn() ? this.doEvaluate(scanner, resume) : Token.UNDEFINED;
        }
        return Token.UNDEFINED;
    }
}

