/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.editor.EGLMarkerAnnotation;
import org.eclipse.edt.ide.ui.internal.editor.ProblemAnnotation;
import org.eclipse.edt.ide.ui.internal.editor.ReportedProblem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class EGLMarkerAnnotationModel
extends ResourceMarkerAnnotationModel {
    private static final String HANDLE_DYNAMIC_PROBLEMS = "handleDynamicProblems";
    private ReverseMap fReverseMap = new ReverseMap();
    private List fGeneratedAnnotations;
    private List fPreviouslyOverlaid = null;
    private List fCurrentlyOverlaid = new ArrayList();
    private boolean fIsHandlingDynamicProblems;

    public EGLMarkerAnnotationModel(IResource resource) {
        super(resource);
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        return new EGLMarkerAnnotation(marker);
    }

    public IResource getMarkerResource() {
        return this.getResource();
    }

    protected boolean shouldEnableDynamicProblems() {
        IPreferenceStore store = EDTUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(HANDLE_DYNAMIC_PROBLEMS);
    }

    public void setIsHandlingDynamicProblems(boolean enable) {
        if (this.fIsHandlingDynamicProblems != enable) {
            this.fIsHandlingDynamicProblems = enable;
            if (this.fIsHandlingDynamicProblems) {
                this.startCollectingProblems();
            } else {
                this.stopCollectingProblems();
            }
        }
    }

    private void startCollectingProblems() {
        this.fGeneratedAnnotations = new ArrayList();
    }

    private void stopCollectingProblems() {
        if (this.fGeneratedAnnotations != null) {
            this.removeAnnotations(this.fGeneratedAnnotations, true, true);
        }
        this.fGeneratedAnnotations = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportProblems(List reportedProblems) {
        boolean temporaryProblemsChanged = false;
        Object object = this.getLockObject();
        synchronized (object) {
            this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
            this.fCurrentlyOverlaid = new ArrayList();
            if (this.fGeneratedAnnotations.size() > 0) {
                temporaryProblemsChanged = true;
                this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                this.fGeneratedAnnotations.clear();
            }
            if (reportedProblems != null && reportedProblems.size() > 0) {
                for (ReportedProblem problem : reportedProblems) {
                    Position position = this.createPositionFromProblem(problem);
                    if (position == null) continue;
                    try {
                        ProblemAnnotation annotation = new ProblemAnnotation(problem);
                        this.overlayMarkers(position, annotation);
                        this.addAnnotation(annotation, position, false);
                        this.fGeneratedAnnotations.add(annotation);
                        temporaryProblemsChanged = true;
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            this.removeMarkerOverlays();
            this.fPreviouslyOverlaid = null;
        }
        if (temporaryProblemsChanged) {
            this.fireModelChanged();
        }
    }

    private Position createPositionFromProblem(ReportedProblem problem) {
        int line;
        int end;
        int start = problem.getStartOffset();
        if (start > (end = problem.getEndOffset())) {
            end = start + end;
            start = end - start;
            end -= start;
        }
        if (start == -1 && end == -1 && (line = problem.getLineNumber()) > 0 && this.fDocument != null) {
            try {
                end = start = this.fDocument.getLineOffset(line - 1);
            }
            catch (BadLocationException badLocationException) {}
        }
        if (start > -1 && end > -1) {
            return new Position(start, end - start);
        }
        return null;
    }

    private void removeMarkerOverlays() {
        if (this.fPreviouslyOverlaid != null) {
            for (EGLMarkerAnnotation annotation : this.fPreviouslyOverlaid) {
                annotation.setOverlay(null);
            }
        }
    }

    private void setOverlay(Object value, ProblemAnnotation problemAnnotation) {
        EGLMarkerAnnotation annotation;
        if (value instanceof EGLMarkerAnnotation && (annotation = (EGLMarkerAnnotation)value).isProblem()) {
            annotation.setOverlay(problemAnnotation);
            this.fPreviouslyOverlaid.remove(annotation);
            this.fCurrentlyOverlaid.add(annotation);
        }
    }

    private void overlayMarkers(Position position, ProblemAnnotation problemAnnotation) {
        Object value = this.getAnnotations(position);
        if (value instanceof List) {
            List list = (List)value;
            Iterator e = list.iterator();
            while (e.hasNext()) {
                this.setOverlay(e.next(), problemAnnotation);
            }
        } else {
            this.setOverlay(value, problemAnnotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAnnotations(Position position) {
        Object object = this.getLockObject();
        synchronized (object) {
            return this.fReverseMap.get(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
        super.addAnnotation(annotation, position, fireModelChanged);
        Object object = this.getLockObject();
        synchronized (object) {
            Object cached = this.fReverseMap.get(position);
            if (cached == null) {
                this.fReverseMap.put(position, annotation);
            } else if (cached instanceof List) {
                List list = (List)cached;
                list.add(annotation);
            } else if (cached instanceof Annotation) {
                ArrayList<Object> list = new ArrayList<Object>(2);
                list.add(cached);
                list.add(annotation);
                this.fReverseMap.put(position, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllAnnotations(boolean fireModelChanged) {
        super.removeAllAnnotations(fireModelChanged);
        Object object = this.getLockObject();
        synchronized (object) {
            this.fReverseMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
        Position position = this.getPosition(annotation);
        Object object = this.getLockObject();
        synchronized (object) {
            Object cached = this.fReverseMap.get(position);
            if (cached instanceof List) {
                List list = (List)cached;
                list.remove(annotation);
                if (list.size() == 1) {
                    this.fReverseMap.put(position, list.get(0));
                    list.clear();
                }
            } else if (cached instanceof Annotation) {
                this.fReverseMap.remove(position);
            }
        }
        super.removeAnnotation(annotation, fireModelChanged);
    }

    public boolean isHandlingDynamicProblems() {
        return this.fIsHandlingDynamicProblems;
    }

    protected static class ReverseMap {
        private List fList = new ArrayList(2);
        private int fAnchor = 0;

        protected ReverseMap() {
        }

        public Object get(Position position) {
            Entry entry;
            int length = this.fList.size();
            int i = this.fAnchor;
            while (i < length) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            i = 0;
            while (i < this.fAnchor) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            return null;
        }

        private int getIndex(Position position) {
            int length = this.fList.size();
            int i = 0;
            while (i < length) {
                Entry entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void put(Position position, Object value) {
            int index = this.getIndex(position);
            if (index == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = value;
                this.fList.add(entry);
            } else {
                Entry entry = (Entry)this.fList.get(index);
                entry.fValue = value;
            }
        }

        public void remove(Position position) {
            int index = this.getIndex(position);
            if (index > -1) {
                this.fList.remove(index);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }
}

