/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.deployment.ui.WebBindingDetailPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RestBindingDetailPage
extends WebBindingDetailPage {
    private Binding fRestBinding;
    private Text fBaseUri;
    private Text fSessionCookieId;

    public RestBindingDetailPage() {
        this.nColumnSpan = 3;
    }

    @Override
    protected Composite createDetailSection(Composite parent, FormToolkit toolkit, int sectionStyle, int columnSpan) {
        return this.createSection(parent, toolkit, SOAMessages.RestBindingDetailSecTitle, SOAMessages.RestBindingDetailSecDescp, sectionStyle, columnSpan);
    }

    @Override
    protected void createDetailControls(FormToolkit toolkit, Composite parent) {
        this.createBaseUriControl(toolkit, parent);
        this.createBaseUriExample(toolkit, parent);
        this.createSessionCookieIdControl(toolkit, parent);
        this.createEnableGenerateControl(toolkit, parent);
    }

    @Override
    protected void HandleGenCheckChanged() {
        EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(this.fRestBinding), "enableGeneration", this.fGenBtn.getSelection());
    }

    private void createBaseUriControl(FormToolkit toolkit, Composite parent) {
        toolkit.createLabel(parent, SOAMessages.LabelBaseURI);
        this.fBaseUri = this.createTextControl(toolkit, parent);
        this.fBaseUri.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RestBindingDetailPage.this.HandleBaseUriChanged();
            }
        });
    }

    private void createBaseUriExample(FormToolkit toolkit, Composite parent) {
        boolean toggleBorder;
        boolean bl = toggleBorder = toolkit.getBorderStyle() == 2048;
        if (toggleBorder) {
            toolkit.setBorderStyle(0);
        }
        toolkit.createLabel(parent, SOAMessages.ExampleDeployedURI);
        Composite exampleComposite = toolkit.createComposite(parent);
        exampleComposite.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumnSpan - 1;
        exampleComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        exampleComposite.setLayout((Layout)layout);
        Text example = toolkit.createText(exampleComposite, "http://myhostname:8080/myTargetWebProject/restservices/myService", 12);
        example.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(parent, SOAMessages.ExampleWorkspaceURI);
        exampleComposite = toolkit.createComposite(parent);
        exampleComposite.setFont(parent.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumnSpan - 1;
        exampleComposite.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        exampleComposite.setLayout((Layout)layout);
        example = toolkit.createText(exampleComposite, "workspace://myServiceProject/myPackage.myService", 12);
        example.setLayoutData((Object)new GridData(768));
        if (toggleBorder) {
            toolkit.setBorderStyle(2048);
        }
    }

    protected void HandleBaseUriChanged() {
        this.fRestBinding.setUri(this.fBaseUri.getText());
    }

    private void createSessionCookieIdControl(FormToolkit toolkit, Composite parent) {
        this.createSpacer(toolkit, parent, this.nColumnSpan);
        toolkit.createLabel(parent, SOAMessages.LabelSessionCookieId);
        this.fSessionCookieId = this.createTextControl(toolkit, parent);
        this.fSessionCookieId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RestBindingDetailPage.this.HandleSessionCookieIdChanged();
            }
        });
    }

    protected void HandleSessionCookieIdChanged() {
        EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(this.fRestBinding), "sessionCookieId", this.fSessionCookieId.getText());
    }

    @Override
    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.fRestBinding = ssel.size() == 1 ? (Binding)ssel.getFirstElement() : null;
        this.update();
    }

    @Override
    protected void update() {
        String enableGen;
        String sessionCookieId;
        this.fNameText.setText(this.fRestBinding.getName() == null ? "" : this.fRestBinding.getName());
        String baseUri = this.fRestBinding.getUri();
        if (baseUri != null) {
            this.fBaseUri.setText(baseUri);
        }
        if ((sessionCookieId = EGLDDRootHelper.getParameterValue(EGLDDRootHelper.getParameters(this.fRestBinding), "sessionCookieId")) != null) {
            this.fSessionCookieId.setText(sessionCookieId);
        }
        if ((enableGen = EGLDDRootHelper.getParameterValue(EGLDDRootHelper.getParameters(this.fRestBinding), "enableGeneration")) != null) {
            this.fGenBtn.setSelection(Boolean.parseBoolean(enableGen));
        }
    }

    @Override
    protected void HandleNameChanged() {
        this.fRestBinding.setName(this.fNameText.getText());
        this.refreshMainTableViewer();
    }
}

