/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EDataType;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class EGLFieldsFromAnnotationProposalHandler
extends EGLAbstractProposalHandler {
    private static EType elistType;
    private List<String> fieldsAlreadySpecified;

    public EGLFieldsFromAnnotationProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor, List<String> fieldsAlreadySpecified) {
        super(viewer, documentOffset, prefix, editor);
        this.fieldsAlreadySpecified = fieldsAlreadySpecified;
    }

    public List getProposals(AnnotationType annotationType) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        List fields = annotationType.getEFields();
        for (EField field : fields) {
            if (!field.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) || this.fieldsAlreadySpecified.contains(field.getName().toUpperCase().toLowerCase())) continue;
            proposals.add(this.createProposal(field, annotationType));
        }
        return proposals;
    }

    private String getAdditionalInfo(EField field) {
        return "";
    }

    private EGLCompletionProposal createProposal(EField field, AnnotationType annotationType) {
        String proposalString = field.getCaseSensitiveName();
        ProposalInfo info = this.getProposalInfo(field, annotationType);
        return new EGLCompletionProposal(this.viewer, proposalString, info.proposalString, this.getAdditionalInfo(field), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), info.cursorOffset, 75, info.highlightLen, "org.eclipse.edt.ide.ui.envvar_obj.gif");
    }

    private ProposalInfo getProposalInfo(EField field, AnnotationType annotationType) {
        ProposalInfo info = new ProposalInfo();
        info.proposalString = String.valueOf(field.getCaseSensitiveName()) + " = ";
        info.cursorOffset = field.getCaseSensitiveName().length() + 3;
        this.populateInfo(info, field);
        return info;
    }

    private void populateInfo(ProposalInfo info, EField field) {
        this.populateInfo(info, field.getEType());
    }

    private void populateInfo(ProposalInfo info, EType eType) {
        if (this.isGenericElistType(eType)) {
            info.proposalString = String.valueOf(info.proposalString) + "[";
            ++info.cursorOffset;
            EType currType = (EType)((EGenericType)eType).getETypeArguments().get(0);
            this.populateInfo(info, currType);
            info.proposalString = String.valueOf(info.proposalString) + "]";
        }
        if (eType instanceof EDataType) {
            String className = ((EDataType)eType).getJavaClassName();
            if (className.equals("java.lang.Object")) {
                return;
            }
            if (className.equals("java.lang.String")) {
                info.proposalString = String.valueOf(info.proposalString) + "\"\"";
                ++info.cursorOffset;
                return;
            }
            if (className.equals("java.lang.Boolean")) {
                info.proposalString = String.valueOf(info.proposalString) + "yes";
                info.highlightLen = 3;
                return;
            }
            if (className.equals("java.lang.Integer")) {
                info.proposalString = String.valueOf(info.proposalString) + "0";
                info.highlightLen = 1;
                return;
            }
            if (className.equals("java.lang.Float")) {
                info.proposalString = String.valueOf(info.proposalString) + "0e0";
                info.highlightLen = 3;
                return;
            }
            if (className.equals("java.math.BigDecimal")) {
                info.proposalString = String.valueOf(info.proposalString) + "0.0";
                info.highlightLen = 3;
                return;
            }
        }
        if (eType instanceof AnnotationType) {
            AnnotationType annotationType = (AnnotationType)eType;
            String str = "@" + annotationType.getCaseSensitiveName() + "{}";
            info.cursorOffset = info.cursorOffset + str.length() - 1;
            info.proposalString = String.valueOf(info.proposalString) + str;
            return;
        }
    }

    private boolean isGenericElistType(EType type) {
        if (type instanceof EGenericType) {
            try {
                EType elistType = EGLFieldsFromAnnotationProposalHandler.getElistType();
                EClassifier eclassifier = ((EGenericType)type).getEClassifier();
                return elistType.equals(eclassifier);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static EType getElistType() {
        if (elistType == null) {
            try {
                elistType = (EType)Environment.getCurrentEnv().findType("org.eclipse.edt.mof.EList");
            }
            catch (Exception exception) {}
        }
        return elistType;
    }

    private static class ProposalInfo {
        String proposalString;
        int cursorOffset;
        int highlightLen;

        private ProposalInfo() {
        }
    }
}

