/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.celleditors;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractDynamicComboBoxCellEditor
extends CellEditor {
    private CCombo comboBox;
    private int swtStyle = 0;

    public AbstractDynamicComboBoxCellEditor(Composite parent, int swtStyle) {
        super(parent);
        this.setSwtStyle(swtStyle);
    }

    public AbstractDynamicComboBoxCellEditor(Composite parent) {
        super(parent);
    }

    protected void addKeyListener(Control control) {
        control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                AbstractDynamicComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
    }

    protected void addSelectionListener(CCombo combo) {
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractDynamicComboBoxCellEditor.this.editOccured();
            }
        });
    }

    protected void addTraverseListener(Control control) {
        control.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new CCombo(parent, this.getSwtStyle());
        this.comboBox.setVisibleItemCount(20);
        this.comboBox.setFont(parent.getFont());
        this.addModifyListener(this.comboBox);
        this.addKeyListener((Control)this.comboBox);
        this.addSelectionListener(this.comboBox);
        this.addTraverseListener((Control)this.comboBox);
        return this.comboBox;
    }

    protected void addModifyListener(CCombo comboBox) {
        comboBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractDynamicComboBoxCellEditor.this.editOccured();
            }
        });
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CCombo getComboBox() {
        return this.comboBox;
    }

    public void setTextLimit(int limit) {
        this.getComboBox().setTextLimit(limit);
    }

    public int getSwtStyle() {
        return this.swtStyle;
    }

    public void setSwtStyle(int swtStyle) {
        this.swtStyle = swtStyle;
    }

    protected void editOccured() {
        String value = this.comboBox.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (typedValue == null && newValidState) {
            Assert.isTrue((boolean)false, (String)"Validator isn't limiting the cell editor's type range");
        }
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
        }
        this.valueChanged(oldValidState, newValidState);
    }
}

