/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core.java.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.edt.debug.core.EDTDebugCoreMessages;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.PreferenceUtil;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugTarget;
import org.eclipse.edt.debug.core.java.filters.FilterStepType;
import org.eclipse.edt.debug.core.java.filters.ITypeFilter;
import org.eclipse.edt.debug.core.java.filters.ITypeFilterCategory;
import org.eclipse.edt.debug.internal.core.java.filters.DefaultTypeFilterCategory;
import org.eclipse.osgi.util.NLS;

public class TypeFilterUtil
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final TypeFilterUtil INSTANCE = new TypeFilterUtil();
    public static final String EXTENSION_POINT_TYPE_FILTERS = "javaTypeFilters";
    private ITypeFilterCategory[] filterCategories;
    private ITypeFilter[] activeFilters;
    private ITypeFilter[] allFilters;

    private TypeFilterUtil() {
    }

    public synchronized ITypeFilter[] getAllFilters() {
        if (this.allFilters == null) {
            this.loadFilters();
        }
        return this.allFilters;
    }

    public synchronized ITypeFilter[] getActiveFilters() {
        if (this.activeFilters == null) {
            this.loadFilters();
        }
        return this.activeFilters;
    }

    private void calculateActiveFilters() {
        ArrayList<ITypeFilter> filterList = new ArrayList<ITypeFilter>(10);
        ITypeFilterCategory[] iTypeFilterCategoryArray = this.getTypeFilterCategories();
        int n = iTypeFilterCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeFilterCategory category = iTypeFilterCategoryArray[n2];
            if (category.isEnabled()) {
                ITypeFilter[] iTypeFilterArray = category.getFilters();
                int n3 = iTypeFilterArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeFilter filter = iTypeFilterArray[n4];
                    filterList.add(filter);
                    ++n4;
                }
            }
            ++n2;
        }
        this.activeFilters = filterList.toArray(new ITypeFilter[filterList.size()]);
    }

    public synchronized ITypeFilterCategory[] getTypeFilterCategories() {
        if (this.filterCategories == null) {
            this.loadFilters();
        }
        return this.filterCategories;
    }

    private void loadFilters() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.edt.debug.core", EXTENSION_POINT_TYPE_FILTERS);
        ArrayList<ITypeFilterCategory> categories = new ArrayList<ITypeFilterCategory>(elements.length);
        ArrayList<ITypeFilter> filters = new ArrayList<ITypeFilter>(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeFilter filter;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getName();
            if ("category".equals(name)) {
                ITypeFilterCategory category = this.createCategory(element);
                if (category != null) {
                    categories.add(category);
                }
            } else if ("filter".equals(name) && (filter = this.createFilter(element)) != null) {
                filters.add(filter);
            }
            ++n2;
        }
        this.allFilters = filters.toArray(new ITypeFilter[filters.size()]);
        if (filters.size() > 0) {
            Iterator it = filters.iterator();
            block1: while (it.hasNext()) {
                ITypeFilter filter = (ITypeFilter)it.next();
                String targetId = filter.getCategoryId();
                for (ITypeFilterCategory category : categories) {
                    if (!targetId.equals(category.getId())) continue;
                    filter.setCategory(category);
                    category.addFilter(filter);
                    it.remove();
                    continue block1;
                }
            }
            if (filters.size() > 0) {
                StringBuilder buf = new StringBuilder(100);
                for (ITypeFilter filter : filters) {
                    buf.append("id=");
                    buf.append(filter.getId());
                    buf.append(", categoryId=");
                    buf.append(filter.getCategoryId());
                    buf.append('\n');
                }
                EDTDebugCorePlugin.log((IStatus)new Status(2, "org.eclipse.edt.debug.core", NLS.bind((String)EDTDebugCoreMessages.TypeFilterProviderMissingCategory, (Object)buf.toString())));
            }
        }
        this.filterCategories = categories.toArray(new ITypeFilterCategory[categories.size()]);
        this.applyFilterEnablementPreferences();
        this.applyStepTypePreferences();
        this.calculateActiveFilters();
        PreferenceUtil.addPreferenceChangeListener(this);
    }

    private void applyFilterEnablementPreferences() {
        String enablement = PreferenceUtil.getString("org.eclipse.edt.debug.core.typeFilterEnablement", null);
        if (enablement != null && enablement.length() > 0) {
            ArrayList<ITypeFilterCategory> categoriesNotListed = new ArrayList<ITypeFilterCategory>(Arrays.asList(this.filterCategories));
            StringTokenizer tok = new StringTokenizer(enablement, ",", false);
            block0: while (tok.hasMoreTokens()) {
                String next = tok.nextToken();
                int equals = next.indexOf(61);
                if (equals == -1 || equals >= next.length() - 1) continue;
                String id = next.substring(0, equals);
                ITypeFilterCategory[] iTypeFilterCategoryArray = this.filterCategories;
                int n = this.filterCategories.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeFilterCategory category = iTypeFilterCategoryArray[n2];
                    if (id.equals(category.getId())) {
                        category.setEnabled(Boolean.parseBoolean(next.substring(equals + 1)));
                        categoriesNotListed.remove(category);
                        continue block0;
                    }
                    ++n2;
                }
            }
            for (ITypeFilterCategory category : categoriesNotListed) {
                category.setEnabled(category.getDefaultEnablement());
            }
        } else {
            ITypeFilterCategory[] iTypeFilterCategoryArray = this.filterCategories;
            int n = this.filterCategories.length;
            int n3 = 0;
            while (n3 < n) {
                ITypeFilterCategory category = iTypeFilterCategoryArray[n3];
                category.setEnabled(category.getDefaultEnablement());
                ++n3;
            }
        }
    }

    private void applyStepTypePreferences() {
        String stepTypes = PreferenceUtil.getString("org.eclipse.edt.debug.core.typeFilterStepTypes", null);
        if (stepTypes != null && stepTypes.length() > 0) {
            ArrayList<ITypeFilterCategory> categoriesNotListed = new ArrayList<ITypeFilterCategory>(Arrays.asList(this.filterCategories));
            StringTokenizer tok = new StringTokenizer(stepTypes, ",", false);
            block0: while (tok.hasMoreTokens()) {
                String next = tok.nextToken();
                int equals = next.indexOf(61);
                if (equals == -1 || equals >= next.length() - 1) continue;
                String id = next.substring(0, equals);
                ITypeFilterCategory[] iTypeFilterCategoryArray = this.filterCategories;
                int n = this.filterCategories.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeFilterCategory category = iTypeFilterCategoryArray[n2];
                    if (id.equals(category.getId())) {
                        category.setStepType(FilterStepType.parse(next.substring(equals + 1)));
                        categoriesNotListed.remove(category);
                        continue block0;
                    }
                    ++n2;
                }
            }
            for (ITypeFilterCategory category : categoriesNotListed) {
                category.setStepType(category.getDefaultStepType());
            }
        } else {
            ITypeFilterCategory[] iTypeFilterCategoryArray = this.filterCategories;
            int n = this.filterCategories.length;
            int n3 = 0;
            while (n3 < n) {
                ITypeFilterCategory category = iTypeFilterCategoryArray[n3];
                category.setStepType(category.getDefaultStepType());
                ++n3;
            }
        }
    }

    private ITypeFilterCategory createCategory(IConfigurationElement element) {
        ITypeFilterCategory category = null;
        String id = element.getAttribute("id");
        if (id == null || (id = id.trim()).length() == 0) {
            EDTDebugCorePlugin.log((IStatus)new Status(2, "org.eclipse.edt.debug.core", NLS.bind((String)EDTDebugCoreMessages.TypeFilterExtensionRequiredAttributeMissing, (Object)"id")));
            return null;
        }
        String name = element.getAttribute("name");
        if (name == null || (name = name.trim()).length() == 0) {
            EDTDebugCorePlugin.log((IStatus)new Status(2, "org.eclipse.edt.debug.core", NLS.bind((String)EDTDebugCoreMessages.TypeFilterExtensionRequiredAttributeMissing, (Object)"name")));
            return null;
        }
        String clazz = element.getAttribute("class");
        if (clazz != null && (clazz = clazz.trim()).length() > 0) {
            try {
                Object o = element.createExecutableExtension("class");
                if (o instanceof ITypeFilterCategory) {
                    category = (ITypeFilterCategory)o;
                }
            }
            catch (CoreException ce) {
                EDTDebugCorePlugin.log(ce);
            }
        }
        if (category == null) {
            category = new DefaultTypeFilterCategory();
        }
        category.setId(id);
        category.setName(name);
        String desc = element.getAttribute("description");
        if (desc == null || (desc = desc.trim()).length() == 0) {
            category.setDescription(EDTDebugCoreMessages.NoDescription);
        } else {
            category.setDescription(desc);
        }
        String visible = element.getAttribute("visible");
        if (visible == null || (visible = visible.trim()).length() == 0) {
            category.setVisible(true);
        } else {
            category.setVisible(Boolean.parseBoolean(visible));
        }
        String defStepType = element.getAttribute("defaultStepType");
        if (defStepType == null || (defStepType = defStepType.trim()).length() == 0) {
            category.setDefaultStepType(FilterStepType.STEP_INTO);
        } else {
            category.setDefaultStepType(FilterStepType.parse(defStepType));
        }
        String defEnablement = element.getAttribute("defaultEnablement");
        if (defEnablement == null || (defEnablement = defEnablement.trim()).length() == 0) {
            category.setDefaultEnablement(true);
        } else {
            category.setDefaultEnablement(Boolean.parseBoolean(defEnablement));
        }
        category.setStepType(category.getDefaultStepType());
        category.setEnabled(category.getDefaultEnablement());
        return category;
    }

    private ITypeFilter createFilter(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || (id = id.trim()).length() == 0) {
            EDTDebugCorePlugin.log((IStatus)new Status(2, "org.eclipse.edt.debug.core", NLS.bind((String)EDTDebugCoreMessages.TypeFilterExtensionRequiredAttributeMissing, (Object)"id")));
            return null;
        }
        String categoryId = element.getAttribute("categoryId");
        if (categoryId == null || (categoryId = categoryId.trim()).length() == 0) {
            EDTDebugCorePlugin.log((IStatus)new Status(2, "org.eclipse.edt.debug.core", NLS.bind((String)EDTDebugCoreMessages.TypeFilterExtensionRequiredAttributeMissing, (Object)"categoryId")));
            return null;
        }
        try {
            Object o = element.createExecutableExtension("class");
            if (o instanceof ITypeFilter) {
                ITypeFilter filter = (ITypeFilter)o;
                filter.setId(id);
                filter.setCategoryId(categoryId);
                return filter;
            }
        }
        catch (CoreException ce) {
            EDTDebugCorePlugin.log(ce);
        }
        return null;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String key = event.getKey();
        if ("org.eclipse.edt.debug.core.typeFilterStepTypes".equals(key)) {
            this.applyStepTypePreferences();
        } else if ("org.eclipse.edt.debug.core.typeFilterEnablement".equals(key)) {
            this.applyFilterEnablementPreferences();
            this.calculateActiveFilters();
            ITypeFilter[] filters = this.getActiveFilters();
            IDebugTarget[] iDebugTargetArray = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            int n = iDebugTargetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget target = iDebugTargetArray[n2];
                IEGLJavaDebugTarget eglTarget = (IEGLJavaDebugTarget)target.getAdapter(IEGLJavaDebugTarget.class);
                if (eglTarget != null) {
                    ITypeFilter[] iTypeFilterArray = filters;
                    int n3 = filters.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ITypeFilter filter = iTypeFilterArray[n4];
                        filter.initialize(eglTarget);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public void dispose() {
        if (this.filterCategories != null) {
            ITypeFilterCategory[] iTypeFilterCategoryArray = this.filterCategories;
            int n = this.filterCategories.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeFilterCategory category = iTypeFilterCategoryArray[n2];
                category.dispose();
                ++n2;
            }
            this.filterCategories = null;
        }
        PreferenceUtil.removePreferenceChangeListener(this);
    }
}

