/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.edt.ide.rui.utils.EGLResource;

public class EGLARResource
implements EGLResource {
    private static final String EGLAR_PREFIX = "eglar://";
    private ZipFile eglar;
    private ZipEntry entry;

    public EGLARResource(ZipFile eglar, ZipEntry resource) {
        this.eglar = eglar;
        this.entry = resource;
    }

    @Override
    public boolean exists() {
        return this.entry != null;
    }

    @Override
    public boolean isFile() {
        return !this.entry.isDirectory();
    }

    @Override
    public File toFile() {
        return new File(this.eglar.getName());
    }

    @Override
    public String getName() {
        return this.entry.getName();
    }

    @Override
    public String getFullName() {
        return EGLAR_PREFIX + this.eglar.getName() + "|" + this.entry.getName();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.eglar.getInputStream(this.entry);
    }

    @Override
    public long getLocalTimeStamp() {
        return this.entry.getTime();
    }
}

