/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.internal.util.EglarUtil;
import org.eclipse.edt.ide.core.IIDECompiler;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLPathContainerInitializer;
import org.eclipse.edt.ide.core.model.IEGLPathContainer;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.osgi.framework.Bundle;

public class EGLSystemPathContaierInitializer
extends EGLPathContainerInitializer {
    @Override
    public void initialize(IPath containerPath, IEGLProject project) throws CoreException {
        if (EGLSystemPathContaierInitializer.isValidEGLSystemPathContainerPath(containerPath)) {
            ArrayList<IEGLPathEntry> pathEntries = new ArrayList<IEGLPathEntry>();
            IIDECompiler compiler = ProjectSettingsUtility.getCompiler(project.getProject());
            List files = EglarUtil.getAllSystemEglars((ICompiler)compiler);
            for (File file : files) {
                Path path = new Path(file.getAbsolutePath());
                pathEntries.add(EGLCore.newLibraryEntry((IPath)path, (IPath)path, null));
            }
            IEGLPathEntry[] entries = pathEntries.toArray(new IEGLPathEntry[pathEntries.size()]);
            EGLSystemRuntimePathContainer container = new EGLSystemRuntimePathContainer(containerPath, entries);
            EGLCore.setEGLPathContainer(containerPath, new IEGLProject[]{project}, new EGLSystemRuntimePathContainer[]{container}, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected String getPathToPluginDirectory(String pluginID, String subDir, String fileName) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        try {
            String file = FileLocator.resolve((URL)bundle.getEntry("/")).getFile();
            file = file.replace('/', File.separatorChar);
            file = String.valueOf(file) + subDir + File.separatorChar + fileName;
            return file;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static boolean isValidEGLSystemPathContainerPath(IPath path) {
        return path != null && path.segmentCount() == 1 && "org.eclipse.edt.compiler.EDT_RUNTIME".equals(path.segment(0));
    }

    private class EGLSystemRuntimePathContainer
    implements IEGLPathContainer {
        private IPath path;
        private String description;
        private IEGLPathEntry[] entries;

        public EGLSystemRuntimePathContainer(IPath path, IEGLPathEntry[] entries) {
            this.path = path;
            this.description = EGLModelResources.eglarSystemLibraries;
            this.entries = entries;
        }

        @Override
        public IEGLPathEntry[] getEGLPathEntries() {
            return this.entries;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getKind() {
            return 2;
        }

        @Override
        public IPath getPath() {
            return this.path;
        }
    }
}

