/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.utils;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.MofarBuildPathEntry;
import org.eclipse.edt.compiler.ZipFileBindingBuildPathEntry;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.EnumerationField;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.core.IIDECompiler;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironment;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.ide.core.internal.utils.IBoundNodeAddress;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.core.utils.BinaryReadOnlyFile;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.utils.NameUtile;

public class BoundNodeLocationUtility {
    private static final BoundNodeLocationUtility INSTANCE = new BoundNodeLocationUtility();

    private BoundNodeLocationUtility() {
    }

    public static BoundNodeLocationUtility getInstance() {
        return INSTANCE;
    }

    public IBoundNodeAddress createBoundNodeAddress(Element selectedNodeBinding, Expression expr, IProject project) {
        BoundPartAddress address = null;
        if (selectedNodeBinding instanceof Type) {
            Assignment assignment;
            String name;
            Node parent;
            if (selectedNodeBinding instanceof AnnotationType && (parent = expr.getParent()) instanceof Assignment && ((AnnotationType)selectedNodeBinding).getEField(NameUtile.getAsName((String)(name = (assignment = (Assignment)parent).getLeftHandSide().getCanonicalString()))) != null) {
                IFile file = this.getFileForNode((org.eclipse.edt.mof.egl.Part)selectedNodeBinding, project);
                address = new BoundDataBindingAddress(file, ((org.eclipse.edt.mof.egl.Part)selectedNodeBinding).getName(), name);
            }
            if (address == null && selectedNodeBinding instanceof org.eclipse.edt.mof.egl.Part) {
                IFile file = this.getFileForNode((org.eclipse.edt.mof.egl.Part)selectedNodeBinding, project);
                address = new BoundPartAddress(file, ((org.eclipse.edt.mof.egl.Part)selectedNodeBinding).getName());
            }
        } else if (selectedNodeBinding instanceof Member) {
            Member dataBinding = (Member)selectedNodeBinding;
            org.eclipse.edt.mof.egl.Part declaringPart = this.getContainingBinding(dataBinding, expr);
            if (dataBinding instanceof FunctionParameter) {
                if (declaringPart != null) {
                    address = new BoundFunctionParameterBindingAddress(this.getFileForNode(declaringPart, project), declaringPart.getName(), (FunctionParameter)dataBinding);
                }
            } else if (dataBinding instanceof FunctionMember) {
                if (declaringPart != null) {
                    address = new BoundFunctionBindingAddress(this.getFileForNode(declaringPart, project), declaringPart.getName(), (FunctionMember)dataBinding);
                }
            } else if (declaringPart != null) {
                address = new BoundDataBindingAddress(this.getFileForNode(declaringPart, project), declaringPart.getName(), dataBinding.getName());
            }
        }
        return address;
    }

    private org.eclipse.edt.mof.egl.Part getContainingBinding(Member binding, Expression expr) {
        org.eclipse.edt.mof.egl.Part decl = BindingUtil.getDeclaringPart((Member)binding);
        if (decl != null) {
            return decl;
        }
        final Type[] result = new Type[1];
        expr.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(QualifiedName qualifiedName) {
                result[0] = qualifiedName.getQualifier().resolveType();
                return false;
            }

            public boolean visit(FieldAccess fieldAccess) {
                result[0] = fieldAccess.getPrimary().resolveType();
                return false;
            }
        });
        return result[0] instanceof org.eclipse.edt.mof.egl.Part ? (org.eclipse.edt.mof.egl.Part)result[0] : null;
    }

    private IFile getFileForNode(org.eclipse.edt.mof.egl.Part partBinding, IProject project) {
        IFile result = null;
        String packageName = partBinding.getPackageName();
        String partName = partBinding.getName();
        IEnvironment ienv = BindingUtil.getEnvironment((Element)partBinding);
        if (ienv instanceof WorkingCopyProjectEnvironment) {
            WorkingCopyProjectEnvironment environment = (WorkingCopyProjectEnvironment)ienv;
            IPartOrigin origin = environment.getPartOrigin(packageName, partName);
            if (origin == null) {
                return null;
            }
            result = origin.getEGLFile();
        } else if (ienv == null && project != null) {
            IIDECompiler compiler = ProjectSettingsUtility.getCompiler(project);
            List list = compiler.getSystemBuildPathEntries();
            for (ZipFileBindingBuildPathEntry entry : list) {
                if (entry instanceof MofarBuildPathEntry || entry.getPartBinding(packageName, partName) == null) continue;
                String sourceName = partBinding.getFileName();
                String irName = IRFileNameUtility.toIRFileName((String)partBinding.getName());
                result = new BinaryReadOnlyFile(entry.getID(), sourceName, irName);
                break;
            }
        }
        return result;
    }

    public Node getASTNodeForAddress(final IBoundNodeAddress address, IWorkingCopy[] workingCopies) {
        if (address.getDeclaringFile() == null) {
            return null;
        }
        final Node[] astNode = new Node[1];
        WorkingCopyCompiler compiler = WorkingCopyCompiler.getInstance();
        String[] packageName = address.getDeclaringFile().isReadOnly() ? ((BinaryReadOnlyFile)address.getDeclaringFile()).getPackageSegments() : ((EGLFile)EGLCore.create(address.getDeclaringFile())).getPackageName();
        if (packageName == null) {
            return null;
        }
        compiler.compilePart(address.getDeclaringFile().getProject(), Util.stringArrayToQualifiedName(packageName), address.getDeclaringFile(), workingCopies, address.getPartName(), new IWorkingCopyCompileRequestor(){

            @Override
            public void acceptResult(WorkingCopyCompilationResult result) {
                Node boundPart = result.getBoundPart();
                if (boundPart instanceof Part) {
                    Part part = (Part)boundPart;
                    if (address instanceof BoundDataBindingAddress) {
                        BoundDataBindingNodeLocator locator = new BoundDataBindingNodeLocator((BoundDataBindingAddress)address);
                        part.accept((IASTVisitor)locator);
                        astNode[0] = locator.result;
                    } else if (address instanceof BoundFunctionParameterBindingAddress) {
                        BoundFunctionParameterBindingNodeLocator locator = new BoundFunctionParameterBindingNodeLocator((BoundFunctionParameterBindingAddress)address);
                        part.accept((IASTVisitor)locator);
                        astNode[0] = locator.result;
                    } else if (address instanceof BoundFunctionBindingAddress) {
                        BoundFunctionNodeLocator locator = new BoundFunctionNodeLocator((BoundFunctionBindingAddress)address);
                        part.accept((IASTVisitor)locator);
                        astNode[0] = locator.result;
                    } else {
                        astNode[0] = part;
                    }
                } else {
                    result.getDeclaringFile().equals((Object)address.getDeclaringFile());
                }
            }
        });
        return astNode[0];
    }

    private static String getSignature(FunctionMember functionBinding) {
        StringBuffer sig = new StringBuffer();
        if (functionBinding == null) {
            sig.append("null");
        } else {
            sig.append(functionBinding.getName());
            Iterator iter = functionBinding.getParameters().iterator();
            while (iter.hasNext()) {
                sig.append("|");
                Type tBinding = ((FunctionParameter)iter.next()).getType();
                sig.append(tBinding == null ? "null" : tBinding.getTypeSignature());
            }
            Type tBinding = functionBinding.getReturnType();
            if (tBinding != null) {
                sig.append("|");
                sig.append(tBinding.getTypeSignature());
            }
        }
        return sig.toString();
    }

    private static class BoundDataBindingAddress
    extends BoundPartAddress {
        private String address;

        public BoundDataBindingAddress(IFile declaringFile, String partName, String address) {
            super(declaringFile, partName);
            this.address = NameUtile.getAsName((String)address);
        }
    }

    private class BoundDataBindingNodeLocator
    extends AbstractASTVisitor {
        private BoundDataBindingAddress address;
        private Node result;

        public BoundDataBindingNodeLocator(BoundDataBindingAddress address) {
            this.address = address;
        }

        public boolean visit(ClassDataDeclaration classDataDeclaration) {
            for (Name name : classDataDeclaration.getNames()) {
                if (!NameUtile.equals((String)name.getIdentifier(), (String)this.address.address)) continue;
                this.result = classDataDeclaration;
                return false;
            }
            return true;
        }

        public boolean visit(NestedFunction nestedFunction) {
            if (NameUtile.equals((String)this.address.address, (String)nestedFunction.getName().getIdentifier())) {
                this.result = nestedFunction;
                return false;
            }
            return true;
        }

        public boolean visit(StructureItem structureItem) {
            if (structureItem.getName() != null && NameUtile.equals((String)this.address.address, (String)structureItem.getName().getIdentifier())) {
                this.result = structureItem;
                return false;
            }
            return true;
        }

        public boolean visit(EnumerationField enumerationField) {
            if (enumerationField.getName() != null && NameUtile.equals((String)this.address.address, (String)enumerationField.getName().getIdentifier())) {
                this.result = enumerationField;
                return false;
            }
            return true;
        }
    }

    private static class BoundFunctionBindingAddress
    extends BoundPartAddress {
        private FunctionMember functionBinding;

        public BoundFunctionBindingAddress(IFile declaringFile, String partName, FunctionMember binding) {
            super(declaringFile, partName);
            this.functionBinding = binding;
        }

        public FunctionMember getFunctionBinding() {
            return this.functionBinding;
        }
    }

    private class BoundFunctionNodeLocator
    extends AbstractASTVisitor {
        private BoundFunctionBindingAddress address;
        private Node result;
        private FunctionMember functionBinding;
        private List<FunctionParameter> fSearchFuncParaList;

        public BoundFunctionNodeLocator(BoundFunctionBindingAddress address) {
            this.address = address;
            this.functionBinding = address.getFunctionBinding();
            this.fSearchFuncParaList = this.functionBinding.getParameters();
        }

        public boolean visit(NestedFunction nestedFunction) {
            return this.visitFunctionMember((Node)nestedFunction, nestedFunction.getName().getIdentifier(), nestedFunction.getFunctionParameters());
        }

        public boolean visit(Constructor constructor) {
            return this.visitFunctionMember((Node)constructor, NameUtile.getAsName((String)"constructor"), constructor.getParameters());
        }

        private boolean visitFunctionMember(Node node, String funcName, List<org.eclipse.edt.compiler.core.ast.FunctionParameter> parms) {
            if (NameUtile.equals((String)this.address.getFunctionBinding().getName(), (String)funcName) && parms.size() == this.fSearchFuncParaList.size()) {
                Iterator<org.eclipse.edt.compiler.core.ast.FunctionParameter> aParaItr = parms.iterator();
                Iterator<FunctionParameter> fSearchParaItr = this.fSearchFuncParaList.iterator();
                while (aParaItr.hasNext()) {
                    org.eclipse.edt.compiler.core.ast.FunctionParameter aParameter = aParaItr.next();
                    FunctionParameter aSearchParameter = fSearchParaItr.next();
                    if (aSearchParameter.getType().equals(aParameter.getType().resolveType()).booleanValue()) continue;
                    return true;
                }
                this.result = node;
                return false;
            }
            return true;
        }
    }

    private static class BoundFunctionParameterBindingAddress
    extends BoundPartAddress {
        private String address;
        private String functionSignature;

        public BoundFunctionParameterBindingAddress(IFile declaringFile, String partName, FunctionParameter binding) {
            super(declaringFile, partName);
            this.address = binding.getName();
            this.functionSignature = BoundNodeLocationUtility.getSignature((FunctionMember)binding.getContainer());
        }
    }

    private class BoundFunctionParameterBindingNodeLocator
    extends AbstractASTVisitor {
        private BoundFunctionParameterBindingAddress address;
        private Node result;

        public BoundFunctionParameterBindingNodeLocator(BoundFunctionParameterBindingAddress address) {
            this.address = address;
        }

        public boolean visit(org.eclipse.edt.compiler.core.ast.FunctionParameter functionParameter) {
            Member binding = functionParameter.getName().resolveMember();
            if (binding instanceof FunctionParameter && NameUtile.equals((String)this.address.address, (String)binding.getName()) && this.address.functionSignature.equals(BoundNodeLocationUtility.getSignature((FunctionMember)((FunctionParameter)binding).getContainer()))) {
                this.result = functionParameter;
                return false;
            }
            return true;
        }
    }

    private static class BoundPartAddress
    implements IBoundNodeAddress {
        private IFile declaringFile;
        private String partName;

        public BoundPartAddress(IFile declaringFile, String partName) {
            this.declaringFile = declaringFile;
            this.partName = partName;
        }

        @Override
        public IFile getDeclaringFile() {
            return this.declaringFile;
        }

        @Override
        public String getPartName() {
            return this.partName;
        }
    }
}

