/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.search.matching.SearchPattern;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionPart;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Part;

public abstract class FunctionPattern
extends SearchPattern {
    protected char[] selector;
    protected char[] declaringQualification;
    protected char[] decodedSelector;
    protected int decodedParameterCount;

    public FunctionPattern(int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
    }

    public abstract String getPatternName();

    @Override
    protected boolean matchIndexEntry() {
        if (this.selector != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals((char[])this.selector, (char[])this.decodedSelector, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals((char[])this.selector, (char[])this.decodedSelector, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match((char[])this.selector, (char[])this.decodedSelector, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean needsResolve() {
        return this.declaringQualification != null;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append(this.getPatternName());
        if (this.selector != null) {
            buffer.append(this.selector);
        } else {
            buffer.append("*");
        }
        buffer.append('(');
        buffer.append(')');
        buffer.append(", ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }

    protected int matchLevelForType(char[] simpleNamePattern, char[] qualificationPattern, String packageName, String partName) {
        if (partName == null) {
            return 3;
        }
        StringBuffer qualifiedPartName = new StringBuffer();
        qualifiedPartName.append(partName);
        char[] qualifiedPackageName = packageName != null ? packageName.toCharArray() : null;
        char[] qualifiedSourceName = qualifiedPartName.toString().toCharArray();
        if (this.matchesType(simpleNamePattern, qualificationPattern, qualifiedPackageName == null ? qualifiedSourceName : CharOperation.concat((char[])qualifiedPackageName, (char[])qualifiedSourceName, (char)'.'))) {
            return 2;
        }
        if (qualificationPattern != null && new String(qualificationPattern).indexOf(46) == -1 && this.matchesType(CharOperation.concat((char[])qualificationPattern, (char[])simpleNamePattern, (char)'.'), null, qualifiedPackageName == null ? qualifiedSourceName : CharOperation.concat((char[])qualifiedPackageName, (char[])qualifiedSourceName, (char)'.'))) {
            return 2;
        }
        return 0;
    }

    @Override
    public int matchesFunctionPartType(Name node, FunctionPart partBinding) {
        if (partBinding != null) {
            return this.matchLevelForType(this.selector, this.declaringQualification, (Part)partBinding);
        }
        Member m = node.resolveMember();
        if (m instanceof FunctionMember) {
            String partName;
            String packageName;
            Container parent = m.getContainer();
            if (parent instanceof Classifier) {
                packageName = ((Classifier)parent).getCaseSensitivePackageName().length() > 0 ? ((Classifier)parent).getCaseSensitivePackageName() : null;
                partName = String.valueOf(((Classifier)parent).getCaseSensitiveName()) + "." + m.getCaseSensitiveName();
            } else {
                packageName = null;
                partName = m.getCaseSensitiveName();
            }
            return this.matchLevelForType(this.selector, this.declaringQualification, packageName, partName);
        }
        return 3;
    }

    @Override
    public int matchesFunctionPartType(IFunction function) {
        if (function != null) {
            return this.matchLevelForType(this.selector, this.declaringQualification, function);
        }
        return 3;
    }
}

