/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.search.processing;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.indexing.EGLModelSearchResources;
import org.eclipse.edt.ide.core.internal.model.search.processing.IJob;

public abstract class JobManager
implements Runnable {
    protected IJob[] awaitingJobs = new IJob[10];
    protected int jobStart = 0;
    protected int jobEnd = -1;
    protected boolean executing = false;
    protected Thread thread;
    private boolean enabled = true;
    public static boolean VERBOSE = false;
    public boolean activated = false;
    private int awaitingClients = 0;

    public static void verbose(String log) {
        System.out.println("(" + Thread.currentThread() + ") " + log);
    }

    public void activateProcessing() {
        this.activated = true;
    }

    public synchronized int awaitingJobsCount() {
        if (!this.activated) {
            return 1;
        }
        return this.jobEnd - this.jobStart + 1;
    }

    public synchronized IJob currentJob() {
        if (!this.enabled) {
            return null;
        }
        if (this.jobStart <= this.jobEnd) {
            return this.awaitingJobs[this.jobStart];
        }
        return null;
    }

    public synchronized void disable() {
        this.enabled = false;
        if (VERBOSE) {
            JobManager.verbose("DISABLING background indexing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardJobs(String jobFamily) {
        if (VERBOSE) {
            JobManager.verbose("DISCARD   background job family - " + jobFamily);
        }
        boolean wasEnabled = this.isEnabled();
        try {
            IJob currentJob;
            JobManager jobManager = this;
            synchronized (jobManager) {
                currentJob = this.currentJob();
                this.disable();
            }
            if (currentJob != null && (jobFamily == null || currentJob.belongsTo(jobFamily))) {
                currentJob.cancel();
                while (this.thread != null && this.executing) {
                    try {
                        if (VERBOSE) {
                            JobManager.verbose("-> waiting end of current background job - " + currentJob);
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            int loc = -1;
            JobManager jobManager2 = this;
            synchronized (jobManager2) {
                int i = this.jobStart;
                while (i <= this.jobEnd) {
                    currentJob = this.awaitingJobs[i];
                    this.awaitingJobs[i] = null;
                    if (jobFamily != null && !currentJob.belongsTo(jobFamily)) {
                        this.awaitingJobs[++loc] = currentJob;
                    } else {
                        if (VERBOSE) {
                            JobManager.verbose("-> discarding background job  - " + currentJob);
                        }
                        currentJob.cancel();
                    }
                    ++i;
                }
                this.jobStart = 0;
                this.jobEnd = loc;
            }
        }
        finally {
            if (wasEnabled) {
                this.enable();
            }
        }
        if (VERBOSE) {
            JobManager.verbose("DISCARD   DONE with background job family - " + jobFamily);
        }
    }

    public synchronized void enable() {
        this.enabled = true;
        if (VERBOSE) {
            JobManager.verbose("ENABLING  background indexing");
        }
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    protected synchronized void moveToNextJob() {
        if (this.jobStart <= this.jobEnd) {
            this.awaitingJobs[this.jobStart++] = null;
            if (this.jobStart > this.jobEnd) {
                this.jobStart = 0;
                this.jobEnd = -1;
            }
        }
    }

    protected void notifyIdle(long idlingTime) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean performConcurrentJob(IJob searchJob, int waitingPolicy, IProgressMonitor progress) {
        block42: {
            if (JobManager.VERBOSE) {
                JobManager.verbose("STARTING  concurrent job - " + searchJob);
            }
            if (!searchJob.isReadyToRun()) {
                if (JobManager.VERBOSE) {
                    JobManager.verbose("ABORTED   concurrent job - " + searchJob);
                }
                return false;
            }
            concurrentJobWork = 100;
            if (progress != null) {
                progress.beginTask("", concurrentJobWork);
            }
            status = false;
            if (this.awaitingJobsCount() <= 0) break block42;
            switch (waitingPolicy) {
                case 1: {
                    if (JobManager.VERBOSE) {
                        JobManager.verbose("-> NOT READY - forcing immediate - " + searchJob);
                    }
                    wasEnabled = this.isEnabled();
                    try {
                        this.disable();
                        status = searchJob.execute((IProgressMonitor)(progress == null ? null : new SubProgressMonitor(progress, concurrentJobWork)));
                    }
                    finally {
                        if (wasEnabled) {
                            this.enable();
                        }
                    }
                    if (JobManager.VERBOSE) {
                        JobManager.verbose("FINISHED  concurrent job - " + searchJob);
                    }
                    return status;
                }
                case 2: {
                    if (JobManager.VERBOSE) {
                        JobManager.verbose("-> NOT READY - cancelling - " + searchJob);
                    }
                    if (progress != null) {
                        progress.setCanceled(true);
                    }
                    if (JobManager.VERBOSE) {
                        JobManager.verbose("CANCELED concurrent job - " + searchJob);
                    }
                    throw new OperationCanceledException();
                }
                case 3: {
                    previousJob = null;
                    subProgress = null;
                    totalWork = this.awaitingJobsCount();
                    if (progress != null && totalWork > 0) {
                        subProgress = new SubProgressMonitor(progress, concurrentJobWork / 2);
                        subProgress.beginTask("", totalWork);
                        concurrentJobWork /= 2;
                    }
                    originalPriority = this.thread.getPriority();
                    try {
                        var13_13 = this;
                        synchronized (var13_13) {
                            t = this.thread;
                            if (t != null) {
                                t.setPriority(Thread.currentThread().getPriority());
                            }
                            ++this.awaitingClients;
                            // MONITOREXIT @DISABLED, blocks:[1, 2, 6, 9, 12] lbl53 : MonitorExitStatement: MONITOREXIT : var13_13
                            if (true) ** GOTO lbl72
                        }
                        do {
                            if (subProgress != null && subProgress.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            currentJob = this.currentJob();
                            if (currentJob != null && currentJob != previousJob) {
                                if (JobManager.VERBOSE) {
                                    JobManager.verbose("-> NOT READY - waiting until ready - " + searchJob);
                                }
                                if (subProgress != null) {
                                    subProgress.subTask(EGLModelSearchResources.bind((String)EGLModelSearchResources.ManagerFilesToIndex, (Object)Integer.toString(awaitingWork)));
                                    subProgress.worked(1);
                                }
                                previousJob = currentJob;
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException v1) {}
lbl72:
                            // 3 sources

                        } while ((awaitingWork = this.awaitingJobsCount()) > 0);
                    }
                    catch (Throwable var15_16) {
                        var16_17 = this;
                        synchronized (var16_17) {
                            --this.awaitingClients;
                            t = this.thread;
                            if (t != null) {
                                t.setPriority(originalPriority);
                            }
                        }
                        throw var15_16;
                    }
                    var16_18 = this;
                    synchronized (var16_18) {
                        --this.awaitingClients;
                        t = this.thread;
                        if (t != null) {
                            t.setPriority(originalPriority);
                        }
                    }
                    if (subProgress == null) break;
                    subProgress.done();
                }
            }
        }
        status = searchJob.execute((IProgressMonitor)(progress == null ? null : new SubProgressMonitor(progress, concurrentJobWork)));
        if (progress != null) {
            progress.done();
        }
        if (JobManager.VERBOSE) {
            JobManager.verbose("FINISHED  concurrent job - " + searchJob);
        }
        return status;
    }

    public abstract String processName();

    public synchronized void request(IJob job) {
        if (!job.isReadyToRun()) {
            if (VERBOSE) {
                JobManager.verbose("ABORTED request of background job - " + job);
            }
            return;
        }
        int size = this.awaitingJobs.length;
        if (++this.jobEnd == size) {
            this.jobEnd -= this.jobStart;
            this.awaitingJobs = new IJob[size * 2];
            System.arraycopy(this.awaitingJobs, this.jobStart, this.awaitingJobs, 0, this.jobEnd);
            this.jobStart = 0;
        }
        this.awaitingJobs[this.jobEnd] = job;
        if (VERBOSE) {
            JobManager.verbose("REQUEST   background job - " + job);
        }
    }

    public void reset() {
        if (VERBOSE) {
            JobManager.verbose("Reset");
        }
        if (this.thread != null) {
            this.discardJobs(null);
        } else {
            this.thread = new Thread((Runnable)this, this.processName());
            this.thread.setDaemon(true);
            this.thread.setPriority(4);
            this.thread.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long idlingStart = -1L;
        this.activateProcessing();
        try {
            while (true) {
                if (this.thread == null) {
                    return;
                }
                try {
                    IJob job = this.currentJob();
                    if (job == null) {
                        if (idlingStart < 0L) {
                            idlingStart = System.currentTimeMillis();
                        }
                        this.notifyIdle(System.currentTimeMillis() - idlingStart);
                        Thread.sleep(500L);
                        continue;
                    }
                    idlingStart = -1L;
                    if (VERBOSE) {
                        JobManager.verbose(String.valueOf(this.awaitingJobsCount()) + " awaiting jobs");
                        JobManager.verbose("STARTING background job - " + job);
                    }
                    try {
                        this.executing = true;
                        job.execute(null);
                    }
                    finally {
                        this.executing = false;
                        if (VERBOSE) {
                            JobManager.verbose("FINISHED background job - " + job);
                        }
                        this.moveToNextJob();
                        if (this.awaitingClients == 0) {
                            Thread.sleep(50L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (RuntimeException e) {
            if (this.thread == null) throw e;
            Util.log(e, "Background Indexer Crash Recovery");
            this.discardJobs(null);
            this.thread = null;
            this.reset();
            throw e;
        }
        catch (Error e) {
            if (this.thread == null) throw e;
            if (e instanceof ThreadDeath) throw e;
            Util.log(e, "Background Indexer Crash Recovery");
            this.discardJobs(null);
            this.thread = null;
            this.reset();
            throw e;
        }
    }

    public void shutdown() {
        this.disable();
        this.discardJobs(null);
        Thread thread = this.thread;
        this.thread = null;
        try {
            if (thread != null) {
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append("Enabled:").append(this.enabled).append('\n');
        int numJobs = this.jobEnd - this.jobStart + 1;
        buffer.append("Jobs in queue:").append(numJobs).append('\n');
        int i = 0;
        while (i < numJobs && i < 15) {
            buffer.append(i).append(" - job[" + i + "]: ").append(this.awaitingJobs[this.jobStart + i]).append('\n');
            ++i;
        }
        return buffer.toString();
    }
}

