/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.index.impl;

import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.index.impl.WordEntry;

public final class WordEntryHashedArray {
    public WordEntry[] elements;
    public int elementSize;
    public int threshold;

    public WordEntryHashedArray(int size) {
        if (size < 7) {
            size = 7;
        }
        this.elements = new WordEntry[2 * size + 1];
        this.elementSize = 0;
        this.threshold = size + 1;
    }

    public WordEntry add(WordEntry entry) {
        WordEntry current;
        int length = this.elements.length;
        char[] word = entry.getWord();
        int index = CharOperation.hashCode((char[])word) % length;
        while ((current = this.elements[index]) != null) {
            if (CharOperation.equals((char[])current.getWord(), (char[])word)) {
                this.elements[index] = entry;
                return this.elements[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        this.elements[index] = entry;
        if (++this.elementSize > this.threshold) {
            this.grow();
        }
        return entry;
    }

    public WordEntry[] asArray() {
        WordEntry[] array = new WordEntry[this.elementSize];
        int count = 0;
        int i = 0;
        int length = this.elements.length;
        while (i < length) {
            WordEntry current = this.elements[i];
            if (current != null) {
                array[count++] = current;
            }
            ++i;
        }
        if (count < array.length) {
            WordEntry[] wordEntryArray = array;
            array = new WordEntry[count];
            System.arraycopy(wordEntryArray, 0, array, 0, count);
        }
        return array;
    }

    public WordEntry get(char[] word) {
        WordEntry current;
        int length = this.elements.length;
        int index = CharOperation.hashCode((char[])word) % length;
        while ((current = this.elements[index]) != null) {
            if (CharOperation.equals((char[])current.getWord(), (char[])word)) {
                return current;
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    private void grow() {
        WordEntryHashedArray newArray = new WordEntryHashedArray(this.elementSize * 2);
        int i = 0;
        int length = this.elements.length;
        while (i < length) {
            if (this.elements[i] != null) {
                newArray.add(this.elements[i]);
            }
            ++i;
        }
        this.elements = newArray.elements;
        this.elementSize = newArray.elementSize;
        this.threshold = newArray.threshold;
    }

    public String toString() {
        String s = "";
        WordEntry[] entries = this.asArray();
        int i = 0;
        int length = entries.length;
        while (i < length) {
            s = String.valueOf(s) + entries[i].toString() + "\n";
            ++i;
        }
        return s;
    }
}

